/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.enricher.generic.openshift;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KubernetesListBuilder;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.ServicePort;
import io.fabric8.kubernetes.api.model.ServiceSpec;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jkube.kit.common.util.KubernetesHelper;
import org.eclipse.jkube.kit.config.resource.PlatformMode;
import org.eclipse.jkube.kit.enricher.api.BaseEnricher;
import org.eclipse.jkube.kit.enricher.api.EnricherContext;
import org.eclipse.jkube.kit.enricher.api.JKubeEnricherContext;

public class ExposeEnricher
extends BaseEnricher {
    public static final String EXPOSE_LABEL = "expose";
    private Set<Integer> webPorts = new HashSet<Integer>(Arrays.asList(80, 443, 8080, 9080, 9090, 9443));

    public ExposeEnricher(JKubeEnricherContext buildContext) {
        super((EnricherContext)buildContext, "jkube-openshift-service-expose");
    }

    public void create(PlatformMode platformMode, KubernetesListBuilder builder) {
        List items = builder.buildItems();
        if (items != null) {
            for (HasMetadata item : items) {
                if (!(item instanceof Service)) continue;
                Service service = (Service)item;
                this.enrichService(service);
            }
        }
    }

    private void enrichService(Service service) {
        if (this.hasWebPort(service)) {
            Map labels;
            ObjectMeta metadata = service.getMetadata();
            if (metadata == null) {
                metadata = new ObjectMeta();
                service.setMetadata(metadata);
            }
            if (!(labels = KubernetesHelper.getOrCreateLabels((HasMetadata)service)).containsKey(EXPOSE_LABEL)) {
                labels.put(EXPOSE_LABEL, "true");
                this.log.verbose("Adding Service label '%s:true' on service %s so that it is exposed by the exposecontroller microservice. To disable use the maven argument: '-Dfabric8.profile=internal-microservice'", new Object[]{EXPOSE_LABEL, KubernetesHelper.getName((HasMetadata)service)});
            }
        }
    }

    private boolean hasWebPort(Service service) {
        List ports;
        ServiceSpec spec = service.getSpec();
        if (spec != null && (ports = spec.getPorts()) != null) {
            for (ServicePort port : ports) {
                Integer portNumber = port.getPort();
                if (portNumber == null || !this.webPorts.contains(portNumber)) continue;
                return true;
            }
        }
        return false;
    }
}

