/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.enricher.generic;

import io.fabric8.kubernetes.api.builder.TypedVisitor;
import io.fabric8.kubernetes.api.builder.Visitor;
import io.fabric8.kubernetes.api.model.ConfigMap;
import io.fabric8.kubernetes.api.model.ConfigMapBuilder;
import io.fabric8.kubernetes.api.model.ConfigMapFluent;
import io.fabric8.kubernetes.api.model.KubernetesListBuilder;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Base64;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import org.eclipse.jkube.kit.config.resource.ConfigMapEntry;
import org.eclipse.jkube.kit.config.resource.PlatformMode;
import org.eclipse.jkube.kit.config.resource.ResourceConfig;
import org.eclipse.jkube.kit.enricher.api.BaseEnricher;
import org.eclipse.jkube.kit.enricher.api.EnricherContext;
import org.eclipse.jkube.kit.enricher.api.JKubeEnricherContext;

public class ConfigMapEnricher
extends BaseEnricher {
    @Deprecated
    protected static final String PREFIX_ANNOTATION = "maven.jkube.io/cm/";
    protected static final String CONFIGMAP_PREFIX_ANNOTATION = "jkube.eclipse.org/cm/";

    public ConfigMapEnricher(JKubeEnricherContext enricherContext) {
        super((EnricherContext)enricherContext, "jkube-configmap-file");
    }

    public void create(PlatformMode platformMode, KubernetesListBuilder builder) {
        this.addAnnotations(builder);
        this.addConfigMapFromResourceConfigurations(builder);
    }

    private void addAnnotations(KubernetesListBuilder builder) {
        builder.accept(new Visitor[]{new TypedVisitor<ConfigMapBuilder>(){

            public void visit(ConfigMapBuilder element) {
                Map annotations = element.buildMetadata().getAnnotations();
                if (annotations != null) {
                    try {
                        ConfigMapEnricher.this.addConfigMapFromAnnotations(annotations, element);
                    }
                    catch (IOException e) {
                        throw new IllegalArgumentException(e);
                    }
                }
            }
        }});
    }

    private void addConfigMapFromAnnotations(Map<String, String> annotations, ConfigMapBuilder configMapBuilder) throws IOException {
        Set<Map.Entry<String, String>> entries = annotations.entrySet();
        Iterator<Map.Entry<String, String>> it = entries.iterator();
        while (it.hasNext()) {
            Map.Entry<String, String> entry = it.next();
            String key = entry.getKey();
            if (!key.startsWith(PREFIX_ANNOTATION) && !key.startsWith(CONFIGMAP_PREFIX_ANNOTATION)) continue;
            this.addConfigMapEntryFromDirOrFile(configMapBuilder, this.getOutput(key), entry.getValue());
            it.remove();
        }
    }

    private void addConfigMapEntryFromDirOrFile(ConfigMapBuilder configMapBuilder, String key, String dirOrFilePath) throws IOException {
        Path path = Paths.get(dirOrFilePath, new String[0]);
        if (Files.isDirectory(path, LinkOption.NOFOLLOW_LINKS)) {
            try (Stream<Path> files = Files.list(path);){
                files.filter(p -> !Files.isDirectory(p, LinkOption.NOFOLLOW_LINKS)).forEach(file -> {
                    try {
                        this.addConfigMapEntryFromFile(configMapBuilder, file.getFileName().toString(), (Path)file);
                    }
                    catch (IOException e) {
                        throw new IllegalArgumentException(e);
                    }
                });
            }
        } else {
            this.addConfigMapEntryFromFile(configMapBuilder, key, path);
        }
    }

    private void addConfigMapEntryFromFile(ConfigMapBuilder configMapBuilder, String key, Path file) throws IOException {
        byte[] bytes = Files.readAllBytes(file);
        try {
            StandardCharsets.UTF_8.newDecoder().onMalformedInput(CodingErrorAction.REPORT).onUnmappableCharacter(CodingErrorAction.REPORT).decode(ByteBuffer.wrap(bytes));
            String value = new String(bytes);
            configMapBuilder.addToData(Collections.singletonMap(key, value));
        }
        catch (CharacterCodingException e) {
            String value = Base64.getEncoder().encodeToString(bytes);
            configMapBuilder.addToBinaryData(Collections.singletonMap(key, value));
        }
    }

    private String getOutput(String key) {
        if (key.startsWith(PREFIX_ANNOTATION)) {
            return key.substring(PREFIX_ANNOTATION.length());
        }
        return key.substring(CONFIGMAP_PREFIX_ANNOTATION.length());
    }

    private void addConfigMapFromResourceConfigurations(KubernetesListBuilder builder) {
        org.eclipse.jkube.kit.config.resource.ConfigMap configMapResourceConfiguration = this.getConfigMapFromXmlConfiguration();
        try {
            String configMapName;
            if (configMapResourceConfiguration == null) {
                return;
            }
            String string = configMapName = configMapResourceConfiguration.getName() == null || configMapResourceConfiguration.getName().trim().isEmpty() ? "jkubeconfig" : configMapResourceConfiguration.getName().trim();
            if (this.checkIfItemExists(builder, configMapName)) {
                return;
            }
            ConfigMap configMap = this.createConfigMapFromConfiguration(configMapResourceConfiguration, configMapName);
            if (configMap.getData() != null && !configMap.getData().isEmpty() || configMap.getBinaryData() != null && !configMap.getBinaryData().isEmpty()) {
                builder.addToConfigMapItems(new ConfigMap[]{configMap});
            }
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private ConfigMap createConfigMapFromConfiguration(org.eclipse.jkube.kit.config.resource.ConfigMap configMap, String configMapName) throws IOException {
        ConfigMapBuilder configMapBuilder = new ConfigMapBuilder();
        ((ConfigMapFluent.MetadataNested)configMapBuilder.withNewMetadata().withName(configMapName)).endMetadata();
        for (ConfigMapEntry configMapEntry : configMap.getEntries()) {
            String name = configMapEntry.getName();
            String value = configMapEntry.getValue();
            if (name != null && value != null) {
                configMapBuilder.addToData(name, value);
                continue;
            }
            String file = configMapEntry.getFile();
            if (file == null) continue;
            if (name == null) {
                name = Paths.get(file, new String[0]).getFileName().toString();
            }
            this.addConfigMapEntryFromDirOrFile(configMapBuilder, name, file);
        }
        return configMapBuilder.build();
    }

    private boolean checkIfItemExists(KubernetesListBuilder builder, String name) {
        return builder.buildItems().stream().filter(item -> item.getKind().equals("ConfigMap")).anyMatch(item -> item.getMetadata().getName().equals(name));
    }

    private org.eclipse.jkube.kit.config.resource.ConfigMap getConfigMapFromXmlConfiguration() {
        ResourceConfig resourceConfig = this.getConfiguration().getResource();
        if (resourceConfig != null && resourceConfig.getConfigMap() != null) {
            return resourceConfig.getConfigMap();
        }
        return null;
    }
}

