/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.enricher.generic;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KubernetesListBuilder;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.PodTemplateSpec;
import java.util.List;
import java.util.Map;
import org.eclipse.jkube.kit.common.util.MapUtil;
import org.eclipse.jkube.kit.config.resource.PlatformMode;
import org.eclipse.jkube.kit.enricher.api.BaseEnricher;
import org.eclipse.jkube.kit.enricher.api.EnricherContext;
import org.eclipse.jkube.kit.enricher.handler.ControllerHandler;

public class PodAnnotationEnricher
extends BaseEnricher {
    public PodAnnotationEnricher(EnricherContext buildContext) {
        super(buildContext, "jkube-pod-annotations");
    }

    public void enrich(PlatformMode platformMode, KubernetesListBuilder builder) {
        super.enrich(platformMode, builder);
        List items = builder.buildItems();
        for (HasMetadata item : items) {
            PodTemplateSpec template;
            ControllerHandler controllerHandler = this.getContext().getHandlerHub().getHandlerFor(item);
            if (controllerHandler == null || (template = controllerHandler.getPodTemplate(item)) == null) continue;
            if (template.getMetadata() == null) {
                template.setMetadata(new ObjectMeta());
            }
            ObjectMeta templateMetadata = template.getMetadata();
            templateMetadata.setAnnotations(MapUtil.mergeMaps((Map)templateMetadata.getAnnotations(), (Map)item.getMetadata().getAnnotations()));
        }
        builder.withItems(items);
    }
}

