/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.enricher.generic;

import io.fabric8.kubernetes.api.builder.TypedVisitor;
import io.fabric8.kubernetes.api.builder.Visitor;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KubernetesListBuilder;
import io.fabric8.kubernetes.api.model.PodSpec;
import io.fabric8.kubernetes.api.model.PodTemplateSpecFluent;
import io.fabric8.kubernetes.api.model.ServiceAccount;
import io.fabric8.kubernetes.api.model.ServiceAccountBuilder;
import io.fabric8.kubernetes.api.model.ServiceAccountFluent;
import io.fabric8.kubernetes.api.model.apps.DeploymentBuilder;
import io.fabric8.kubernetes.api.model.apps.DeploymentFluent;
import io.fabric8.kubernetes.api.model.apps.DeploymentSpecFluent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jkube.kit.common.Configs;
import org.eclipse.jkube.kit.common.util.JKubeProjectUtil;
import org.eclipse.jkube.kit.config.resource.PlatformMode;
import org.eclipse.jkube.kit.config.resource.ResourceConfig;
import org.eclipse.jkube.kit.config.resource.ServiceAccountConfig;
import org.eclipse.jkube.kit.enricher.api.BaseEnricher;
import org.eclipse.jkube.kit.enricher.api.EnricherContext;
import org.eclipse.jkube.kit.enricher.api.JKubeEnricherContext;

public class ServiceAccountEnricher
extends BaseEnricher {
    public ServiceAccountEnricher(JKubeEnricherContext enricherContext) {
        super((EnricherContext)enricherContext, "jkube-serviceaccount");
    }

    public void create(PlatformMode mode, KubernetesListBuilder builder) {
        HashMap<String, String> deploymentToSaPair = new HashMap<String, String>();
        ResourceConfig resourceConfig = this.getConfiguration().getResource();
        if (resourceConfig != null && resourceConfig.getServiceAccounts() != null) {
            deploymentToSaPair.putAll(resourceConfig.getServiceAccounts().stream().filter(sa -> sa.getDeploymentRef() != null).collect(Collectors.toMap(ServiceAccountConfig::getDeploymentRef, ServiceAccountConfig::getName)));
        }
        if (resourceConfig != null && StringUtils.isNotBlank((CharSequence)resourceConfig.getServiceAccount())) {
            deploymentToSaPair.put(JKubeProjectUtil.createDefaultResourceName((String)this.getContext().getGav().getSanitizedArtifactId(), (String[])new String[0]), resourceConfig.getServiceAccount());
        }
        builder.addAllToServiceAccountItems(this.createServiceAccountFromResourceConfig(resourceConfig));
        builder.addAllToServiceAccountItems(this.createServiceAccountsReferencedInDeployment(builder, deploymentToSaPair));
    }

    private List<ServiceAccount> createServiceAccountFromResourceConfig(ResourceConfig resourceConfig) {
        ArrayList<ServiceAccount> serviceAccounts = new ArrayList<ServiceAccount>();
        if (resourceConfig != null && resourceConfig.getServiceAccounts() != null && !Boolean.parseBoolean(this.getConfig(Config.SKIP_CREATE))) {
            for (ServiceAccountConfig serviceAccountConfig : resourceConfig.getServiceAccounts()) {
                if (serviceAccountConfig.getName() == null) continue;
                serviceAccounts.add(this.createServiceAccount(serviceAccountConfig.getName()));
            }
        }
        return serviceAccounts;
    }

    private List<ServiceAccount> createServiceAccountsReferencedInDeployment(final KubernetesListBuilder builder, final Map<String, String> deploymentToSaPair) {
        final ArrayList<ServiceAccount> serviceAccounts = new ArrayList<ServiceAccount>();
        builder.accept(new Visitor[]{new TypedVisitor<DeploymentBuilder>(){

            public void visit(DeploymentBuilder deploymentBuilder) {
                PodSpec podSpec;
                String serviceAccountName = ServiceAccountEnricher.this.getServiceAccountNameFromSpec(deploymentBuilder);
                if (serviceAccountName != null && ServiceAccountEnricher.this.getServiceAccountFromList(builder, serviceAccountName) == null && !Boolean.parseBoolean(ServiceAccountEnricher.this.getConfig(Config.SKIP_CREATE))) {
                    serviceAccounts.add(ServiceAccountEnricher.this.createServiceAccount(serviceAccountName));
                }
                if (deploymentToSaPair.containsKey(deploymentBuilder.buildMetadata().getName()) && StringUtils.isBlank((CharSequence)(podSpec = deploymentBuilder.buildSpec().getTemplate().getSpec()).getServiceAccount()) && StringUtils.isBlank((CharSequence)podSpec.getServiceAccountName())) {
                    ((DeploymentFluent.SpecNested)((DeploymentSpecFluent.TemplateNested)((PodTemplateSpecFluent.SpecNested)deploymentBuilder.editSpec().editTemplate().editSpec().withServiceAccountName((String)deploymentToSaPair.get(deploymentBuilder.buildMetadata().getName()))).endSpec()).endTemplate()).endSpec();
                }
            }
        }});
        return serviceAccounts;
    }

    private ServiceAccount createServiceAccount(String serviceAccountName) {
        return ((ServiceAccountBuilder)((ServiceAccountFluent.MetadataNested)new ServiceAccountBuilder().withNewMetadata().withName(serviceAccountName)).endMetadata()).build();
    }

    private String getServiceAccountNameFromSpec(DeploymentBuilder builder) {
        if (builder.buildSpec().getTemplate().getSpec().getServiceAccountName() != null) {
            return builder.buildSpec().getTemplate().getSpec().getServiceAccountName();
        }
        if (builder.buildSpec().getTemplate().getSpec().getServiceAccount() != null) {
            return builder.buildSpec().getTemplate().getSpec().getServiceAccount();
        }
        return null;
    }

    private ServiceAccount getServiceAccountFromList(KubernetesListBuilder builder, String serviceAccountName) {
        for (HasMetadata item : builder.buildItems()) {
            if (!(item instanceof ServiceAccount) || !item.getMetadata().getName().equals(serviceAccountName)) continue;
            return (ServiceAccount)item;
        }
        return null;
    }

    public static enum Config implements Configs.Config
    {
        SKIP_CREATE("skipCreate", "false");

        protected String key;
        protected String defaultValue;

        private Config(String key, String defaultValue) {
            this.key = key;
            this.defaultValue = defaultValue;
        }

        public String getKey() {
            return this.key;
        }

        public String getDefaultValue() {
            return this.defaultValue;
        }
    }
}

