/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.enricher.generic.openshift;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KubernetesListBuilder;
import io.fabric8.kubernetes.api.model.LabelSelector;
import io.fabric8.kubernetes.api.model.PodSpec;
import io.fabric8.kubernetes.api.model.PodTemplateSpec;
import io.fabric8.kubernetes.api.model.apps.Deployment;
import io.fabric8.kubernetes.api.model.extensions.DeploymentSpec;
import io.fabric8.openshift.api.model.DeploymentConfig;
import io.fabric8.openshift.api.model.DeploymentConfigBuilder;
import io.fabric8.openshift.api.model.DeploymentConfigSpec;
import io.fabric8.openshift.api.model.DeploymentConfigSpecBuilder;
import io.fabric8.openshift.api.model.DeploymentConfigSpecFluent;
import io.fabric8.openshift.api.model.DeploymentStrategy;
import io.fabric8.openshift.api.model.DeploymentStrategyBuilder;
import io.fabric8.openshift.api.model.DeploymentStrategyFluent;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jkube.enricher.generic.DefaultControllerEnricher;
import org.eclipse.jkube.kit.common.Configs;
import org.eclipse.jkube.kit.config.resource.PlatformMode;
import org.eclipse.jkube.kit.enricher.api.BaseEnricher;
import org.eclipse.jkube.kit.enricher.api.EnricherConfig;
import org.eclipse.jkube.kit.enricher.api.EnricherContext;
import org.eclipse.jkube.kit.enricher.api.util.KubernetesResourceUtil;

public class DeploymentConfigEnricher
extends BaseEnricher {
    private static final String ENRICHER_NAME = "jkube-openshift-deploymentconfig";

    public DeploymentConfigEnricher(EnricherContext context) {
        super(context, ENRICHER_NAME);
    }

    public void create(PlatformMode platformMode, KubernetesListBuilder builder) {
        if (this.isApplicable(platformMode)) {
            for (HasMetadata item : builder.buildItems()) {
                DeploymentConfig deploymentConfig;
                if (item instanceof Deployment) {
                    deploymentConfig = this.convertFromAppsV1Deployment(item);
                    KubernetesResourceUtil.removeItemFromKubernetesBuilder((KubernetesListBuilder)builder, (HasMetadata)item);
                    builder.addToItems(new HasMetadata[]{deploymentConfig});
                    this.log.info("Converting Deployment to DeploymentConfig", new Object[0]);
                    continue;
                }
                if (!(item instanceof io.fabric8.kubernetes.api.model.extensions.Deployment)) continue;
                deploymentConfig = this.convertFromExtensionsV1Beta1Deployment(item);
                KubernetesResourceUtil.removeItemFromKubernetesBuilder((KubernetesListBuilder)builder, (HasMetadata)item);
                builder.addToItems(new HasMetadata[]{deploymentConfig});
                this.log.info("Converting Deployment to DeploymentConfig", new Object[0]);
            }
        }
    }

    private boolean isApplicable(PlatformMode platformMode) {
        return platformMode == PlatformMode.openshift && !this.useDeploymentForOpenShift() && this.isNotHandledByDefaultControllerEnricher();
    }

    private boolean isNotHandledByDefaultControllerEnricher() {
        String type = new EnricherConfig("jkube-controller", this.getContext()).get((Configs.Config)DefaultControllerEnricher.Config.TYPE, "DeploymentConfig");
        return type.equalsIgnoreCase("DeploymentConfig");
    }

    private DeploymentConfig convertFromAppsV1Deployment(HasMetadata item) {
        Deployment resource = (Deployment)item;
        DeploymentConfigBuilder builder = new DeploymentConfigBuilder();
        builder.withMetadata(resource.getMetadata());
        io.fabric8.kubernetes.api.model.apps.DeploymentSpec spec = resource.getSpec();
        if (spec != null) {
            builder.withSpec(this.getDeploymentConfigSpec(spec.getReplicas(), spec.getRevisionHistoryLimit(), spec.getSelector(), spec.getTemplate(), spec.getStrategy() != null ? spec.getStrategy().getType() : null));
        }
        return builder.build();
    }

    private DeploymentConfig convertFromExtensionsV1Beta1Deployment(HasMetadata item) {
        io.fabric8.kubernetes.api.model.extensions.Deployment resource = (io.fabric8.kubernetes.api.model.extensions.Deployment)item;
        DeploymentConfigBuilder builder = new DeploymentConfigBuilder();
        builder.withMetadata(resource.getMetadata());
        DeploymentSpec spec = resource.getSpec();
        if (spec != null) {
            builder.withSpec(this.getDeploymentConfigSpec(spec.getReplicas(), spec.getRevisionHistoryLimit(), spec.getSelector(), spec.getTemplate(), spec.getStrategy() != null ? spec.getStrategy().getType() : null));
        }
        return builder.build();
    }

    private DeploymentConfigSpec getDeploymentConfigSpec(Integer replicas, Integer revisionHistoryLimit, LabelSelector selector, PodTemplateSpec podTemplateSpec, String strategyType) {
        DeploymentStrategy deploymentStrategy;
        Map matchLabels;
        DeploymentConfigSpecBuilder specBuilder = new DeploymentConfigSpecBuilder();
        if (replicas != null) {
            specBuilder.withReplicas(replicas);
        }
        if (revisionHistoryLimit != null) {
            specBuilder.withRevisionHistoryLimit(revisionHistoryLimit);
        }
        if (selector != null && (matchLabels = selector.getMatchLabels()) != null && !matchLabels.isEmpty()) {
            specBuilder.withSelector(matchLabels);
        }
        if (podTemplateSpec != null) {
            specBuilder.withTemplate(podTemplateSpec);
            PodSpec podSpec = podTemplateSpec.getSpec();
            Objects.requireNonNull(podSpec, "No PodSpec for PodTemplate:" + podTemplateSpec);
            Objects.requireNonNull(podSpec, "No containers for PodTemplate.spec: " + podTemplateSpec);
        }
        if ((deploymentStrategy = this.getDeploymentStrategy(strategyType)) != null) {
            specBuilder.withStrategy(deploymentStrategy);
        }
        if (this.getValueFromConfig("jkube.openshift.enableAutomaticTrigger", true)) {
            ((DeploymentConfigSpecFluent.TriggersNested)specBuilder.addNewTrigger().withType("ConfigChange")).endTrigger();
        }
        return specBuilder.build();
    }

    private DeploymentStrategy getDeploymentStrategy(String strategyType) {
        long openshiftDeployTimeoutSeconds = this.getOpenshiftDeployTimeoutInSeconds(3600L);
        if (openshiftDeployTimeoutSeconds > 0L) {
            if (StringUtils.isBlank((CharSequence)strategyType) || "Rolling".equals(strategyType)) {
                return ((DeploymentStrategyBuilder)((DeploymentStrategyFluent.RollingParamsNested)((DeploymentStrategyBuilder)new DeploymentStrategyBuilder().withType("Rolling")).withNewRollingParams().withTimeoutSeconds(Long.valueOf(openshiftDeployTimeoutSeconds))).endRollingParams()).build();
            }
            if ("Recreate".equals(strategyType)) {
                return ((DeploymentStrategyBuilder)((DeploymentStrategyFluent.RecreateParamsNested)((DeploymentStrategyBuilder)new DeploymentStrategyBuilder().withType("Recreate")).withNewRecreateParams().withTimeoutSeconds(Long.valueOf(openshiftDeployTimeoutSeconds))).endRecreateParams()).build();
            }
            return ((DeploymentStrategyBuilder)new DeploymentStrategyBuilder().withType(strategyType)).build();
        }
        if (StringUtils.isNotBlank((CharSequence)strategyType)) {
            return ((DeploymentStrategyBuilder)new DeploymentStrategyBuilder().withType(strategyType)).build();
        }
        return null;
    }
}

