/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.enricher.generic;

import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KubernetesListBuilder;
import io.fabric8.kubernetes.api.model.PodTemplateSpec;
import io.fabric8.kubernetes.api.model.ReplicationController;
import io.fabric8.kubernetes.api.model.apps.DaemonSet;
import io.fabric8.kubernetes.api.model.apps.Deployment;
import io.fabric8.kubernetes.api.model.apps.ReplicaSet;
import io.fabric8.kubernetes.api.model.apps.StatefulSet;
import io.fabric8.kubernetes.api.model.batch.v1.CronJob;
import io.fabric8.kubernetes.api.model.batch.v1.Job;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.eclipse.jkube.enricher.generic.ControllerViaPluginConfigurationEnricher;
import org.eclipse.jkube.kit.common.Configs;
import org.eclipse.jkube.kit.common.util.JKubeProjectUtil;
import org.eclipse.jkube.kit.config.resource.ControllerResourceConfig;
import org.eclipse.jkube.kit.config.resource.PlatformMode;
import org.eclipse.jkube.kit.enricher.api.BaseEnricher;
import org.eclipse.jkube.kit.enricher.api.EnricherContext;
import org.eclipse.jkube.kit.enricher.api.util.KubernetesResourceUtil;
import org.eclipse.jkube.kit.enricher.handler.ControllerHandler;

public class DefaultControllerEnricher
extends BaseEnricher {
    public static final String ENRICHER_NAME = "jkube-controller";
    private static final Map<String, Class<? extends HasMetadata>> CONTROLLER_TYPES = new HashMap<String, Class<? extends HasMetadata>>();

    public DefaultControllerEnricher(EnricherContext buildContext) {
        super(buildContext, ENRICHER_NAME);
    }

    public void create(PlatformMode platformMode, KubernetesListBuilder builder) {
        List images = this.getImages();
        if (!KubernetesResourceUtil.checkForKind((KubernetesListBuilder)builder, (String[])ControllerViaPluginConfigurationEnricher.POD_CONTROLLER_KINDS) && !images.isEmpty()) {
            String name = this.getConfig(Config.NAME, JKubeProjectUtil.createDefaultResourceName((String)this.getContext().getGav().getSanitizedArtifactId(), (String[])new String[0]));
            ControllerResourceConfig controllerResourceConfig = this.getControllerResourceConfig().toBuilder().controllerName(this.getControllerName(name)).imagePullPolicy(this.getImagePullPolicy(Config.PULL_POLICY)).replicas(Integer.valueOf(this.getReplicaCount(builder, Configs.asInt((String)this.getConfig(Config.REPLICA_COUNT))))).restartPolicy(this.getControllerResourceConfig().getRestartPolicy()).schedule(this.getConfig(Config.SCHEDULE)).build();
            ControllerHandler ch = this.getContext().getHandlerHub().getHandlerFor(DefaultControllerEnricher.fromType(this.getConfig(Config.TYPE)));
            HasMetadata resource = ch.get(controllerResourceConfig, images);
            this.log.info("Adding a default %s", new Object[]{resource.getKind()});
            builder.addToItems(new HasMetadata[]{resource});
            this.setProcessingInstruction("FABRIC8_GENERATED_CONTAINERS", DefaultControllerEnricher.getContainersFromPodSpec(ch.getPodTemplateSpec(controllerResourceConfig, images)));
        }
    }

    private static List<String> getContainersFromPodSpec(PodTemplateSpec spec) {
        return spec.getSpec().getContainers().stream().map(Container::getName).collect(Collectors.toList());
    }

    private static Class<? extends HasMetadata> fromType(String type) {
        return CONTROLLER_TYPES.getOrDefault(Optional.ofNullable(type).orElse("").toUpperCase(Locale.ENGLISH), Deployment.class);
    }

    static {
        CONTROLLER_TYPES.put("STATEFULSET", StatefulSet.class);
        CONTROLLER_TYPES.put("DAEMONSET", DaemonSet.class);
        CONTROLLER_TYPES.put("REPLICASET", ReplicaSet.class);
        CONTROLLER_TYPES.put("REPLICATIONCONTROLLER", ReplicationController.class);
        CONTROLLER_TYPES.put("JOB", Job.class);
        CONTROLLER_TYPES.put("CRONJOB", CronJob.class);
    }

    public static enum Config implements Configs.Config
    {
        NAME("name", null),
        PULL_POLICY("pullPolicy", "IfNotPresent"),
        TYPE("type", null),
        REPLICA_COUNT("replicaCount", "1"),
        SCHEDULE("schedule", null);

        protected String key;
        protected String defaultValue;

        @Generated
        private Config(String key, String defaultValue) {
            this.key = key;
            this.defaultValue = defaultValue;
        }

        @Generated
        public String getKey() {
            return this.key;
        }

        @Generated
        public String getDefaultValue() {
            return this.defaultValue;
        }
    }
}

