/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.enricher.generic;

import io.fabric8.kubernetes.api.builder.TypedVisitor;
import io.fabric8.kubernetes.api.builder.Visitor;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KubernetesListBuilder;
import io.fabric8.kubernetes.api.model.NamespaceBuilder;
import io.fabric8.kubernetes.api.model.NamespaceFluent;
import io.fabric8.kubernetes.api.model.NamespaceStatus;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.openshift.api.model.ProjectBuilder;
import io.fabric8.openshift.api.model.ProjectFluent;
import io.fabric8.openshift.api.model.ProjectStatus;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jkube.kit.common.Configs;
import org.eclipse.jkube.kit.config.resource.PlatformMode;
import org.eclipse.jkube.kit.config.resource.ResourceConfig;
import org.eclipse.jkube.kit.enricher.api.BaseEnricher;
import org.eclipse.jkube.kit.enricher.api.EnricherContext;
import org.eclipse.jkube.kit.enricher.api.util.KubernetesResourceUtil;

public class DefaultNamespaceEnricher
extends BaseEnricher {
    private static final String NAMESPACE = "namespace";
    protected static final String[] NAMESPACE_KINDS = new String[]{"Project", "Namespace"};
    private final ResourceConfig config = Optional.ofNullable(this.getConfiguration().getResource()).orElse(ResourceConfig.builder().build());

    public DefaultNamespaceEnricher(EnricherContext buildContext) {
        super(buildContext, "jkube-namespace");
    }

    public void create(PlatformMode platformMode, KubernetesListBuilder builder) {
        String newNamespaceToCreate = this.getConfig(Config.NAMESPACE, null);
        if (StringUtils.isEmpty((CharSequence)newNamespaceToCreate)) {
            return;
        }
        this.addNewNamespaceToBuilderIfProvided(platformMode, newNamespaceToCreate, builder);
    }

    public void enrich(PlatformMode platformMode, KubernetesListBuilder builder) {
        builder.accept(new Visitor[]{new TypedVisitor<ObjectMetaBuilder>(){

            private String getNamespaceName() {
                return BaseEnricher.getNamespace((ResourceConfig)DefaultNamespaceEnricher.this.config, null);
            }

            private boolean shouldConfigureNamespaceInMetadata() {
                return StringUtils.isNotEmpty((CharSequence)this.getNamespaceName());
            }

            public void visit(ObjectMetaBuilder metaBuilder) {
                if (!this.shouldConfigureNamespaceInMetadata()) {
                    return;
                }
                boolean forceModifyNamespace = Boolean.parseBoolean(DefaultNamespaceEnricher.this.getConfig(Config.FORCE));
                if (StringUtils.isBlank((CharSequence)metaBuilder.getNamespace()) || forceModifyNamespace) {
                    ((ObjectMetaBuilder)metaBuilder.withNamespace(this.getNamespaceName())).build();
                }
            }
        }});
        builder.accept(new Visitor[]{new TypedVisitor<NamespaceBuilder>(){

            public void visit(NamespaceBuilder builder) {
                NamespaceStatus status = builder.buildStatus();
                if (status != null && status.getPhase().equals("active")) {
                    ((NamespaceBuilder)builder.editOrNewStatus().endStatus()).build();
                }
                ((NamespaceFluent.MetadataNested)builder.editOrNewMetadata().withNamespace(null)).endMetadata();
            }
        }});
        builder.accept(new Visitor[]{new TypedVisitor<ProjectBuilder>(){

            public void visit(ProjectBuilder builder) {
                ProjectStatus status = builder.buildStatus();
                if (status != null && status.getPhase().equals("active")) {
                    ((ProjectBuilder)builder.editOrNewStatus().endStatus()).build();
                }
                ((ProjectFluent.MetadataNested)builder.editOrNewMetadata().withNamespace(null)).endMetadata();
            }
        }});
    }

    private void addNewNamespaceToBuilderIfProvided(PlatformMode platformMode, String newNamespaceToCreate, KubernetesListBuilder builder) {
        if (!KubernetesResourceUtil.checkForKind((KubernetesListBuilder)builder, (String[])NAMESPACE_KINDS)) {
            String type = this.getConfig(Config.TYPE);
            if (StringUtils.isNotEmpty((CharSequence)newNamespaceToCreate)) {
                this.addNamespaceToBuilder(platformMode, newNamespaceToCreate, builder, type);
            }
        }
    }

    private void addNamespaceToBuilder(PlatformMode platformMode, String newNamespaceToCreate, KubernetesListBuilder builder, String type) {
        HasMetadata namespaceOrProject = this.getNamespaceOrProject(platformMode, type, newNamespaceToCreate);
        if (namespaceOrProject != null) {
            builder.addToItems(new HasMetadata[]{namespaceOrProject});
        }
    }

    private HasMetadata getNamespaceOrProject(PlatformMode platformMode, String type, String ns) {
        if ("project".equalsIgnoreCase(type) || NAMESPACE.equalsIgnoreCase(type)) {
            if (platformMode == PlatformMode.kubernetes) {
                this.log.info("Adding a default Namespace: %s", new Object[]{ns});
                return this.getContext().getHandlerHub().getNamespaceHandler().getNamespace(ns);
            }
            this.log.info("Adding a default Project %s", new Object[]{ns});
            return this.getContext().getHandlerHub().getProjectHandler().getProject(ns);
        }
        return null;
    }

    private static enum Config implements Configs.Config
    {
        NAMESPACE("namespace", null),
        FORCE("force", "false"),
        TYPE("type", "namespace");

        protected String key;
        protected String defaultValue;

        @Generated
        private Config(String key, String defaultValue) {
            this.key = key;
            this.defaultValue = defaultValue;
        }

        @Generated
        public String getKey() {
            return this.key;
        }

        @Generated
        public String getDefaultValue() {
            return this.defaultValue;
        }
    }
}

