/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.enricher.generic;

import io.fabric8.ianaservicehelper.Helper;
import io.fabric8.kubernetes.api.builder.TypedVisitor;
import io.fabric8.kubernetes.api.builder.Visitor;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.IntOrString;
import io.fabric8.kubernetes.api.model.KubernetesListBuilder;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.ServiceBuilder;
import io.fabric8.kubernetes.api.model.ServiceFluent;
import io.fabric8.kubernetes.api.model.ServicePort;
import io.fabric8.kubernetes.api.model.ServicePortBuilder;
import io.fabric8.kubernetes.api.model.ServiceSpec;
import java.io.IOException;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jkube.kit.common.Configs;
import org.eclipse.jkube.kit.common.util.JKubeProjectUtil;
import org.eclipse.jkube.kit.common.util.KubernetesHelper;
import org.eclipse.jkube.kit.common.util.SpringBootUtil;
import org.eclipse.jkube.kit.config.image.ImageConfiguration;
import org.eclipse.jkube.kit.config.image.build.BuildConfiguration;
import org.eclipse.jkube.kit.config.resource.PlatformMode;
import org.eclipse.jkube.kit.config.resource.ResourceConfig;
import org.eclipse.jkube.kit.config.resource.ServiceConfig;
import org.eclipse.jkube.kit.enricher.api.BaseEnricher;
import org.eclipse.jkube.kit.enricher.api.EnricherContext;
import org.eclipse.jkube.kit.enricher.api.JKubeEnricherContext;

public class DefaultServiceEnricher
extends BaseEnricher {
    private static final Pattern PORT_PROTOCOL_PATTERN = Pattern.compile("^(\\d+)(?:/(tcp|udp))?$", 2);
    private static final Pattern PORT_MAPPING_PATTERN = Pattern.compile("^\\s*(?<port>\\d+)(\\s*:\\s*(?<targetPort>\\d+))?(\\s*/\\s*(?<protocol>(tcp|udp)))?\\s*$", 2);
    private static final String PORT_IMAGE_LABEL_PREFIX = "jkube.generator.service.port";
    private static final String PORTS_IMAGE_LABEL_PREFIX = "jkube.generator.service.ports";
    private static final Map<Integer, Integer> PORT_NORMALIZATION_MAPPING = new HashMap<Integer, Integer>();

    public DefaultServiceEnricher(JKubeEnricherContext buildContext) {
        super((EnricherContext)buildContext, "jkube-service");
    }

    public void create(PlatformMode platformMode, KubernetesListBuilder builder) {
        ResourceConfig xmlConfig = this.getConfiguration().getResource();
        if (Optional.ofNullable(xmlConfig).map(ResourceConfig::getServices).map(c -> !c.isEmpty()).orElse(false).booleanValue()) {
            this.addServices(builder, xmlConfig.getServices());
        } else {
            Service defaultService = this.getDefaultService();
            if (this.shouldMergeDefaultServiceWithExistentService(builder, defaultService)) {
                this.mergeInDefaultServiceParameters(builder, defaultService);
            } else {
                this.addDefaultService(builder, defaultService);
            }
            if (Configs.asBoolean((String)this.getConfig(Config.NORMALIZE_PORT))) {
                this.normalizeServicePorts(builder);
            }
        }
    }

    private void normalizeServicePorts(KubernetesListBuilder builder) {
        builder.accept(new Visitor[]{new TypedVisitor<ServicePortBuilder>(){

            public void visit(ServicePortBuilder portBuilder) {
                PORT_NORMALIZATION_MAPPING.keySet().forEach(key -> {
                    if (key.intValue() == portBuilder.buildTargetPort().getIntVal().intValue()) {
                        portBuilder.withPort((Integer)PORT_NORMALIZATION_MAPPING.get(key));
                    }
                });
            }
        }});
    }

    private void addServices(KubernetesListBuilder builder, List<ServiceConfig> services) {
        builder.addToItems((HasMetadata[])this.toArray(this.getContext().getHandlerHub().getServiceHandler().getServices(services)));
    }

    private Service[] toArray(List<Service> services) {
        if (services == null) {
            return new Service[0];
        }
        if (services instanceof ArrayList) {
            return services.toArray(new Service[0]);
        }
        Service[] ret = new Service[services.size()];
        for (int i = 0; i < services.size(); ++i) {
            ret[i] = services.get(i);
        }
        return ret;
    }

    private String getAppName() {
        try {
            if (this.getContext().getProjectClassLoaders().isClassInCompileClasspath(true, new String[0])) {
                Properties properties = SpringBootUtil.getSpringBootApplicationProperties((URLClassLoader)this.getContext().getProjectClassLoaders().getCompileClassLoader());
                return properties.getProperty("spring.application.name");
            }
        }
        catch (Exception ex) {
            this.log.error("Error while reading the spring-boot configuration", new Object[]{ex});
        }
        return null;
    }

    private String getServiceName() {
        String appName = this.getAppName();
        if (appName != null) {
            return appName;
        }
        return this.getConfig(Config.NAME, JKubeProjectUtil.createDefaultResourceName((String)this.getContext().getGav().getSanitizedArtifactId(), (String[])new String[0]));
    }

    private Service getDefaultService() {
        if (!this.hasImageConfiguration()) {
            return null;
        }
        String serviceName = this.getServiceName();
        List<ServicePort> ports = this.extractPorts(this.getImages());
        ServiceBuilder builder = (ServiceBuilder)((ServiceFluent.MetadataNested)((ServiceFluent.MetadataNested)new ServiceBuilder().withNewMetadata().withName(serviceName)).withLabels(this.extractLabels())).endMetadata();
        ServiceFluent.SpecNested specBuilder = builder.withNewSpec();
        if (!ports.isEmpty()) {
            specBuilder.withPorts(ports);
        } else if (Configs.asBoolean((String)this.getConfig(Config.HEADLESS))) {
            specBuilder.withClusterIP("None");
        } else {
            return null;
        }
        specBuilder.withType(this.getConfig(Config.TYPE));
        specBuilder.endSpec();
        return builder.build();
    }

    private boolean shouldMergeDefaultServiceWithExistentService(KubernetesListBuilder builder, final Service defaultService) {
        if (defaultService == null) {
            return false;
        }
        final AtomicBoolean hasService = new AtomicBoolean(false);
        builder.accept(new Visitor[]{new TypedVisitor<ServiceBuilder>(){

            public void visit(ServiceBuilder element) {
                if (element.buildMetadata().getName() == null || Objects.equals(defaultService.getMetadata().getName(), element.buildMetadata().getName())) {
                    hasService.set(true);
                }
            }
        }});
        return hasService.get();
    }

    private void mergeInDefaultServiceParameters(KubernetesListBuilder builder, final Service defaultService) {
        builder.accept(new Visitor[]{new TypedVisitor<ServiceBuilder>(){

            public void visit(ServiceBuilder service) {
                String defaultServiceName = DefaultServiceEnricher.this.getDefaultServiceName(defaultService);
                String serviceName = DefaultServiceEnricher.this.ensureServiceName(service, defaultServiceName);
                if (defaultService != null && defaultServiceName != null && defaultServiceName.equals(serviceName)) {
                    DefaultServiceEnricher.this.addMissingServiceParts(service, defaultService);
                }
            }
        }});
    }

    private void addDefaultService(KubernetesListBuilder builder, Service defaultService) {
        if (defaultService == null) {
            return;
        }
        ServiceSpec spec = defaultService.getSpec();
        List ports = spec.getPorts();
        if (!ports.isEmpty()) {
            this.log.info("Adding a default service '%s' with ports [%s]", new Object[]{defaultService.getMetadata().getName(), this.formatPortsAsList(ports)});
        } else {
            this.log.info("Adding headless default service '%s'", new Object[]{defaultService.getMetadata().getName()});
        }
        builder.addToItems(new HasMetadata[]{defaultService});
    }

    private Map<String, String> extractLabels() {
        HashMap<String, String> labels = new HashMap<String, String>();
        if (Configs.asBoolean((String)this.getConfig(Config.EXPOSE))) {
            labels.put("expose", "true");
        }
        return labels;
    }

    private List<ServicePort> extractPorts(List<ImageConfiguration> images) {
        ArrayList<ServicePort> ret = new ArrayList<ServicePort>();
        boolean isMultiPort = Boolean.parseBoolean(this.getConfig(Config.MULTI_PORT));
        List<ServicePort> configuredPorts = this.extractPortsFromConfig();
        for (ImageConfiguration image : images) {
            Map<String, String> labels = this.extractLabelsFromConfig(image);
            List<String> podPorts = this.getPortsFromBuildConfiguration(image);
            List<String> portsFromImageLabels = this.getLabelWithService(labels);
            if (podPorts.isEmpty()) continue;
            if (portsFromImageLabels.isEmpty()) {
                this.addPortIfNotNull(ret, this.extractPortsFromImageSpec(image.getName(), podPorts.remove(0), this.shiftOrNull(configuredPorts), null));
            } else {
                for (String imageLabelPort : portsFromImageLabels) {
                    this.addPortIfNotNull(ret, this.extractPortsFromImageSpec(image.getName(), podPorts.remove(0), this.shiftOrNull(configuredPorts), imageLabelPort));
                }
            }
            if (!isMultiPort) continue;
            for (String port : podPorts) {
                this.addPortIfNotNull(ret, this.extractPortsFromImageSpec(image.getName(), port, this.shiftOrNull(configuredPorts), null));
            }
        }
        if (isMultiPort) {
            ret.addAll(this.mirrorMissingTargetPorts(configuredPorts));
        } else if (ret.isEmpty() && !configuredPorts.isEmpty()) {
            ret.addAll(this.mirrorMissingTargetPorts(Collections.singletonList(configuredPorts.get(0))));
        }
        return ret;
    }

    private List<ServicePort> mirrorMissingTargetPorts(List<ServicePort> ports) {
        ArrayList<ServicePort> ret = new ArrayList<ServicePort>();
        for (ServicePort port : ports) {
            ret.add(this.updateMissingTargetPort(port, port.getPort()));
        }
        return ret;
    }

    private List<String> getPortsFromBuildConfiguration(ImageConfiguration image) {
        BuildConfiguration buildConfig = image.getBuildConfiguration();
        if (buildConfig == null) {
            return Collections.emptyList();
        }
        return buildConfig.getPorts();
    }

    private List<ServicePort> extractPortsFromConfig() {
        LinkedList<ServicePort> ret = new LinkedList<ServicePort>();
        String ports = this.getConfig(Config.PORT);
        if (ports != null) {
            for (String port : ports.split(",")) {
                ret.add(this.parsePortMapping(port));
            }
        }
        return ret;
    }

    private Map<String, String> extractLabelsFromConfig(ImageConfiguration imageConfiguration) {
        HashMap<String, String> labels = new HashMap<String, String>();
        if (imageConfiguration.getBuildConfiguration() != null && imageConfiguration.getBuildConfiguration().getLabels() != null) {
            labels.putAll(imageConfiguration.getBuildConfiguration().getLabels());
        }
        return labels;
    }

    private List<String> getLabelWithService(Map<String, String> labels) {
        ArrayList<String> portsList = new ArrayList<String>();
        for (Map.Entry<String, String> entry : labels.entrySet()) {
            if (entry.getKey().equals(PORT_IMAGE_LABEL_PREFIX)) {
                portsList.add(entry.getValue());
            }
            if (!entry.getKey().equals(PORTS_IMAGE_LABEL_PREFIX)) continue;
            portsList.addAll(Arrays.asList(entry.getValue().split(",")));
        }
        return portsList;
    }

    private ServicePort parsePortMapping(String port) {
        Matcher matcher = PORT_MAPPING_PATTERN.matcher(port);
        if (!matcher.matches()) {
            this.log.error("Invalid 'port' configuration '%s'. Must match <port>(:<targetPort>)?,<port2>?,...", new Object[]{port});
            throw new IllegalArgumentException("Invalid port mapping specification " + port);
        }
        int servicePort = Integer.parseInt(matcher.group("port"));
        String optionalTargetPort = matcher.group("targetPort");
        String protocol = this.getProtocol(matcher.group("protocol"));
        ServicePortBuilder builder = (ServicePortBuilder)((ServicePortBuilder)((ServicePortBuilder)new ServicePortBuilder().withPort(Integer.valueOf(servicePort))).withProtocol(protocol)).withName(this.getDefaultPortName(servicePort, protocol));
        if (optionalTargetPort != null) {
            builder.withNewTargetPort((Object)Integer.parseInt(optionalTargetPort));
        }
        return builder.build();
    }

    private void addPortIfNotNull(List<ServicePort> ret, ServicePort port) {
        if (port != null) {
            ret.add(port);
        }
    }

    private ServicePort extractPortsFromImageSpec(String imageName, String portSpec, ServicePort portOverride, String targetPortFromImageLabel) {
        Matcher portMatcher = PORT_PROTOCOL_PATTERN.matcher(portSpec);
        if (!portMatcher.matches()) {
            this.log.warn("Invalid port specification '%s' for image %s. Must match \\d+(/(tcp|udp))?. Ignoring for now for service generation", new Object[]{portSpec, imageName});
            return null;
        }
        Integer targetPort = Integer.parseInt(targetPortFromImageLabel != null ? targetPortFromImageLabel : portMatcher.group(1));
        String protocol = this.getProtocol(portMatcher.group(2));
        Integer port = this.checkForLegacyMapping(targetPort);
        if (portOverride != null) {
            return this.updateMissingTargetPort(portOverride, targetPort);
        }
        return ((ServicePortBuilder)((ServicePortBuilder)((ServicePortBuilder)((ServicePortBuilder)new ServicePortBuilder().withPort(port)).withNewTargetPort((Object)targetPort)).withProtocol(protocol)).withName(this.getDefaultPortName(port, protocol))).build();
    }

    private ServicePort updateMissingTargetPort(ServicePort port, Integer targetPort) {
        if (port.getTargetPort() == null) {
            return ((ServicePortBuilder)new ServicePortBuilder(port).withNewTargetPort((Object)targetPort)).build();
        }
        return port;
    }

    private int checkForLegacyMapping(int port) {
        return port;
    }

    private String getProtocol(String imageProtocol) {
        String protocol;
        String string = protocol = imageProtocol != null ? imageProtocol : this.getConfig(Config.PROTOCOL);
        if ("tcp".equalsIgnoreCase(protocol) || "udp".equalsIgnoreCase(protocol)) {
            return protocol.toUpperCase();
        }
        throw new IllegalArgumentException(String.format("Invalid service protocol %s specified for enricher '%s'. Must be 'tcp' or 'udp'", protocol, this.getName()));
    }

    private String formatPortsAsList(List<ServicePort> ports) {
        ArrayList<String> p = new ArrayList<String>();
        for (ServicePort port : ports) {
            String targetPort = this.getPortValue(port.getTargetPort());
            String servicePort = port.getPort() != null ? Integer.toString(port.getPort()) : targetPort;
            p.add(targetPort.equals(servicePort) ? targetPort : servicePort + ":" + targetPort);
        }
        return String.join((CharSequence)",", p);
    }

    private String getPortValue(IntOrString port) {
        String val = port.getStrVal();
        if (val == null) {
            val = Integer.toString(port.getIntVal());
        }
        return val;
    }

    private String getDefaultPortName(int port, String serviceProtocol) {
        if ("TCP".equals(serviceProtocol)) {
            switch (port) {
                case 80: 
                case 8080: 
                case 9090: {
                    return "http";
                }
                case 443: 
                case 8443: {
                    return "https";
                }
                case 8778: {
                    return "jolokia";
                }
                case 9779: {
                    return "prometheus";
                }
            }
        }
        try {
            Set serviceNames = Helper.serviceNames((int)port, (String)serviceProtocol.toLowerCase());
            if (serviceNames != null && !serviceNames.isEmpty()) {
                return (String)serviceNames.iterator().next();
            }
            return null;
        }
        catch (IOException e) {
            this.log.warn("Cannot lookup port %d/%s in IANA database: %s", new Object[]{port, serviceProtocol.toLowerCase(), e.getMessage()});
            return null;
        }
    }

    private ServicePort shiftOrNull(List<ServicePort> ports) {
        if (!ports.isEmpty()) {
            return ports.remove(0);
        }
        return null;
    }

    private String getDefaultServiceName(Service defaultService) {
        String defaultServiceName = KubernetesHelper.getName((HasMetadata)defaultService);
        if (StringUtils.isBlank((CharSequence)defaultServiceName)) {
            defaultServiceName = this.getContext().getGav().getSanitizedArtifactId();
        }
        return defaultServiceName;
    }

    private void addMissingServiceParts(ServiceBuilder service, Service defaultService) {
        ServiceSpec originalSpec = service.buildSpec();
        if (originalSpec == null) {
            service.withNewSpecLike(defaultService.getSpec()).endSpec();
            return;
        }
        List ports = service.buildSpec().getPorts();
        if (ports == null || ports.isEmpty()) {
            ((ServiceFluent.SpecNested)service.editSpec().withPorts(defaultService.getSpec().getPorts())).endSpec();
        } else {
            ((ServiceFluent.SpecNested)service.editSpec().withPorts(this.addMissingDefaultPorts(ports, defaultService))).endSpec();
        }
        if (originalSpec.getType() == null) {
            ((ServiceFluent.SpecNested)service.editSpec().withType(defaultService.getSpec().getType())).endSpec();
        }
        if (originalSpec.getClusterIP() == null) {
            ((ServiceFluent.SpecNested)service.editSpec().withClusterIP(defaultService.getSpec().getClusterIP())).endSpec();
        }
    }

    private String ensureServiceName(ServiceBuilder service, String defaultServiceName) {
        if (StringUtils.isBlank((CharSequence)KubernetesHelper.getName((ObjectMeta)service.buildMetadata()))) {
            ((ServiceFluent.MetadataNested)service.editOrNewMetadata().withName(defaultServiceName)).endMetadata();
        }
        return KubernetesHelper.getName((ObjectMeta)service.buildMetadata());
    }

    private List<ServicePort> addMissingDefaultPorts(List<ServicePort> ports, Service defaultService) {
        this.ensurePortProtocolAndName(ports);
        return this.tryToFindAtLeastOnePort(ports, defaultService);
    }

    private void ensurePortProtocolAndName(List<ServicePort> ports) {
        for (ServicePort port : ports) {
            String protocol = this.ensureProtocol(port);
            this.ensurePortName(port, protocol);
        }
    }

    private List<ServicePort> tryToFindAtLeastOnePort(List<ServicePort> ports, Service defaultService) {
        List defaultPorts = defaultService.getSpec().getPorts();
        if (!ports.isEmpty() || defaultPorts == null || defaultPorts.isEmpty()) {
            return ports;
        }
        return Collections.singletonList(defaultPorts.get(0));
    }

    private void ensurePortName(ServicePort port, String protocol) {
        if (StringUtils.isBlank((CharSequence)port.getName())) {
            port.setName(this.getDefaultPortName(port.getPort(), this.getProtocol(protocol)));
        }
    }

    private String ensureProtocol(ServicePort port) {
        String protocol = port.getProtocol();
        if (StringUtils.isBlank((CharSequence)protocol)) {
            port.setProtocol("TCP");
            return "TCP";
        }
        return protocol;
    }

    public static ServicePort getServicePortToExpose(ServiceBuilder serviceBuilder) {
        List ports;
        ServiceSpec spec = serviceBuilder.buildSpec();
        if (spec != null && (ports = spec.getPorts()) != null && !ports.isEmpty()) {
            for (ServicePort port : ports) {
                if (!Objects.equals(port.getName(), "http") && !Objects.equals(port.getProtocol(), "http")) continue;
                return port;
            }
            ServicePort servicePort = (ServicePort)ports.iterator().next();
            if (servicePort.getPort() != null) {
                return servicePort;
            }
        }
        return null;
    }

    public static Integer getPortToExpose(ServiceBuilder serviceBuilder) {
        ServicePort servicePort = DefaultServiceEnricher.getServicePortToExpose(serviceBuilder);
        if (servicePort == null) {
            return null;
        }
        return servicePort.getPort();
    }

    static {
        PORT_NORMALIZATION_MAPPING.put(8080, 80);
        PORT_NORMALIZATION_MAPPING.put(8081, 80);
        PORT_NORMALIZATION_MAPPING.put(8181, 80);
        PORT_NORMALIZATION_MAPPING.put(8180, 80);
        PORT_NORMALIZATION_MAPPING.put(8443, 443);
        PORT_NORMALIZATION_MAPPING.put(443, 443);
    }

    private static enum Config implements Configs.Config
    {
        NAME("name", null),
        HEADLESS("headless", Boolean.FALSE.toString()),
        EXPOSE("expose", Boolean.FALSE.toString()),
        TYPE("type", null),
        PORT("port", null),
        MULTI_PORT("multiPort", Boolean.FALSE.toString()),
        PROTOCOL("protocol", "tcp"),
        NORMALIZE_PORT("normalizePort", Boolean.FALSE.toString());

        protected String key;
        protected String defaultValue;

        @Generated
        private Config(String key, String defaultValue) {
            this.key = key;
            this.defaultValue = defaultValue;
        }

        @Generated
        public String getKey() {
            return this.key;
        }

        @Generated
        public String getDefaultValue() {
            return this.defaultValue;
        }
    }
}

