/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.enricher.generic;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KubernetesList;
import io.fabric8.kubernetes.api.model.KubernetesListBuilder;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import io.fabric8.openshift.api.model.Template;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import lombok.Generated;
import org.eclipse.jkube.kit.common.Configs;
import org.eclipse.jkube.kit.common.Dependency;
import org.eclipse.jkube.kit.common.KitLogger;
import org.eclipse.jkube.kit.common.util.KubernetesHelper;
import org.eclipse.jkube.kit.common.util.Serialization;
import org.eclipse.jkube.kit.config.resource.PlatformMode;
import org.eclipse.jkube.kit.enricher.api.BaseEnricher;
import org.eclipse.jkube.kit.enricher.api.EnricherContext;
import org.eclipse.jkube.kit.enricher.api.JKubeEnricherContext;
import org.eclipse.jkube.kit.enricher.api.model.KindAndName;
import org.eclipse.jkube.kit.enricher.api.util.KubernetesResourceUtil;

public class DependencyEnricher
extends BaseEnricher {
    private static final String DEPENDENCY_KUBERNETES_YAML = "META-INF/jkube/kubernetes.yml";
    private static final String DEPENDENCY_KUBERNETES_TEMPLATE_YAML = "META-INF/jkube/k8s-template.yml";
    private static final String DEPENDENCY_OPENSHIFT_YAML = "META-INF/jkube/openshift.yml";
    private final Set<URI> kubernetesDependencyArtifacts = new HashSet<URI>();
    private final Set<URI> kubernetesTemplateDependencyArtifacts = new HashSet<URI>();
    private final Set<URI> openshiftDependencyArtifacts = new HashSet<URI>();

    public DependencyEnricher(JKubeEnricherContext buildContext) throws URISyntaxException {
        super((EnricherContext)buildContext, "jkube-dependency");
        this.addArtifactsWithYaml(this.kubernetesDependencyArtifacts, DEPENDENCY_KUBERNETES_YAML);
        this.addArtifactsWithYaml(this.kubernetesTemplateDependencyArtifacts, DEPENDENCY_KUBERNETES_TEMPLATE_YAML);
        this.addArtifactsWithYaml(this.openshiftDependencyArtifacts, DEPENDENCY_OPENSHIFT_YAML);
    }

    private void addArtifactsWithYaml(Set<URI> artifactSet, String dependencyYaml) throws URISyntaxException {
        List artifacts = this.getContext().getDependencies(this.isIncludeTransitive());
        for (Dependency artifact : artifacts) {
            if (!"compile".equals(artifact.getScope()) || !"jar".equals(artifact.getType())) continue;
            File file = artifact.getFile();
            try {
                URI uri = new URI("jar:" + file.toURI() + "!/" + dependencyYaml);
                artifactSet.add(uri);
            }
            catch (URISyntaxException e) {
                this.getLog().debug("Failed to create URL for %s: %s", new Object[]{file, e});
            }
        }
        if (this.isIncludePlugin()) {
            Enumeration<URL> resources = null;
            try {
                resources = ((Object)((Object)this)).getClass().getClassLoader().getResources(dependencyYaml);
            }
            catch (IOException e) {
                this.getLog().error("Could not find %s on the classpath: %s", new Object[]{dependencyYaml, e});
            }
            if (resources != null) {
                while (resources.hasMoreElements()) {
                    URL url = resources.nextElement();
                    URI uri = url.toURI();
                    artifactSet.add(uri);
                }
            }
        }
    }

    public void enrich(PlatformMode platformMode, KubernetesListBuilder builder) {
        switch (platformMode) {
            case kubernetes: {
                this.enrichKubernetes(builder);
                break;
            }
            case openshift: {
                this.enrichOpenShift(builder);
                break;
            }
        }
    }

    private void enrichKubernetes(KubernetesListBuilder builder) {
        ArrayList<HasMetadata> kubernetesItems = new ArrayList<HasMetadata>();
        this.processArtifactSetResources(this.kubernetesDependencyArtifacts, items -> {
            kubernetesItems.addAll(Arrays.asList(items.toArray(new HasMetadata[0])));
            return null;
        });
        this.processArtifactSetResources(this.kubernetesTemplateDependencyArtifacts, items -> {
            HasMetadata[] templates;
            for (HasMetadata resource : templates = items.toArray(new HasMetadata[0])) {
                Template template;
                List objects;
                if (!(resource instanceof Template) || (objects = (template = (Template)resource).getObjects()) == null) continue;
                this.removeTemplateObjects(kubernetesItems, objects);
                kubernetesItems.addAll(objects);
            }
            return null;
        });
        this.filterAndAddItemsToBuilder(builder, kubernetesItems);
    }

    private void enrichOpenShift(KubernetesListBuilder builder) {
        ArrayList<HasMetadata> openshiftItems = new ArrayList<HasMetadata>();
        this.processArtifactSetResources(this.openshiftDependencyArtifacts, items -> {
            openshiftItems.addAll(Arrays.asList(items.toArray(new HasMetadata[0])));
            return null;
        });
        this.filterAndAddItemsToBuilder(builder, openshiftItems);
    }

    private void removeTemplateObjects(List<HasMetadata> list, List<HasMetadata> objects) {
        for (HasMetadata object : objects) {
            ArrayList<HasMetadata> copy = new ArrayList<HasMetadata>(list);
            for (HasMetadata resource : copy) {
                if (!Objects.equals(resource.getKind(), object.getKind()) || !Objects.equals(KubernetesHelper.getName((HasMetadata)object), KubernetesHelper.getName((HasMetadata)resource))) continue;
                list.remove(resource);
            }
        }
    }

    public void filterAndAddItemsToBuilder(KubernetesListBuilder builder, List<HasMetadata> items) {
        KindAndName aKey;
        HashMap<KindAndName, Integer> aIndexMap = new HashMap<KindAndName, Integer>();
        int nItems = 0;
        int index = 0;
        while (index < builder.buildItems().size()) {
            HasMetadata aItem = (HasMetadata)builder.buildItems().get(index);
            aKey = new KindAndName(aItem);
            aIndexMap.put(aKey, index);
            ++index;
            ++nItems;
        }
        for (HasMetadata item : items) {
            aKey = new KindAndName(item);
            if (aIndexMap.containsKey(aKey)) {
                HasMetadata duplicateItem = (HasMetadata)builder.buildItems().get((Integer)aIndexMap.get(aKey));
                item = KubernetesResourceUtil.mergeResources((HasMetadata)item, (HasMetadata)duplicateItem, (KitLogger)this.log, (boolean)false);
                builder.setToItems(((Integer)aIndexMap.get(aKey)).intValue(), item);
                continue;
            }
            aIndexMap.put(aKey, nItems++);
            builder.addToItems(new HasMetadata[]{item});
        }
    }

    private void processArtifactSetResources(Set<URI> artifactSet, Function<List<HasMetadata>, Void> function) {
        for (URI uri : artifactSet) {
            try {
                Template template;
                this.log.debug("Processing Kubernetes YAML in at: %s", new Object[]{uri});
                KubernetesList resources = (KubernetesList)Serialization.unmarshal((URL)uri.toURL(), KubernetesList.class);
                List items = resources.getItems();
                if (items.isEmpty() && Objects.equals("Template", resources.getKind()) && (template = (Template)Serialization.unmarshal((URL)uri.toURL(), Template.class)) != null) {
                    items.add(template);
                }
                for (HasMetadata item : items) {
                    this.log.debug("  found %s  %s", new Object[]{KubernetesHelper.getKind((KubernetesResource)item), KubernetesHelper.getName((HasMetadata)item)});
                }
                function.apply(items);
            }
            catch (IOException e) {
                this.getLog().debug("Skipping %s: %s", new Object[]{uri, e});
            }
        }
    }

    protected boolean isIncludePlugin() {
        return Configs.asBoolean((String)this.getConfig(Config.INCLUDE_PLUGIN));
    }

    protected boolean isIncludeTransitive() {
        return Configs.asBoolean((String)this.getConfig(Config.INCLUDE_TRANSITIVE));
    }

    private static enum Config implements Configs.Config
    {
        INCLUDE_TRANSITIVE("includeTransitive", "true"),
        INCLUDE_PLUGIN("includePlugin", "true");

        protected String key;
        protected String defaultValue;

        @Generated
        private Config(String key, String defaultValue) {
            this.key = key;
            this.defaultValue = defaultValue;
        }

        @Generated
        public String getKey() {
            return this.key;
        }

        @Generated
        public String getDefaultValue() {
            return this.defaultValue;
        }
    }
}

