/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.enricher.generic;

import io.fabric8.kubernetes.api.builder.TypedVisitor;
import io.fabric8.kubernetes.api.builder.Visitor;
import io.fabric8.kubernetes.api.model.KubernetesListBuilder;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jkube.kit.common.Configs;
import org.eclipse.jkube.kit.common.util.JKubeProjectUtil;
import org.eclipse.jkube.kit.config.resource.PlatformMode;
import org.eclipse.jkube.kit.enricher.api.BaseEnricher;
import org.eclipse.jkube.kit.enricher.api.EnricherContext;
import org.eclipse.jkube.kit.enricher.api.JKubeEnricherContext;

public class NameEnricher
extends BaseEnricher {
    public NameEnricher(JKubeEnricherContext buildContext) {
        super((EnricherContext)buildContext, "jkube-name");
    }

    public void create(PlatformMode platformMode, KubernetesListBuilder builder) {
        final String configuredName = this.getConfig(Config.NAME);
        final String defaultName = JKubeProjectUtil.createDefaultResourceName((String)this.getContext().getGav().getSanitizedArtifactId(), (String[])new String[0]);
        builder.accept(new Visitor[]{new TypedVisitor<ObjectMetaBuilder>(){

            public void visit(ObjectMetaBuilder resource) {
                if (StringUtils.isNotBlank((CharSequence)configuredName)) {
                    resource.withName(configuredName);
                } else if (StringUtils.isBlank((CharSequence)resource.getName())) {
                    resource.withName(defaultName);
                }
            }
        }});
    }

    private static enum Config implements Configs.Config
    {
        NAME("name");

        protected String key;

        @Generated
        private Config(String key) {
            this.key = key;
        }

        @Generated
        public String getKey() {
            return this.key;
        }
    }
}

