/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.enricher.generic;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.eclipse.jkube.enricher.generic.AbstractLabelEnricher;
import org.eclipse.jkube.kit.common.Configs;
import org.eclipse.jkube.kit.config.resource.GroupArtifactVersion;
import org.eclipse.jkube.kit.enricher.api.EnricherContext;
import org.eclipse.jkube.kit.enricher.api.JKubeEnricherContext;

public class ProjectLabelEnricher
extends AbstractLabelEnricher {
    public static final String LABEL_PROVIDER = "provider";

    public ProjectLabelEnricher(JKubeEnricherContext buildContext) {
        super((EnricherContext)buildContext, "jkube-project-label");
    }

    @Override
    public Map<String, String> createLabels(boolean includeVersion, Map<String, String> labelsViaResourceConfig) {
        HashMap<String, String> ret = new HashMap<String, String>();
        boolean enableProjectLabel = Configs.asBoolean((String)this.getConfig(Config.USE_PROJECT_LABEL));
        GroupArtifactVersion groupArtifactVersion = this.getContext().getGav();
        if (enableProjectLabel) {
            ret.putAll(this.addProjectLabelFromApplicableSource(null, "project", groupArtifactVersion.getArtifactId(), labelsViaResourceConfig));
        } else {
            ret.putAll(this.addProjectLabelFromApplicableSource(Config.APP, "app", groupArtifactVersion.getArtifactId(), labelsViaResourceConfig));
        }
        ret.putAll(this.addProjectLabelFromApplicableSource(Config.GROUP, "group", groupArtifactVersion.getGroupId(), labelsViaResourceConfig));
        ret.putAll(this.addProjectLabelFromApplicableSource(Config.PROVIDER, LABEL_PROVIDER, null, labelsViaResourceConfig));
        if (includeVersion) {
            ret.putAll(this.addProjectLabelFromApplicableSource(Config.VERSION, "version", groupArtifactVersion.getVersion(), labelsViaResourceConfig));
        }
        return ret;
    }

    private Map<String, String> addProjectLabelFromApplicableSource(Configs.Config key, String labelKey, String defaultValue, Map<String, String> labelsViaResourceConfig) {
        HashMap<String, String> entryMap = new HashMap<String, String>();
        String appLabelValueFromConfig = Optional.ofNullable(key).map(k -> this.getConfig((Configs.Config)k, defaultValue)).orElse(defaultValue);
        entryMap.put(labelKey, labelsViaResourceConfig.getOrDefault(labelKey, appLabelValueFromConfig));
        return entryMap;
    }

    private static enum Config implements Configs.Config
    {
        USE_PROJECT_LABEL("useProjectLabel", "false"),
        APP("app", null),
        GROUP("group", null),
        VERSION("version", null),
        PROVIDER("provider", "jkube");

        protected String key;
        protected String defaultValue;

        @Generated
        private Config(String key, String defaultValue) {
            this.key = key;
            this.defaultValue = defaultValue;
        }

        @Generated
        public String getKey() {
            return this.key;
        }

        @Generated
        public String getDefaultValue() {
            return this.defaultValue;
        }
    }
}

