/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.enricher.generic;

import io.fabric8.kubernetes.api.builder.TypedVisitor;
import io.fabric8.kubernetes.api.builder.Visitor;
import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.ContainerBuilder;
import io.fabric8.kubernetes.api.model.ContainerFluent;
import io.fabric8.kubernetes.api.model.KubernetesListBuilder;
import io.fabric8.kubernetes.api.model.PodSpecBuilder;
import io.fabric8.kubernetes.api.model.SecurityContextFluent;
import org.eclipse.jkube.kit.config.resource.PlatformMode;
import org.eclipse.jkube.kit.enricher.api.BaseEnricher;
import org.eclipse.jkube.kit.enricher.api.EnricherContext;

public class SecurityHardeningEnricher
extends BaseEnricher {
    public SecurityHardeningEnricher(EnricherContext enricherContext) {
        super(enricherContext, "jkube-security-hardening");
    }

    public void enrich(PlatformMode platformMode, KubernetesListBuilder builder) {
        builder.accept(new Visitor[]{new PodSpecBuilderSecurityHardeningVisitor(), new ContainerSecurityHardeningVisitor(), new ContainerSecurityWarningVisitor(this.getContext())});
    }

    private static final class ContainerSecurityWarningVisitor
    extends TypedVisitor<ContainerBuilder> {
        private final EnricherContext enricherContext;

        public ContainerSecurityWarningVisitor(EnricherContext enricherContext) {
            this.enricherContext = enricherContext;
        }

        public void visit(ContainerBuilder containerBuilder) {
            Container container = containerBuilder.build();
            if (!this.enricherContext.getProject().isSnapshot() && container.getImage() != null && container.getImage().endsWith(":latest")) {
                this.enricherContext.getLog().warn("Container %s has an image with tag 'latest', it's recommended to use a fixed tag or a digest instead", new Object[]{container.getName()});
            }
        }
    }

    private static final class ContainerSecurityHardeningVisitor
    extends TypedVisitor<ContainerBuilder> {
        private ContainerSecurityHardeningVisitor() {
        }

        public void visit(ContainerBuilder container) {
            ((ContainerFluent.SecurityContextNested)((SecurityContextFluent.CapabilitiesNested)((SecurityContextFluent.CapabilitiesNested)((ContainerFluent.SecurityContextNested)((SecurityContextFluent.SeccompProfileNested)((ContainerFluent.SecurityContextNested)((ContainerFluent.SecurityContextNested)((ContainerFluent.SecurityContextNested)((ContainerFluent.SecurityContextNested)container.editOrNewSecurityContext().withPrivileged(Boolean.valueOf(false))).withAllowPrivilegeEscalation(Boolean.valueOf(false))).withRunAsUser(Long.valueOf(10000L))).withRunAsNonRoot(Boolean.valueOf(true))).editOrNewSeccompProfile().withType("RuntimeDefault")).endSeccompProfile()).editOrNewCapabilities().addToDrop(new String[]{"NET_RAW"})).addToDrop(new String[]{"ALL"})).endCapabilities()).endSecurityContext();
        }
    }

    private static final class PodSpecBuilderSecurityHardeningVisitor
    extends TypedVisitor<PodSpecBuilder> {
        private PodSpecBuilderSecurityHardeningVisitor() {
        }

        public void visit(PodSpecBuilder podSpec) {
            podSpec.withAutomountServiceAccountToken(Boolean.valueOf(false));
        }
    }
}

