/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.enricher.generic.openshift;

import io.fabric8.kubernetes.api.builder.TypedVisitor;
import io.fabric8.kubernetes.api.builder.Visitor;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.IntOrString;
import io.fabric8.kubernetes.api.model.KubernetesListBuilder;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ServiceBuilder;
import io.fabric8.kubernetes.api.model.ServicePort;
import io.fabric8.openshift.api.model.Route;
import io.fabric8.openshift.api.model.RouteBuilder;
import io.fabric8.openshift.api.model.RouteFluent;
import io.fabric8.openshift.api.model.RoutePort;
import io.fabric8.openshift.api.model.RouteSpec;
import io.fabric8.openshift.api.model.RouteSpecFluent;
import java.util.Objects;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jkube.enricher.generic.DefaultServiceEnricher;
import org.eclipse.jkube.kit.common.Configs;
import org.eclipse.jkube.kit.common.util.FileUtil;
import org.eclipse.jkube.kit.config.resource.PlatformMode;
import org.eclipse.jkube.kit.config.resource.ResourceConfig;
import org.eclipse.jkube.kit.enricher.api.BaseEnricher;
import org.eclipse.jkube.kit.enricher.api.EnricherContext;
import org.eclipse.jkube.kit.enricher.api.JKubeEnricherContext;
import org.eclipse.jkube.kit.enricher.api.ServiceExposer;
import org.eclipse.jkube.kit.enricher.api.util.KubernetesResourceUtil;

public class RouteEnricher
extends BaseEnricher
implements ServiceExposer {
    private static final String GENERATE_ROUTE_PROPERTY = "jkube.openshift.generateRoute";
    private String routeDomainPostfix;

    public RouteEnricher(JKubeEnricherContext buildContext) {
        super((EnricherContext)buildContext, "jkube-openshift-route");
    }

    private boolean isGenerateRoute() {
        return Configs.asBoolean((String)this.getConfigWithFallback(Config.GENERATE_ROUTE, GENERATE_ROUTE_PROPERTY, null));
    }

    private boolean isRouteWithTLS() {
        return StringUtils.isNotBlank((CharSequence)this.getConfig(Config.TLS_TERMINATION, null));
    }

    public void create(PlatformMode platformMode, final KubernetesListBuilder listBuilder) {
        ResourceConfig resourceConfig = this.getConfiguration().getResource();
        if (resourceConfig != null && resourceConfig.getRouteDomain() != null) {
            this.routeDomainPostfix = resourceConfig.getRouteDomain();
        }
        if (platformMode == PlatformMode.openshift && this.isGenerateRoute()) {
            listBuilder.accept(new Visitor[]{new TypedVisitor<ServiceBuilder>(){

                public void visit(ServiceBuilder serviceBuilder) {
                    RouteEnricher.this.addRoute(listBuilder, serviceBuilder);
                }
            }});
        }
    }

    private void addRoute(KubernetesListBuilder listBuilder, ServiceBuilder serviceBuilder) {
        String serviceName = serviceBuilder.editOrNewMetadata().getName();
        if (StringUtils.isNotBlank((CharSequence)serviceName) && this.canExposeService(serviceBuilder)) {
            if (!(this.getCreateExternalUrls() || this.isExposedWithLabel(serviceBuilder) || this.hasWebPorts(serviceBuilder))) {
                this.getLog().debug("Skipping Route creation for service %s as it has no web ports and jkube.createExternalUrls is false", new Object[]{serviceName});
                return;
            }
            this.updateRouteDomainPostFixBasedOnServiceName(serviceName);
            Route opinionatedRoute = RouteEnricher.createOpinionatedRouteFromService(serviceBuilder, this.routeDomainPostfix, this.getConfig(Config.TLS_TERMINATION, "edge"), this.getConfig(Config.TLS_INSECURE_EDGE_TERMINATION_POLICY, "Allow"), this.isRouteWithTLS());
            if (opinionatedRoute != null) {
                Route mergeableRouteFragment = RouteEnricher.getMergeableFragment(listBuilder, serviceName);
                if (mergeableRouteFragment != null) {
                    KubernetesResourceUtil.removeItemFromKubernetesBuilder((KubernetesListBuilder)listBuilder, (HasMetadata)mergeableRouteFragment);
                    Route mergedRoute = RouteEnricher.mergeRoute(mergeableRouteFragment, opinionatedRoute);
                    listBuilder.addToItems(new HasMetadata[]{mergedRoute});
                } else {
                    listBuilder.addToItems(new HasMetadata[]{opinionatedRoute});
                }
            }
        }
    }

    private static RoutePort createRoutePort(ServicePort servicePortToExpose) {
        RoutePort routePort = new RoutePort();
        String servicePortName = servicePortToExpose.getName();
        if (servicePortName != null) {
            routePort.setTargetPort(new IntOrString((Object)servicePortName));
            return routePort;
        }
        IntOrString serviceTargetPort = servicePortToExpose.getTargetPort();
        if (serviceTargetPort != null && serviceTargetPort.getValue() != null) {
            routePort.setTargetPort(serviceTargetPort);
            return routePort;
        }
        Integer servicePort = servicePortToExpose.getPort();
        routePort.setTargetPort(new IntOrString((Object)servicePort));
        return routePort;
    }

    private String prepareHostForRoute(String routeDomainPostfix, String name) {
        String ret = FileUtil.stripPostfix((String)name, (String)"-service");
        ret = FileUtil.stripPostfix((String)ret, (String)".");
        ret = ret + ".";
        ret = ret + FileUtil.stripPrefix((String)routeDomainPostfix, (String)".");
        return ret;
    }

    private void updateRouteDomainPostFixBasedOnServiceName(String serviceName) {
        this.routeDomainPostfix = StringUtils.isNotBlank((CharSequence)this.routeDomainPostfix) ? this.prepareHostForRoute(this.routeDomainPostfix, serviceName) : "";
    }

    static Route mergeRoute(Route routeFromFragment, Route opinionatedRoute) {
        if (routeFromFragment.getApiVersion().equals("v1")) {
            routeFromFragment.setApiVersion(opinionatedRoute.getApiVersion());
        }
        KubernetesResourceUtil.mergeMetadata((HasMetadata)routeFromFragment, (HasMetadata)opinionatedRoute);
        routeFromFragment.getMetadata().setName(opinionatedRoute.getMetadata().getName());
        if (routeFromFragment.getSpec() != null) {
            routeFromFragment.setSpec(RouteEnricher.mergeRouteSpec(routeFromFragment.getSpec(), opinionatedRoute.getSpec()));
        } else {
            routeFromFragment.setSpec(opinionatedRoute.getSpec());
        }
        return routeFromFragment;
    }

    static RouteSpec mergeRouteSpec(RouteSpec fragmentSpec, RouteSpec opinionatedSpec) {
        KubernetesResourceUtil.mergeSimpleFields((Object)fragmentSpec, (Object)opinionatedSpec);
        if (fragmentSpec.getAlternateBackends() == null && opinionatedSpec.getAlternateBackends() != null) {
            fragmentSpec.setAlternateBackends(opinionatedSpec.getAlternateBackends());
        }
        if (fragmentSpec.getPort() == null && opinionatedSpec.getPort() != null) {
            fragmentSpec.setPort(opinionatedSpec.getPort());
        }
        if (fragmentSpec.getTls() == null && opinionatedSpec.getTls() != null) {
            fragmentSpec.setTls(opinionatedSpec.getTls());
        }
        if (fragmentSpec.getTo() == null && opinionatedSpec.getTo() != null) {
            fragmentSpec.setTo(opinionatedSpec.getTo());
        }
        return fragmentSpec;
    }

    static Route getMergeableFragment(KubernetesListBuilder listBuilder, String name) {
        for (HasMetadata item : listBuilder.buildItems()) {
            if (!(item instanceof Route) || item.getMetadata() != null && item.getMetadata().getName() != null && !Objects.equals(item.getMetadata().getName(), name)) continue;
            return (Route)item;
        }
        return null;
    }

    private static void handleTlsTermination(RouteBuilder routeBuilder, String tlsTermination, String edgeTerminationPolicy, boolean isRouteWithTLS) {
        if (isRouteWithTLS) {
            ((RouteFluent.SpecNested)((RouteSpecFluent.TlsNested)((RouteSpecFluent.TlsNested)routeBuilder.editSpec().editOrNewTls().withInsecureEdgeTerminationPolicy(edgeTerminationPolicy)).withTermination(tlsTermination)).endTls()).endSpec();
        }
    }

    static Route createOpinionatedRouteFromService(ServiceBuilder serviceBuilder, String routeDomainPostfix, String tlsTermination, String edgeTerminationPolicy, boolean isRouteWithTls) {
        ObjectMeta serviceMetadata = serviceBuilder.buildMetadata();
        if (serviceMetadata != null) {
            RoutePort routePort = null;
            String name = serviceMetadata.getName();
            ServicePort servicePortToExpose = DefaultServiceEnricher.getServicePortToExpose(serviceBuilder);
            if (servicePortToExpose != null && (servicePortToExpose.getName() != null || servicePortToExpose.getPort() != null || servicePortToExpose.getTargetPort() != null)) {
                routePort = RouteEnricher.createRoutePort(servicePortToExpose);
            }
            if (routePort != null) {
                RouteBuilder routeBuilder = (RouteBuilder)((RouteFluent.SpecNested)((RouteFluent.SpecNested)((RouteSpecFluent.ToNested)((RouteSpecFluent.ToNested)((RouteFluent.SpecNested)((RouteBuilder)new RouteBuilder().withMetadata(serviceMetadata)).withNewSpec().withPort(routePort)).withNewTo().withKind("Service")).withName(name)).endTo()).withHost(routeDomainPostfix.isEmpty() ? null : routeDomainPostfix)).endSpec();
                RouteEnricher.handleTlsTermination(routeBuilder, tlsTermination, edgeTerminationPolicy, isRouteWithTls);
                routeBuilder.withNewMetadataLike(routeBuilder.buildMetadata());
                return routeBuilder.build();
            }
        }
        return null;
    }

    private static enum Config implements Configs.Config
    {
        GENERATE_ROUTE("generateRoute", "true"),
        TLS_TERMINATION("tlsTermination", null),
        TLS_INSECURE_EDGE_TERMINATION_POLICY("tlsInsecureEdgeTerminationPolicy", null);

        protected String key;
        protected String defaultValue;

        @Generated
        private Config(String key, String defaultValue) {
            this.key = key;
            this.defaultValue = defaultValue;
        }

        @Generated
        public String getKey() {
            return this.key;
        }

        @Generated
        public String getDefaultValue() {
            return this.defaultValue;
        }
    }
}

