/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.enricher.generic;

import io.fabric8.kubernetes.api.builder.TypedVisitor;
import io.fabric8.kubernetes.api.builder.Visitor;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KubernetesListBuilder;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ServiceBuilder;
import io.fabric8.kubernetes.api.model.extensions.IngressBuilder;
import io.fabric8.kubernetes.api.model.networking.v1.Ingress;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jkube.enricher.generic.ingress.ExtensionsV1beta1IngressConverter;
import org.eclipse.jkube.enricher.generic.ingress.NetworkingV1IngressGenerator;
import org.eclipse.jkube.kit.common.Configs;
import org.eclipse.jkube.kit.config.resource.IngressConfig;
import org.eclipse.jkube.kit.config.resource.IngressRuleConfig;
import org.eclipse.jkube.kit.config.resource.IngressTlsConfig;
import org.eclipse.jkube.kit.config.resource.PlatformMode;
import org.eclipse.jkube.kit.config.resource.ResourceConfig;
import org.eclipse.jkube.kit.enricher.api.BaseEnricher;
import org.eclipse.jkube.kit.enricher.api.EnricherContext;
import org.eclipse.jkube.kit.enricher.api.JKubeEnricherContext;
import org.eclipse.jkube.kit.enricher.api.ServiceExposer;

public class IngressEnricher
extends BaseEnricher
implements ServiceExposer {
    public IngressEnricher(JKubeEnricherContext buildContext) {
        super((EnricherContext)buildContext, "jkube-ingress");
    }

    public void create(PlatformMode platformMode, final KubernetesListBuilder listBuilder) {
        if (!this.getCreateExternalUrls()) {
            return;
        }
        if (platformMode == PlatformMode.kubernetes) {
            listBuilder.accept(new Visitor[]{new TypedVisitor<ServiceBuilder>(){

                public void visit(ServiceBuilder serviceBuilder) {
                    if (!IngressEnricher.this.canExposeService(serviceBuilder)) {
                        IngressEnricher.this.getLog().debug("Service %s cannot be exposed", new Object[]{serviceBuilder.editOrNewMetadata().getName()});
                        return;
                    }
                    if (IngressEnricher.hasIngressForService(listBuilder, serviceBuilder)) {
                        IngressEnricher.this.getLog().debug("Service %s already has an Ingress", new Object[]{serviceBuilder.editOrNewMetadata().getName()});
                        return;
                    }
                    HasMetadata generatedIngress = IngressEnricher.this.generateIngressWithConfiguredApiVersion(serviceBuilder);
                    if (generatedIngress != null) {
                        listBuilder.addToItems(new HasMetadata[]{generatedIngress});
                    }
                }
            }});
            this.logHintIfNoDomainOrHostProvided();
        }
    }

    private HasMetadata generateIngressWithConfiguredApiVersion(ServiceBuilder serviceBuilder) {
        Ingress ingress;
        ResourceConfig resourceConfig = this.getConfiguration().getResource();
        Ingress generatedIngress = ingress = NetworkingV1IngressGenerator.generate(serviceBuilder, this.getRouteDomain(), this.getConfig(Config.HOST), IngressEnricher.getIngressRuleXMLConfig(resourceConfig), IngressEnricher.getIngressTlsXMLConfig(resourceConfig));
        String targetIngressApiVersion = this.getConfig(Config.TARGET_API_VERSION);
        if (targetIngressApiVersion.equalsIgnoreCase("extensions/v1beta1")) {
            generatedIngress = ExtensionsV1beta1IngressConverter.convert(ingress);
        }
        return generatedIngress;
    }

    private static boolean hasIngressForService(KubernetesListBuilder listBuilder, ServiceBuilder service) {
        final String serviceName = service.editOrNewMetadata().getName();
        final AtomicBoolean answer = new AtomicBoolean(false);
        listBuilder.accept(new Visitor[]{new TypedVisitor<IngressBuilder>(){

            public void visit(IngressBuilder builder) {
                ObjectMeta metadata = builder.buildMetadata();
                if (metadata != null && Objects.equals(serviceName, metadata.getName())) {
                    answer.set(true);
                }
            }
        }});
        listBuilder.accept(new Visitor[]{new TypedVisitor<io.fabric8.kubernetes.api.model.networking.v1.IngressBuilder>(){

            public void visit(io.fabric8.kubernetes.api.model.networking.v1.IngressBuilder builder) {
                ObjectMeta metadata = builder.buildMetadata();
                if (metadata != null && Objects.equals(serviceName, metadata.getName())) {
                    answer.set(true);
                }
            }
        }});
        return answer.get();
    }

    protected String getRouteDomain() {
        if (this.getConfiguration().getResource() != null && StringUtils.isNotEmpty((CharSequence)this.getConfiguration().getResource().getRouteDomain())) {
            return this.getConfiguration().getResource().getRouteDomain();
        }
        String routeDomainFromProperties = this.getValueFromConfig("jkube.domain", "");
        if (StringUtils.isNotEmpty((CharSequence)routeDomainFromProperties)) {
            return routeDomainFromProperties;
        }
        return null;
    }

    void logHintIfNoDomainOrHostProvided() {
        ResourceConfig resourceConfig = this.getContext().getConfiguration().getResource();
        if (resourceConfig != null && resourceConfig.getIngress() != null) {
            this.logHintIfNoDomainOrHostForResourceConfig(resourceConfig);
        } else if (StringUtils.isBlank((CharSequence)this.getRouteDomain()) && StringUtils.isBlank((CharSequence)this.getConfig(Config.HOST))) {
            this.logJKubeDomainHint();
        }
    }

    private void logHintIfNoDomainOrHostForResourceConfig(ResourceConfig resourceConfig) {
        Optional<String> configuredHost;
        List<IngressRuleConfig> ingressRuleConfigs = IngressEnricher.getIngressRuleXMLConfig(resourceConfig);
        if (!ingressRuleConfigs.isEmpty() && !(configuredHost = ingressRuleConfigs.stream().map(IngressRuleConfig::getHost).filter(StringUtils::isNotBlank).findAny()).isPresent()) {
            this.logJKubeDomainHint();
        }
    }

    private void logJKubeDomainHint() {
        this.getContext().getLog().info("[[B]]HINT:[[B]] No host configured for Ingress. You might want to use `jkube.domain` to add desired host suffix", new Object[0]);
    }

    static List<IngressRuleConfig> getIngressRuleXMLConfig(ResourceConfig resourceConfig) {
        return Optional.ofNullable(resourceConfig).map(ResourceConfig::getIngress).map(IngressConfig::getIngressRules).orElse(Collections.emptyList());
    }

    static List<IngressTlsConfig> getIngressTlsXMLConfig(ResourceConfig resourceConfig) {
        return Optional.ofNullable(resourceConfig).map(ResourceConfig::getIngress).map(IngressConfig::getIngressTlsConfigs).orElse(Collections.emptyList());
    }

    public static enum Config implements Configs.Config
    {
        HOST("host", null),
        TARGET_API_VERSION("targetApiVersion", "networking.k8s.io/v1");

        protected String key;
        protected String defaultValue;

        @Generated
        private Config(String key, String defaultValue) {
            this.key = key;
            this.defaultValue = defaultValue;
        }

        @Generated
        public String getKey() {
            return this.key;
        }

        @Generated
        public String getDefaultValue() {
            return this.defaultValue;
        }
    }
}

