/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.enricher.generic;

import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jkube.enricher.generic.AbstractLabelEnricher;
import org.eclipse.jkube.kit.common.Configs;
import org.eclipse.jkube.kit.config.resource.GroupArtifactVersion;
import org.eclipse.jkube.kit.enricher.api.EnricherContext;
import org.eclipse.jkube.kit.enricher.api.JKubeEnricherContext;

public class WellKnownLabelsEnricher
extends AbstractLabelEnricher {
    public static final String KUBERNETES_APP_LABEL = "app.kubernetes.io/";
    private static final String WELL_KNOWN_LABELS_PROPERTY = "jkube.kubernetes.well-known-labels";

    public WellKnownLabelsEnricher(JKubeEnricherContext buildContext) {
        super((EnricherContext)buildContext, "jkube-well-known-labels");
    }

    private boolean shouldAddWellKnownLabels() {
        return Configs.asBoolean((String)this.getConfigWithFallback(Config.ENABLED, WELL_KNOWN_LABELS_PROPERTY, "true"));
    }

    @Override
    public Map<String, String> createLabels(boolean includeVersion, Map<String, String> labelsViaResourceConfig) {
        HashMap<String, String> ret = new HashMap<String, String>();
        if (!this.shouldAddWellKnownLabels()) {
            return ret;
        }
        GroupArtifactVersion groupArtifactVersion = this.getContext().getGav();
        ret.putAll(this.addWellKnownLabelFromApplicableSource(Config.APP_NAME, "name", groupArtifactVersion.getArtifactId(), labelsViaResourceConfig));
        if (includeVersion) {
            ret.putAll(this.addWellKnownLabelFromApplicableSource(Config.APP_VERSION, "version", groupArtifactVersion.getVersion(), labelsViaResourceConfig));
        }
        ret.putAll(this.addWellKnownLabelFromApplicableSource(Config.APP_PART_OF, "part-of", groupArtifactVersion.getGroupId(), labelsViaResourceConfig));
        ret.putAll(this.addWellKnownLabelFromApplicableSource(Config.APP_MANAGED_BY, "managed-by", "jkube", labelsViaResourceConfig));
        ret.putAll(this.addWellKnownLabelFromApplicableSource(Config.APP_COMPONENT, "component", null, labelsViaResourceConfig));
        return ret;
    }

    private Map<String, String> addWellKnownLabelFromApplicableSource(Configs.Config key, String labelKey, String defaultValue, Map<String, String> labelsViaResourceConfig) {
        HashMap<String, String> entryMap = new HashMap<String, String>();
        String appLabel = KUBERNETES_APP_LABEL + labelKey;
        String appLabelValueFromConfig = this.getConfig(key, defaultValue);
        if (labelsViaResourceConfig.containsKey(appLabel)) {
            entryMap.put(appLabel, labelsViaResourceConfig.get(appLabel));
        } else if (StringUtils.isNotBlank((CharSequence)appLabelValueFromConfig)) {
            entryMap.put(appLabel, appLabelValueFromConfig);
        }
        return entryMap;
    }

    private static enum Config implements Configs.Config
    {
        ENABLED("enabled", "true"),
        APP_NAME("name", null),
        APP_VERSION("version", null),
        APP_COMPONENT("component", null),
        APP_PART_OF("partOf", null),
        APP_MANAGED_BY("managedBy", "jkube");

        protected String key;
        protected String defaultValue;

        @Generated
        private Config(String key, String defaultValue) {
            this.key = key;
            this.defaultValue = defaultValue;
        }

        @Generated
        public String getKey() {
            return this.key;
        }

        @Generated
        public String getDefaultValue() {
            return this.defaultValue;
        }
    }
}

