/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.enricher.generic.openshift;

import io.fabric8.kubernetes.api.builder.TypedVisitor;
import io.fabric8.kubernetes.api.builder.Visitor;
import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.KubernetesListBuilder;
import io.fabric8.kubernetes.api.model.PodSpec;
import io.fabric8.kubernetes.api.model.PodTemplateSpec;
import io.fabric8.kubernetes.api.model.PodTemplateSpecFluent;
import io.fabric8.openshift.api.model.DeploymentConfigSpecBuilder;
import io.fabric8.openshift.api.model.DeploymentConfigSpecFluent;
import io.fabric8.openshift.api.model.DeploymentTriggerImageChangeParamsFluent;
import io.fabric8.openshift.api.model.DeploymentTriggerPolicyFluent;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;
import org.eclipse.jkube.kit.common.Configs;
import org.eclipse.jkube.kit.config.image.ImageName;
import org.eclipse.jkube.kit.config.image.build.JKubeBuildStrategy;
import org.eclipse.jkube.kit.config.resource.PlatformMode;
import org.eclipse.jkube.kit.enricher.api.BaseEnricher;
import org.eclipse.jkube.kit.enricher.api.EnricherContext;

public class ImageChangeTriggerEnricher
extends BaseEnricher {
    private static final String ENRICHER_NAME = "jkube-openshift-imageChangeTrigger";
    private final boolean enableAutomaticTrigger = this.getValueFromConfig("jkube.openshift.enableAutomaticTrigger", true);
    private final boolean enableImageChangeTrigger = this.getValueFromConfig("jkube.openshift.imageChangeTriggers", true);
    private final boolean trimImageInContainerSpecFlag = this.getValueFromConfig("jkube.openshift.trimImageInContainerSpec", false);

    public ImageChangeTriggerEnricher(EnricherContext context) {
        super(context, ENRICHER_NAME);
    }

    public void create(PlatformMode platformMode, KubernetesListBuilder builder) {
        if (platformMode.equals((Object)PlatformMode.kubernetes)) {
            return;
        }
        builder.accept(new Visitor[]{new TypedVisitor<DeploymentConfigSpecBuilder>(){

            public void visit(DeploymentConfigSpecBuilder builder) {
                HashMap<String, String> containerToImageMap = new HashMap<String, String>();
                PodTemplateSpec template = builder.buildTemplate();
                if (template != null) {
                    PodSpec podSpec = template.getSpec();
                    Objects.requireNonNull(podSpec, "No PodSpec for PodTemplate:" + template);
                    List containers = podSpec.getContainers();
                    for (Container container : containers) {
                        if (container.getName() == null || container.getImage() == null) continue;
                        containerToImageMap.put(container.getName(), container.getImage());
                    }
                }
                if (!containerToImageMap.isEmpty() && ImageChangeTriggerEnricher.this.enableImageChangeTrigger && ImageChangeTriggerEnricher.this.isOpenShiftMode()) {
                    for (Map.Entry entry : containerToImageMap.entrySet()) {
                        String containerName = (String)entry.getKey();
                        if (!ImageChangeTriggerEnricher.this.isImageChangeTriggerNeeded(containerName)) continue;
                        ImageName image = new ImageName((String)entry.getValue());
                        String tag = image.getTag() != null ? image.getTag() : "latest";
                        ((DeploymentConfigSpecFluent.TriggersNested)((DeploymentTriggerPolicyFluent.ImageChangeParamsNested)((DeploymentTriggerPolicyFluent.ImageChangeParamsNested)((DeploymentTriggerImageChangeParamsFluent.FromNested)((DeploymentTriggerImageChangeParamsFluent.FromNested)((DeploymentTriggerPolicyFluent.ImageChangeParamsNested)((DeploymentConfigSpecFluent.TriggersNested)builder.addNewTrigger().withType("ImageChange")).withNewImageChangeParams().withAutomatic(Boolean.valueOf(ImageChangeTriggerEnricher.this.enableAutomaticTrigger))).withNewFrom().withKind("ImageStreamTag")).withName(image.getSimpleName() + ":" + tag)).endFrom()).withContainerNames(new String[]{containerName})).endImageChangeParams()).endTrigger();
                    }
                    if (ImageChangeTriggerEnricher.this.trimImageInContainerSpecFlag) {
                        ((DeploymentConfigSpecFluent.TemplateNested)((PodTemplateSpecFluent.SpecNested)builder.editTemplate().editSpec().withContainers(ImageChangeTriggerEnricher.this.trimImagesInContainers(template))).endSpec()).endTemplate();
                    }
                }
            }
        }});
    }

    private boolean isImageChangeTriggerNeeded(String containerName) {
        String containersFromConfig = Configs.asString((String)this.getConfig(Config.CONTAINERS));
        boolean enrichAll = this.getValueFromConfig("jkube.openshift.enrichAllWithImageChangeTrigger", false);
        JKubeBuildStrategy buildStrategy = this.getContext().getConfiguration().getJKubeBuildStrategy();
        if (enrichAll) {
            return true;
        }
        if (buildStrategy != null && buildStrategy.equals((Object)JKubeBuildStrategy.jib)) {
            return false;
        }
        return this.getProcessingInstructionViaKey("FABRIC8_GENERATED_CONTAINERS").contains(containerName) || this.getProcessingInstructionViaKey("IMAGECHANGE_TRIGGER").contains(containerName) || Arrays.asList(containersFromConfig.split(",")).contains(containerName);
    }

    private List<Container> trimImagesInContainers(PodTemplateSpec template) {
        List containers = template.getSpec().getContainers();
        containers.forEach(container -> container.setImage(""));
        return containers;
    }

    private static enum Config implements Configs.Config
    {
        CONTAINERS("containers", "");

        protected String key;
        protected String defaultValue;

        @Generated
        private Config(String key, String defaultValue) {
            this.key = key;
            this.defaultValue = defaultValue;
        }

        @Generated
        public String getKey() {
            return this.key;
        }

        @Generated
        public String getDefaultValue() {
            return this.defaultValue;
        }
    }
}

