/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.enricher.generic;

import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KubernetesListBuilder;
import io.fabric8.kubernetes.api.model.PodTemplateSpec;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.eclipse.jkube.enricher.generic.ControllerViaPluginConfigurationEnricher;
import org.eclipse.jkube.kit.common.Configs;
import org.eclipse.jkube.kit.common.util.JKubeProjectUtil;
import org.eclipse.jkube.kit.config.resource.PlatformMode;
import org.eclipse.jkube.kit.config.resource.ResourceConfig;
import org.eclipse.jkube.kit.enricher.api.BaseEnricher;
import org.eclipse.jkube.kit.enricher.api.EnricherContext;
import org.eclipse.jkube.kit.enricher.api.JKubeEnricherContext;
import org.eclipse.jkube.kit.enricher.api.util.KubernetesResourceUtil;
import org.eclipse.jkube.kit.enricher.handler.ControllerHandler;
import org.eclipse.jkube.kit.enricher.handler.HandlerHub;

public class DefaultControllerEnricher
extends BaseEnricher {
    public static final String ENRICHER_NAME = "jkube-controller";
    private final HandlerHub handlerHub = new HandlerHub(this.getContext().getGav(), this.getContext().getProperties());

    public DefaultControllerEnricher(JKubeEnricherContext buildContext) {
        super((EnricherContext)buildContext, ENRICHER_NAME);
    }

    public void create(PlatformMode platformMode, KubernetesListBuilder builder) {
        String name = this.getConfig(Config.NAME, JKubeProjectUtil.createDefaultResourceName((String)this.getContext().getGav().getSanitizedArtifactId(), (String[])new String[0]));
        ResourceConfig xmlResourceConfig = Optional.ofNullable(this.getConfiguration().getResource()).orElse(ResourceConfig.builder().build());
        ResourceConfig config = ResourceConfig.toBuilder((ResourceConfig)xmlResourceConfig).controllerName(this.getControllerName(xmlResourceConfig, name)).imagePullPolicy(DefaultControllerEnricher.getImagePullPolicy((ResourceConfig)xmlResourceConfig, (String)this.getConfig(Config.PULL_POLICY))).replicas(Integer.valueOf(DefaultControllerEnricher.getReplicaCount((KubernetesListBuilder)builder, (ResourceConfig)xmlResourceConfig, (int)Configs.asInt((String)this.getConfig(Config.REPLICA_COUNT))))).build();
        List images = this.getImages();
        if (!KubernetesResourceUtil.checkForKind((KubernetesListBuilder)builder, (String[])ControllerViaPluginConfigurationEnricher.POD_CONTROLLER_KINDS) && !images.isEmpty()) {
            ControllerType ct = ControllerType.fromType(this.getConfig(Config.TYPE));
            HasMetadata resource = ((ControllerHandler)ct.handler.apply(this.handlerHub)).get(config, images);
            this.log.info("Adding a default %s", new Object[]{resource.getKind()});
            builder.addToItems(new HasMetadata[]{resource});
            this.setProcessingInstruction("FABRIC8_GENERATED_CONTAINERS", DefaultControllerEnricher.getContainersFromPodSpec(((ControllerHandler)ct.handler.apply(this.handlerHub)).getPodTemplateSpec(config, images)));
        }
    }

    private static List<String> getContainersFromPodSpec(PodTemplateSpec spec) {
        return spec.getSpec().getContainers().stream().map(Container::getName).collect(Collectors.toList());
    }

    public static enum Config implements Configs.Config
    {
        NAME("name", null),
        PULL_POLICY("pullPolicy", "IfNotPresent"),
        TYPE("type", null),
        REPLICA_COUNT("replicaCount", "1");

        protected String key;
        protected String defaultValue;

        private Config(String key, String defaultValue) {
            this.key = key;
            this.defaultValue = defaultValue;
        }

        public String getKey() {
            return this.key;
        }

        public String getDefaultValue() {
            return this.defaultValue;
        }
    }

    private static enum ControllerType {
        DEPLOYMENT(HandlerHub::getDeploymentHandler),
        STATEFUL_SET(HandlerHub::getStatefulSetHandler),
        DAEMON_SET(HandlerHub::getDaemonSetHandler),
        REPLICA_SET(HandlerHub::getReplicaSetHandler),
        REPLICATION_CONTROLLER(HandlerHub::getReplicationControllerHandler),
        JOB(HandlerHub::getJobHandler);

        private final Function<HandlerHub, ControllerHandler<?>> handler;

        private ControllerType(Function<HandlerHub, ControllerHandler<?>> handler) {
            this.handler = handler;
        }

        private static ControllerType fromType(String type) {
            switch (Optional.ofNullable(type).orElse("").toUpperCase(Locale.ENGLISH)) {
                case "STATEFULSET": {
                    return STATEFUL_SET;
                }
                case "DAEMONSET": {
                    return DAEMON_SET;
                }
                case "REPLICASET": {
                    return REPLICA_SET;
                }
                case "REPLICATIONCONTROLLER": {
                    return REPLICATION_CONTROLLER;
                }
                case "JOB": {
                    return JOB;
                }
            }
            return DEPLOYMENT;
        }
    }
}

