/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.enricher.generic;

import io.fabric8.kubernetes.api.builder.TypedVisitor;
import io.fabric8.kubernetes.api.builder.Visitor;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.IntOrString;
import io.fabric8.kubernetes.api.model.KubernetesListBuilder;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.ServiceBuilder;
import io.fabric8.kubernetes.api.model.ServicePort;
import io.fabric8.kubernetes.api.model.ServiceSpec;
import io.fabric8.kubernetes.api.model.extensions.HTTPIngressPath;
import io.fabric8.kubernetes.api.model.extensions.HTTPIngressPathBuilder;
import io.fabric8.kubernetes.api.model.extensions.HTTPIngressPathFluent;
import io.fabric8.kubernetes.api.model.extensions.HTTPIngressRuleValueBuilder;
import io.fabric8.kubernetes.api.model.extensions.Ingress;
import io.fabric8.kubernetes.api.model.extensions.IngressBackend;
import io.fabric8.kubernetes.api.model.extensions.IngressBackendBuilder;
import io.fabric8.kubernetes.api.model.extensions.IngressBuilder;
import io.fabric8.kubernetes.api.model.extensions.IngressRule;
import io.fabric8.kubernetes.api.model.extensions.IngressRuleBuilder;
import io.fabric8.kubernetes.api.model.extensions.IngressRuleFluent;
import io.fabric8.kubernetes.api.model.extensions.IngressSpec;
import io.fabric8.kubernetes.api.model.extensions.IngressSpecBuilder;
import io.fabric8.kubernetes.api.model.extensions.IngressSpecFluent;
import io.fabric8.kubernetes.api.model.extensions.IngressTLS;
import io.fabric8.kubernetes.api.model.extensions.IngressTLSBuilder;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jkube.kit.common.KitLogger;
import org.eclipse.jkube.kit.common.util.FileUtil;
import org.eclipse.jkube.kit.common.util.KubernetesHelper;
import org.eclipse.jkube.kit.config.resource.IngressConfig;
import org.eclipse.jkube.kit.config.resource.IngressRuleConfig;
import org.eclipse.jkube.kit.config.resource.IngressRulePathConfig;
import org.eclipse.jkube.kit.config.resource.IngressRulePathResourceConfig;
import org.eclipse.jkube.kit.config.resource.IngressTlsConfig;
import org.eclipse.jkube.kit.config.resource.JKubeAnnotations;
import org.eclipse.jkube.kit.config.resource.PlatformMode;
import org.eclipse.jkube.kit.config.resource.ResourceConfig;
import org.eclipse.jkube.kit.enricher.api.BaseEnricher;
import org.eclipse.jkube.kit.enricher.api.EnricherContext;
import org.eclipse.jkube.kit.enricher.api.JKubeEnricherContext;
import org.eclipse.jkube.kit.enricher.api.util.KubernetesResourceUtil;

public class IngressEnricher
extends BaseEnricher {
    public static final String EXPOSE_LABEL = "expose";

    public IngressEnricher(JKubeEnricherContext buildContext) {
        super((EnricherContext)buildContext, "jkube-ingress");
    }

    public void create(PlatformMode platformMode, final KubernetesListBuilder listBuilder) {
        final ResourceConfig resourceConfig = this.getConfiguration().getResource();
        Boolean shouldCreateIngress = this.getValueFromConfig("jkube.createExternalUrls", false);
        if (shouldCreateIngress.equals(Boolean.FALSE)) {
            return;
        }
        if (platformMode == PlatformMode.kubernetes) {
            listBuilder.accept(new Visitor[]{new TypedVisitor<ServiceBuilder>(){

                public void visit(ServiceBuilder serviceBuilder) {
                    Ingress ingress = IngressEnricher.generateIngress(listBuilder, serviceBuilder, IngressEnricher.this.getRouteDomain(resourceConfig), IngressEnricher.getIngressRuleXMLConfig(resourceConfig), IngressEnricher.getIngressTlsXMLConfig(resourceConfig), IngressEnricher.this.log);
                    if (ingress != null) {
                        listBuilder.addToItems(new HasMetadata[]{ingress});
                    }
                }
            }});
        }
    }

    protected static Ingress generateIngress(KubernetesListBuilder listBuilder, ServiceBuilder serviceBuilder, String routeDomainPostfix, List<IngressRuleConfig> ingressRuleConfigs, List<IngressTlsConfig> ingressTlsConfigs, KitLogger log) {
        ObjectMeta serviceMetadata = serviceBuilder.buildMetadata();
        if (serviceMetadata == null) {
            log.info("No Metadata for service! ", new Object[0]);
        }
        if (KubernetesResourceUtil.isExposedService((ObjectMeta)serviceMetadata) && IngressEnricher.shouldCreateExternalURLForService(serviceBuilder, log)) {
            Integer servicePort;
            Objects.requireNonNull(serviceMetadata);
            String serviceName = serviceMetadata.getName();
            if (!IngressEnricher.hasIngress(listBuilder, serviceName) && (servicePort = IngressEnricher.getServicePort(serviceBuilder)) != null) {
                return ((IngressBuilder)((IngressBuilder)new IngressBuilder().withMetadata(IngressEnricher.getIngressMetadata(serviceMetadata))).withSpec(IngressEnricher.getIngressSpec(routeDomainPostfix, serviceName, servicePort, ingressRuleConfigs, ingressTlsConfigs))).build();
            }
        }
        return null;
    }

    private static ObjectMeta getIngressMetadata(ObjectMeta serviceMetadata) {
        ObjectMetaBuilder ingressMetadataBuilder = new ObjectMetaBuilder(serviceMetadata);
        ingressMetadataBuilder.removeFromLabels(Collections.singletonMap(EXPOSE_LABEL, "true"));
        ingressMetadataBuilder.removeFromLabels(Collections.singletonMap(JKubeAnnotations.SERVICE_EXPOSE_URL.value(), "true"));
        return ingressMetadataBuilder.build();
    }

    private static IngressSpec getIngressSpec(String routeDomainPostfix, String serviceName, Integer servicePort, List<IngressRuleConfig> ingressRuleConfig, List<IngressTlsConfig> ingressTlsConfigs) {
        if (ingressRuleConfig == null || ingressRuleConfig.isEmpty()) {
            return IngressEnricher.getOpinionatedIngressSpec(routeDomainPostfix, serviceName, servicePort);
        }
        return IngressEnricher.getXmlConfiguredIngressSpec(ingressRuleConfig, ingressTlsConfigs);
    }

    private static IngressSpec getXmlConfiguredIngressSpec(List<IngressRuleConfig> ingressRuleConfigs, List<IngressTlsConfig> ingressTlsConfigs) {
        IngressSpecBuilder ingressSpecBuilder = new IngressSpecBuilder();
        for (IngressRuleConfig ingressRuleConfig : ingressRuleConfigs) {
            IngressRule ingressRule = IngressEnricher.getIngressRuleFromXmlConfig(ingressRuleConfig);
            ingressSpecBuilder.addToRules(new IngressRule[]{ingressRule});
        }
        for (IngressTlsConfig ingressTlsConfig : ingressTlsConfigs) {
            IngressTLS ingressTLS = IngressEnricher.getIngressTlsFromXMLConfig(ingressTlsConfig);
            ingressSpecBuilder.addToTls(new IngressTLS[]{ingressTLS});
        }
        return ingressSpecBuilder.build();
    }

    private static IngressTLS getIngressTlsFromXMLConfig(IngressTlsConfig ingressTlsConfig) {
        IngressTLSBuilder ingressTLSBuilder = new IngressTLSBuilder();
        if (ingressTlsConfig.getHosts() != null && !ingressTlsConfig.getHosts().isEmpty()) {
            ingressTLSBuilder.withHosts(ingressTlsConfig.getHosts());
        }
        if (ingressTlsConfig.getSecretName() != null) {
            ingressTLSBuilder.withSecretName(ingressTlsConfig.getSecretName());
        }
        return ingressTLSBuilder.build();
    }

    private static IngressSpec getOpinionatedIngressSpec(String routeDomainPostfix, String serviceName, Integer servicePort) {
        IngressSpecBuilder ingressSpecBuilder = new IngressSpecBuilder();
        if (StringUtils.isNotBlank((CharSequence)routeDomainPostfix)) {
            routeDomainPostfix = serviceName + "." + FileUtil.stripPrefix((String)routeDomainPostfix, (String)".");
            ((IngressSpecBuilder)((IngressSpecFluent.RulesNested)((IngressRuleFluent.HttpNested)((IngressSpecFluent.RulesNested)ingressSpecBuilder.addNewRule().withHost(routeDomainPostfix)).withNewHttp().withPaths(new HTTPIngressPath[]{((HTTPIngressPathBuilder)((HTTPIngressPathFluent.BackendNested)((HTTPIngressPathFluent.BackendNested)new HTTPIngressPathBuilder().withNewBackend().withServiceName(serviceName)).withServicePort(KubernetesHelper.createIntOrString((int)servicePort))).endBackend()).build()})).endHttp()).endRule()).build();
        } else {
            ingressSpecBuilder.withBackend(((IngressBackendBuilder)((IngressBackendBuilder)new IngressBackendBuilder().withNewServiceName(serviceName)).withNewServicePort(servicePort)).build());
        }
        return ingressSpecBuilder.build();
    }

    private static IngressRule getIngressRuleFromXmlConfig(IngressRuleConfig ingressRuleConfig) {
        IngressRuleBuilder ingressRuleBuilder = new IngressRuleBuilder();
        if (ingressRuleConfig.getHost() != null) {
            ingressRuleBuilder.withHost(ingressRuleConfig.getHost());
        }
        if (ingressRuleConfig.getPaths() != null && !ingressRuleConfig.getPaths().isEmpty()) {
            HTTPIngressRuleValueBuilder httpIngressPathBuilder = new HTTPIngressRuleValueBuilder();
            for (IngressRulePathConfig ingressRulePathConfig : ingressRuleConfig.getPaths()) {
                httpIngressPathBuilder.addToPaths(new HTTPIngressPath[]{IngressEnricher.getHTTPIngressPath(ingressRulePathConfig)});
            }
            ingressRuleBuilder.withHttp(httpIngressPathBuilder.build());
        }
        return ingressRuleBuilder.build();
    }

    private static HTTPIngressPath getHTTPIngressPath(IngressRulePathConfig ingressRulePathConfig) {
        HTTPIngressPathBuilder httpIngressPathBuilder = new HTTPIngressPathBuilder();
        if (ingressRulePathConfig.getPath() != null) {
            httpIngressPathBuilder.withPath(ingressRulePathConfig.getPath());
        }
        if (ingressRulePathConfig.getPathType() != null) {
            httpIngressPathBuilder.withPathType(ingressRulePathConfig.getPathType());
        }
        return ((HTTPIngressPathBuilder)httpIngressPathBuilder.withBackend(IngressEnricher.getIngressBackend(ingressRulePathConfig))).build();
    }

    private static IngressBackend getIngressBackend(IngressRulePathConfig ingressRulePathConfig) {
        IngressBackendBuilder ingressBackendBuilder = new IngressBackendBuilder();
        if (ingressRulePathConfig.getServiceName() != null) {
            ingressBackendBuilder.withServiceName(ingressRulePathConfig.getServiceName());
        }
        if (ingressRulePathConfig.getServicePort() > 0) {
            ingressBackendBuilder.withServicePort(new IntOrString(Integer.valueOf(ingressRulePathConfig.getServicePort())));
        }
        if (ingressRulePathConfig.getResource() != null) {
            IngressRulePathResourceConfig resource = ingressRulePathConfig.getResource();
            ingressBackendBuilder.withNewResource(resource.getApiGroup(), resource.getKind(), resource.getName());
        }
        return ingressBackendBuilder.build();
    }

    static Integer getServicePort(ServiceBuilder serviceBuilder) {
        List ports;
        ServiceSpec spec = serviceBuilder.buildSpec();
        if (spec != null && (ports = spec.getPorts()) != null && !ports.isEmpty()) {
            for (ServicePort port : ports) {
                if (!port.getName().equals("http") && !port.getProtocol().equals("http")) continue;
                return port.getPort();
            }
            ServicePort servicePort = (ServicePort)ports.get(0);
            if (servicePort != null) {
                return servicePort.getPort();
            }
        }
        return 0;
    }

    private static boolean hasIngress(KubernetesListBuilder listBuilder, final String name) {
        final AtomicBoolean answer = new AtomicBoolean(false);
        listBuilder.accept(new Visitor[]{new TypedVisitor<IngressBuilder>(){

            public void visit(IngressBuilder builder) {
                ObjectMeta metadata = builder.buildMetadata();
                if (metadata != null && name.equals(metadata.getName())) {
                    answer.set(true);
                }
            }
        }});
        return answer.get();
    }

    static boolean shouldCreateExternalURLForService(ServiceBuilder service, KitLogger log) {
        String serviceName = service.buildMetadata().getName();
        ServiceSpec spec = service.buildSpec();
        if (spec != null && !IngressEnricher.isKubernetesSystemService(serviceName)) {
            List ports = spec.getPorts();
            log.debug("Service " + serviceName + " has ports: " + ports, new Object[0]);
            if (ports.size() == 1) {
                return true;
            }
            log.info("Not generating Ingress for service " + serviceName + " as only single port services are supported. Has ports: " + ports, new Object[0]);
        }
        return false;
    }

    private static boolean isKubernetesSystemService(String serviceName) {
        return "kubernetes".equals(serviceName) || "kubernetes-ro".equals(serviceName);
    }

    protected String getRouteDomain(ResourceConfig resourceConfig) {
        if (resourceConfig != null && resourceConfig.getRouteDomain() != null) {
            return resourceConfig.getRouteDomain();
        }
        String routeDomainFromProperties = this.getValueFromConfig("jkube.domain", "");
        if (StringUtils.isNotEmpty((CharSequence)routeDomainFromProperties)) {
            return routeDomainFromProperties;
        }
        return null;
    }

    static List<IngressRuleConfig> getIngressRuleXMLConfig(ResourceConfig resourceConfig) {
        return Optional.ofNullable(resourceConfig).map(ResourceConfig::getIngress).map(IngressConfig::getIngressRules).orElse(Collections.emptyList());
    }

    static List<IngressTlsConfig> getIngressTlsXMLConfig(ResourceConfig resourceConfig) {
        return Optional.ofNullable(resourceConfig).map(ResourceConfig::getIngress).map(IngressConfig::getIngressTlsConfigs).orElse(Collections.emptyList());
    }
}

