/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.enricher.generic;

import io.fabric8.kubernetes.api.builder.TypedVisitor;
import io.fabric8.kubernetes.api.builder.Visitor;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KubernetesListBuilder;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.ServiceBuilder;
import io.fabric8.kubernetes.api.model.ServicePort;
import io.fabric8.kubernetes.api.model.ServiceSpec;
import io.fabric8.kubernetes.api.model.extensions.IngressBuilder;
import io.fabric8.kubernetes.api.model.networking.v1.Ingress;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jkube.enricher.generic.ExtensionsV1beta1IngressConverter;
import org.eclipse.jkube.enricher.generic.NetworkingV1IngressGenerator;
import org.eclipse.jkube.kit.common.Configs;
import org.eclipse.jkube.kit.common.KitLogger;
import org.eclipse.jkube.kit.common.util.FileUtil;
import org.eclipse.jkube.kit.config.resource.IngressConfig;
import org.eclipse.jkube.kit.config.resource.IngressRuleConfig;
import org.eclipse.jkube.kit.config.resource.IngressTlsConfig;
import org.eclipse.jkube.kit.config.resource.JKubeAnnotations;
import org.eclipse.jkube.kit.config.resource.PlatformMode;
import org.eclipse.jkube.kit.config.resource.ResourceConfig;
import org.eclipse.jkube.kit.enricher.api.BaseEnricher;
import org.eclipse.jkube.kit.enricher.api.EnricherContext;
import org.eclipse.jkube.kit.enricher.api.JKubeEnricherContext;

public class IngressEnricher
extends BaseEnricher {
    public static final String EXPOSE_LABEL = "expose";

    public IngressEnricher(JKubeEnricherContext buildContext) {
        super((EnricherContext)buildContext, "jkube-ingress");
    }

    public void create(PlatformMode platformMode, final KubernetesListBuilder listBuilder) {
        final ResourceConfig resourceConfig = this.getConfiguration().getResource();
        Boolean shouldCreateIngress = this.getValueFromConfig("jkube.createExternalUrls", false);
        if (shouldCreateIngress.equals(Boolean.FALSE)) {
            return;
        }
        if (platformMode == PlatformMode.kubernetes) {
            listBuilder.accept(new Visitor[]{new TypedVisitor<ServiceBuilder>(){

                public void visit(ServiceBuilder serviceBuilder) {
                    HasMetadata generatedIngress = IngressEnricher.this.generateIngressWithConfiguredApiVersion(serviceBuilder, listBuilder, resourceConfig);
                    if (generatedIngress != null) {
                        listBuilder.addToItems(new HasMetadata[]{generatedIngress});
                    }
                }
            }});
        }
    }

    private HasMetadata generateIngressWithConfiguredApiVersion(ServiceBuilder serviceBuilder, KubernetesListBuilder listBuilder, ResourceConfig resourceConfig) {
        Ingress ingress;
        Ingress generatedIngress = ingress = NetworkingV1IngressGenerator.generate(listBuilder, serviceBuilder, this.getRouteDomain(resourceConfig), this.getConfig(Config.HOST), IngressEnricher.getIngressRuleXMLConfig(resourceConfig), IngressEnricher.getIngressTlsXMLConfig(resourceConfig), this.log);
        String targetIngressApiVersion = this.getConfig(Config.TARGET_API_VERSION);
        if (targetIngressApiVersion.equalsIgnoreCase("extensions/v1beta1")) {
            generatedIngress = ExtensionsV1beta1IngressConverter.convert(ingress);
        }
        return generatedIngress;
    }

    static ObjectMeta getIngressMetadata(ObjectMeta serviceMetadata) {
        ObjectMetaBuilder ingressMetadataBuilder = new ObjectMetaBuilder(serviceMetadata);
        ingressMetadataBuilder.removeFromLabels(Collections.singletonMap(EXPOSE_LABEL, "true"));
        ingressMetadataBuilder.removeFromLabels(Collections.singletonMap(JKubeAnnotations.SERVICE_EXPOSE_URL.value(), "true"));
        return ingressMetadataBuilder.build();
    }

    static Integer getServicePort(ServiceBuilder serviceBuilder) {
        List ports;
        ServiceSpec spec = serviceBuilder.buildSpec();
        if (spec != null && (ports = spec.getPorts()) != null && !ports.isEmpty()) {
            for (ServicePort port : ports) {
                if (!port.getName().equals("http") && !port.getProtocol().equals("http")) continue;
                return port.getPort();
            }
            ServicePort servicePort = (ServicePort)ports.get(0);
            if (servicePort != null) {
                return servicePort.getPort();
            }
        }
        return 0;
    }

    static boolean hasIngress(KubernetesListBuilder listBuilder, final String name) {
        final AtomicBoolean answer = new AtomicBoolean(false);
        listBuilder.accept(new Visitor[]{new TypedVisitor<IngressBuilder>(){

            public void visit(IngressBuilder builder) {
                ObjectMeta metadata = builder.buildMetadata();
                if (metadata != null && name.equals(metadata.getName())) {
                    answer.set(true);
                }
            }
        }});
        listBuilder.accept(new Visitor[]{new TypedVisitor<io.fabric8.kubernetes.api.model.networking.v1.IngressBuilder>(){

            public void visit(io.fabric8.kubernetes.api.model.networking.v1.IngressBuilder builder) {
                ObjectMeta metadata = builder.buildMetadata();
                if (metadata != null && name.equals(metadata.getName())) {
                    answer.set(true);
                }
            }
        }});
        return answer.get();
    }

    static boolean shouldCreateExternalURLForService(ServiceBuilder service, KitLogger log) {
        String serviceName = service.buildMetadata().getName();
        ServiceSpec spec = service.buildSpec();
        if (spec != null && !IngressEnricher.isKubernetesSystemService(serviceName)) {
            List ports = spec.getPorts();
            log.debug("Service " + serviceName + " has ports: " + ports, new Object[0]);
            if (ports.size() == 1) {
                return true;
            }
            log.info("Not generating Ingress for service " + serviceName + " as only single port services are supported. Has ports: " + ports, new Object[0]);
        }
        return false;
    }

    static String resolveIngressHost(String serviceName, String routeDomainPostfix, String host) {
        if (host != null) {
            return host;
        }
        return serviceName + "." + FileUtil.stripPrefix((String)routeDomainPostfix, (String)".");
    }

    private static boolean isKubernetesSystemService(String serviceName) {
        return "kubernetes".equals(serviceName) || "kubernetes-ro".equals(serviceName);
    }

    protected String getRouteDomain(ResourceConfig resourceConfig) {
        if (resourceConfig != null && resourceConfig.getRouteDomain() != null) {
            return resourceConfig.getRouteDomain();
        }
        String routeDomainFromProperties = this.getValueFromConfig("jkube.domain", "");
        if (StringUtils.isNotEmpty((CharSequence)routeDomainFromProperties)) {
            return routeDomainFromProperties;
        }
        return null;
    }

    static List<IngressRuleConfig> getIngressRuleXMLConfig(ResourceConfig resourceConfig) {
        return Optional.ofNullable(resourceConfig).map(ResourceConfig::getIngress).map(IngressConfig::getIngressRules).orElse(Collections.emptyList());
    }

    static List<IngressTlsConfig> getIngressTlsXMLConfig(ResourceConfig resourceConfig) {
        return Optional.ofNullable(resourceConfig).map(ResourceConfig::getIngress).map(IngressConfig::getIngressTlsConfigs).orElse(Collections.emptyList());
    }

    public static enum Config implements Configs.Config
    {
        HOST("host", null),
        TARGET_API_VERSION("targetApiVersion", "extensions/v1beta1");

        protected String key;
        protected String defaultValue;

        private Config(String key, String defaultValue) {
            this.key = key;
            this.defaultValue = defaultValue;
        }

        public String getKey() {
            return this.key;
        }

        public String getDefaultValue() {
            return this.defaultValue;
        }
    }
}

