/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.enricher.generic;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import io.fabric8.kubernetes.api.builder.TypedVisitor;
import io.fabric8.kubernetes.api.builder.Visitor;
import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.ContainerBuilder;
import io.fabric8.kubernetes.api.model.KubernetesListBuilder;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimBuilder;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimFluent;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimVolumeSource;
import io.fabric8.kubernetes.api.model.PodSpec;
import io.fabric8.kubernetes.api.model.PodTemplateSpecBuilder;
import io.fabric8.kubernetes.api.model.Quantity;
import io.fabric8.kubernetes.api.model.ResourceRequirementsBuilder;
import io.fabric8.kubernetes.api.model.Volume;
import io.fabric8.kubernetes.api.model.VolumeMount;
import io.fabric8.kubernetes.api.model.VolumeMountBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jkube.kit.common.Configs;
import org.eclipse.jkube.kit.config.resource.PlatformMode;
import org.eclipse.jkube.kit.enricher.api.BaseEnricher;
import org.eclipse.jkube.kit.enricher.api.EnricherContext;
import org.eclipse.jkube.kit.enricher.api.JKubeEnricherContext;
import org.eclipse.jkube.kit.enricher.api.util.InitContainerHandler;

public class VolumePermissionEnricher
extends BaseEnricher {
    public static final String ENRICHER_NAME = "jkube-volume-permission";
    static final String VOLUME_STORAGE_CLASS_ANNOTATION = "volume.beta.kubernetes.io/storage-class";
    private final InitContainerHandler initContainerHandler;

    public VolumePermissionEnricher(JKubeEnricherContext buildContext) {
        super((EnricherContext)buildContext, ENRICHER_NAME);
        this.initContainerHandler = new InitContainerHandler(buildContext.getLog());
    }

    public void enrich(PlatformMode platformMode, KubernetesListBuilder builder) {
        builder.accept(new Visitor[]{new TypedVisitor<PodTemplateSpecBuilder>(){

            public void visit(PodTemplateSpecBuilder builder) {
                PodSpec podSpec = builder.buildSpec();
                if (podSpec == null) {
                    return;
                }
                if (!this.checkForPvc(podSpec)) {
                    return;
                }
                List containers = podSpec.getContainers();
                if (containers == null || containers.isEmpty()) {
                    return;
                }
                VolumePermissionEnricher.this.log.verbose("Adding init container for changing persistent volumes access mode to %s", new Object[]{VolumePermissionEnricher.this.getConfig(Config.PERMISSION)});
                if (!VolumePermissionEnricher.this.initContainerHandler.hasInitContainer(builder, VolumePermissionEnricher.ENRICHER_NAME)) {
                    VolumePermissionEnricher.this.initContainerHandler.appendInitContainer(builder, this.createPvInitContainer(podSpec));
                }
            }

            private boolean checkForPvc(PodSpec podSpec) {
                List volumes = podSpec.getVolumes();
                if (volumes != null) {
                    for (Volume volume : volumes) {
                        PersistentVolumeClaimVolumeSource persistentVolumeClaim = volume.getPersistentVolumeClaim();
                        if (persistentVolumeClaim == null) continue;
                        return true;
                    }
                }
                return false;
            }

            private Container createPvInitContainer(PodSpec podSpec) {
                Map<String, String> mountPoints = this.extractMountPoints(podSpec);
                return ((ContainerBuilder)((ContainerBuilder)((ContainerBuilder)((ContainerBuilder)((ContainerBuilder)((ContainerBuilder)new ContainerBuilder().withName(VolumePermissionEnricher.ENRICHER_NAME)).withImage(VolumePermissionEnricher.this.getConfig(Config.IMAGE_NAME))).withImagePullPolicy("IfNotPresent")).withCommand(this.createChmodCommandArray(mountPoints))).withVolumeMounts(this.createMounts(mountPoints))).withResources(((ResourceRequirementsBuilder)((ResourceRequirementsBuilder)new ResourceRequirementsBuilder().withLimits(this.createResourcesMap(Config.CPU_LIMIT, Config.MEMORY_LIMIT))).withRequests(this.createResourcesMap(Config.CPU_REQUEST, Config.MEMORY_REQUEST))).build())).build();
            }

            private List<String> createChmodCommandArray(Map<String, String> mountPoints) {
                ArrayList<String> ret = new ArrayList<String>();
                ret.add("chmod");
                ret.add(VolumePermissionEnricher.this.getConfig(Config.PERMISSION));
                LinkedHashSet<String> uniqueNames = new LinkedHashSet<String>(mountPoints.values());
                ret.addAll(uniqueNames);
                return ret;
            }

            private List<VolumeMount> createMounts(Map<String, String> mountPoints) {
                ArrayList<VolumeMount> ret = new ArrayList<VolumeMount>();
                for (Map.Entry<String, String> entry : mountPoints.entrySet()) {
                    JsonObject mount = new JsonObject();
                    mount.add("name", (JsonElement)new JsonPrimitive(entry.getKey()));
                    mount.add("mountPath", (JsonElement)new JsonPrimitive(entry.getValue()));
                    VolumeMount volumeMount = ((VolumeMountBuilder)((VolumeMountBuilder)new VolumeMountBuilder().withName(entry.getKey())).withMountPath(entry.getValue())).build();
                    ret.add(volumeMount);
                }
                return ret;
            }

            private Map<String, String> extractMountPoints(PodSpec podSpec) {
                LinkedHashMap<String, String> nameToMount = new LinkedHashMap<String, String>();
                List volumes = podSpec.getVolumes();
                if (volumes != null) {
                    for (Volume volume : volumes) {
                        PersistentVolumeClaimVolumeSource persistentVolumeClaim = volume.getPersistentVolumeClaim();
                        if (persistentVolumeClaim == null) continue;
                        String name = volume.getName();
                        String mountPath = this.getMountPath(podSpec.getContainers(), name);
                        nameToMount.put(name, mountPath);
                    }
                }
                return nameToMount;
            }

            private String getMountPath(List<Container> containers, String name) {
                for (Container container : containers) {
                    List volumeMounts = container.getVolumeMounts();
                    if (volumeMounts == null) continue;
                    for (VolumeMount volumeMount : volumeMounts) {
                        if (!name.equals(volumeMount.getName())) continue;
                        return volumeMount.getMountPath();
                    }
                }
                throw new IllegalArgumentException("No matching volume mount found for volume " + name);
            }

            private Map<String, Quantity> createResourcesMap(Configs.Config cpu, Configs.Config memory) {
                String memoryValue;
                HashMap<String, Quantity> resourcesMap = new HashMap<String, Quantity>();
                String cpuValue = VolumePermissionEnricher.this.getConfig(cpu);
                if (StringUtils.isNotBlank((CharSequence)cpuValue)) {
                    resourcesMap.put("cpu", new Quantity(cpuValue));
                }
                if (StringUtils.isNotBlank((CharSequence)(memoryValue = VolumePermissionEnricher.this.getConfig(memory)))) {
                    resourcesMap.put("memory", new Quantity(memoryValue));
                }
                return resourcesMap;
            }
        }});
        builder.accept(new Visitor[]{new TypedVisitor<PersistentVolumeClaimBuilder>(){

            public void visit(PersistentVolumeClaimBuilder pvcBuilder) {
                String storageClass;
                if (pvcBuilder.buildMetadata() == null) {
                    pvcBuilder.withNewMetadata().endMetadata();
                }
                if (StringUtils.isNotBlank((CharSequence)(storageClass = VolumePermissionEnricher.this.getConfig(Config.DEFAULT_STORAGE_CLASS)))) {
                    if (Boolean.parseBoolean(VolumePermissionEnricher.this.getConfig(Config.USE_ANNOTATION))) {
                        ((PersistentVolumeClaimFluent.MetadataNested)pvcBuilder.editMetadata().addToAnnotations(VolumePermissionEnricher.VOLUME_STORAGE_CLASS_ANNOTATION, storageClass)).endMetadata();
                    } else {
                        ((PersistentVolumeClaimFluent.SpecNested)pvcBuilder.editSpec().withStorageClassName(storageClass)).endSpec();
                    }
                }
            }
        }});
    }

    static enum Config implements Configs.Config
    {
        IMAGE_NAME("imageName", "busybox"),
        PERMISSION("permission", "777"),
        DEFAULT_STORAGE_CLASS("defaultStorageClass", null),
        USE_ANNOTATION("useStorageClassAnnotation", "false"),
        CPU_LIMIT("cpuLimit", null),
        CPU_REQUEST("cpuRequest", null),
        MEMORY_LIMIT("memoryLimit", null),
        MEMORY_REQUEST("memoryRequest", null);

        protected String key;
        protected String defaultValue;

        private Config(String key, String defaultValue) {
            this.key = key;
            this.defaultValue = defaultValue;
        }

        public String getKey() {
            return this.key;
        }

        public String getDefaultValue() {
            return this.defaultValue;
        }
    }
}

