/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.enricher.specific;

import com.google.common.base.Objects;
import io.fabric8.kubernetes.api.model.ContainerBuilder;
import io.fabric8.kubernetes.api.model.ExecAction;
import io.fabric8.kubernetes.api.model.Probe;
import io.fabric8.kubernetes.api.model.ProbeBuilder;
import org.eclipse.jkube.kit.config.image.ImageConfiguration;
import org.eclipse.jkube.kit.config.image.build.HealthCheckConfiguration;
import org.eclipse.jkube.kit.config.image.build.HealthCheckMode;
import org.eclipse.jkube.kit.config.resource.GroupArtifactVersion;
import org.eclipse.jkube.kit.enricher.api.EnricherContext;
import org.eclipse.jkube.kit.enricher.api.JKubeEnricherContext;
import org.eclipse.jkube.kit.enricher.api.util.GoTimeUtil;
import org.eclipse.jkube.kit.enricher.api.util.KubernetesResourceUtil;
import org.eclipse.jkube.kit.enricher.specific.AbstractHealthCheckEnricher;

public class DockerHealthCheckEnricher
extends AbstractHealthCheckEnricher {
    public DockerHealthCheckEnricher(JKubeEnricherContext buildContext) {
        super((EnricherContext)buildContext, "jkube-healthcheck-docker");
    }

    @Override
    protected Probe getReadinessProbe(ContainerBuilder container) {
        return this.getProbe(container);
    }

    @Override
    protected Probe getLivenessProbe(ContainerBuilder container) {
        return this.getProbe(container);
    }

    private Probe getProbe(ContainerBuilder container) {
        ImageConfiguration image = this.getImageWithContainerName(container.getName());
        if (image != null) {
            return this.getProbe(image);
        }
        return null;
    }

    private Probe getProbe(ImageConfiguration image) {
        if (this.hasHealthCheck(image)) {
            HealthCheckConfiguration health = image.getBuildConfiguration().getHealthCheck();
            return ((ProbeBuilder)((ProbeBuilder)((ProbeBuilder)((ProbeBuilder)new ProbeBuilder().withExec(new ExecAction(health.getCmd().asStrings()))).withTimeoutSeconds((Integer)GoTimeUtil.durationSeconds((String)health.getTimeout()).orElse(null))).withPeriodSeconds((Integer)GoTimeUtil.durationSeconds((String)health.getInterval()).orElse(null))).withFailureThreshold(health.getRetries())).build();
        }
        return null;
    }

    private boolean hasHealthCheck(ImageConfiguration image) {
        return image.getBuildConfiguration() != null && image.getBuildConfiguration().getHealthCheck() != null && image.getBuildConfiguration().getHealthCheck().getCmd() != null && image.getBuildConfiguration().getHealthCheck().getMode() == HealthCheckMode.cmd;
    }

    private ImageConfiguration getImageWithContainerName(String containerName) {
        if (containerName == null) {
            return null;
        }
        for (ImageConfiguration image : this.getImages()) {
            String imageContainerName = KubernetesResourceUtil.extractContainerName((GroupArtifactVersion)this.getContext().getGav(), (ImageConfiguration)image);
            if (!Objects.equal((Object)containerName, (Object)imageContainerName)) continue;
            return image;
        }
        return null;
    }
}

