/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.enricher.specific;

import io.fabric8.kubernetes.api.builder.TypedVisitor;
import io.fabric8.kubernetes.api.builder.Visitor;
import io.fabric8.kubernetes.api.model.KubernetesListBuilder;
import io.fabric8.kubernetes.api.model.ServiceBuilder;
import io.fabric8.kubernetes.api.model.ServiceFluent;
import io.fabric8.kubernetes.api.model.ServicePort;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.eclipse.jkube.kit.common.Configs;
import org.eclipse.jkube.kit.config.resource.PlatformMode;
import org.eclipse.jkube.kit.enricher.api.BaseEnricher;
import org.eclipse.jkube.kit.enricher.api.EnricherContext;
import org.eclipse.jkube.kit.enricher.api.JKubeEnricherContext;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class ServiceDiscoveryEnricher
extends BaseEnricher {
    private static final String ENRICHER_NAME = "jkube-service-discovery";
    private static final String PREFIX = "discovery.3scale.net";
    private static final String ANNOTATION_DISCOVERY_VERSION = "discovery-version";
    private static final String ANNOTATION_SCHEME = Config.SCHEME.key;
    private static final String ANNOTATION_PATH = Config.PATH.key;
    private static final String ANNOTATION_PORT = Config.PORT.key;
    private static final String ANNOTATION_DESCRIPTION_PATH = "description-path";
    private final File springConfigDir;
    private String path;
    private String port;
    private String scheme;
    private String descriptionPath;
    private String discoverable;

    public ServiceDiscoveryEnricher(JKubeEnricherContext buildContext) {
        super((EnricherContext)buildContext, ENRICHER_NAME);
        File baseDir = this.getContext().getProjectDirectory();
        this.springConfigDir = new File(this.getConfig(Config.SPRING_DIR, baseDir + "/src/main/resources/spring"));
        this.discoverable = this.getConfig(Config.DISCOVERABLE, null);
    }

    public void create(PlatformMode platformMode, KubernetesListBuilder listBuilder) {
        listBuilder.accept(new Visitor[]{new TypedVisitor<ServiceBuilder>(){

            public void visit(ServiceBuilder serviceBuilder) {
                ServiceDiscoveryEnricher.this.addAnnotations(serviceBuilder);
            }
        }});
    }

    protected void addAnnotations(ServiceBuilder serviceBuilder) {
        if (serviceBuilder.buildSpec() != null) {
            List ports = serviceBuilder.buildSpec().getPorts();
            if (!ports.isEmpty()) {
                ServicePort firstServicePort = (ServicePort)ports.iterator().next();
                this.port = firstServicePort.getPort().toString();
                this.log.info("Using first mentioned service port '%s' ", new Object[]{this.port});
            } else {
                this.log.warn("No service port was found", new Object[0]);
            }
        }
        this.tryCamelDSLProject();
        if (this.discoverable != null) {
            String labelName = PREFIX;
            String labelValue = this.getConfig(Config.DISCOVERABLE, this.discoverable);
            ((ServiceBuilder)((ServiceFluent.MetadataNested)serviceBuilder.editOrNewMetadata().addToLabels(labelName, labelValue)).and()).buildMetadata();
            this.log.info("Add %s label: \"%s\" : \"%s\"", new Object[]{PREFIX, labelName, labelValue});
            HashMap<String, String> annotations = new HashMap<String, String>();
            annotations.put("discovery.3scale.net/discovery-version", this.getConfig(Config.DISCOVERY_VERSION));
            annotations.put("discovery.3scale.net/" + ANNOTATION_SCHEME, this.getConfig(Config.SCHEME, this.scheme));
            String resolvedPath = this.getConfig(Config.PATH, this.path);
            if (resolvedPath != null) {
                if (!resolvedPath.startsWith("/")) {
                    resolvedPath = "/" + resolvedPath;
                }
                annotations.put("discovery.3scale.net/" + ANNOTATION_PATH, resolvedPath);
            }
            annotations.put("discovery.3scale.net/" + ANNOTATION_PORT, this.getConfig(Config.PORT, this.port));
            String resolvedDescriptionPath = this.getConfig(Config.DESCRIPTION_PATH, this.descriptionPath);
            if (resolvedDescriptionPath != null) {
                if (!resolvedDescriptionPath.toLowerCase().startsWith("http") && !resolvedDescriptionPath.startsWith("/")) {
                    resolvedDescriptionPath = "/" + resolvedDescriptionPath;
                }
                annotations.put("discovery.3scale.net/description-path", resolvedDescriptionPath);
            }
            annotations.forEach((key, value) -> this.log.info("Add %s annotation: \"%s\" : \"%s\"", new Object[]{PREFIX, key, value}));
            ((ServiceBuilder)((ServiceFluent.MetadataNested)serviceBuilder.editMetadata().addToAnnotations(annotations)).and()).buildMetadata();
        }
    }

    public void tryCamelDSLProject() {
        File camelContextXmlFile = new File(this.springConfigDir.getAbsoluteFile() + "/camel-context.xml");
        if (camelContextXmlFile.exists()) {
            try {
                DocumentBuilderFactory df = DocumentBuilderFactory.newInstance();
                df.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
                df.setAttribute("http://javax.xml.XMLConstants/property/accessExternalSchema", "");
                Document doc = df.newDocumentBuilder().parse(camelContextXmlFile);
                XPath xPath = XPathFactory.newInstance().newXPath();
                Node nl = (Node)xPath.evaluate("/beans/camelContext/restConfiguration", doc, XPathConstants.NODE);
                if (nl != null) {
                    this.discoverable = "true";
                    if (nl.getAttributes().getNamedItem("scheme") != null) {
                        this.scheme = nl.getAttributes().getNamedItem("scheme").getNodeValue();
                        this.log.verbose("Obtained scheme '%s' from camel-context.xml ", new Object[]{this.scheme});
                    }
                    if (nl.getAttributes().getNamedItem("contextPath") != null) {
                        this.path = nl.getAttributes().getNamedItem("contextPath").getNodeValue();
                        this.log.verbose("Obtained path '%s' from camel-context.xml ", new Object[]{this.path});
                    }
                    if (nl.getAttributes().getNamedItem("apiContextPath") != null) {
                        this.descriptionPath = nl.getAttributes().getNamedItem("apiContextPath").getNodeValue();
                        this.log.verbose("Obtained descriptionPath '%s' from camel-context.xml ", new Object[]{this.descriptionPath});
                    }
                }
            }
            catch (Exception ex) {
                this.log.warn("Failed to load camel context file: %s", new Object[]{ex});
            }
        }
    }

    private static enum Config implements Configs.Config
    {
        DESCRIPTION_PATH("descriptionPath", null),
        DISCOVERABLE("discoverable", null),
        DISCOVERY_VERSION("discoveryVersion", "v1"),
        PATH("path", null),
        PORT("port", "80"),
        SCHEME("scheme", "http"),
        SPRING_DIR("springDir", null);

        protected String key;
        protected String defaultValue;

        private Config(String key, String defaultValue) {
            this.key = key;
            this.defaultValue = defaultValue;
        }

        public String getKey() {
            return this.key;
        }

        public String getDefaultValue() {
            return this.defaultValue;
        }
    }
}

