/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.enricher.specific;

import io.fabric8.kubernetes.api.model.Probe;
import io.fabric8.kubernetes.api.model.ProbeBuilder;
import io.fabric8.kubernetes.api.model.ProbeFluent;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.eclipse.jkube.kit.common.Configs;
import org.eclipse.jkube.kit.enricher.api.EnricherContext;
import org.eclipse.jkube.kit.enricher.api.JKubeEnricherContext;
import org.eclipse.jkube.kit.enricher.specific.AbstractHealthCheckEnricher;

public class KarafHealthCheckEnricher
extends AbstractHealthCheckEnricher {
    private static final int DEFAULT_HEALTH_CHECK_PORT = 8181;

    public KarafHealthCheckEnricher(JKubeEnricherContext buildContext) {
        super((EnricherContext)buildContext, "jkube-healthcheck-karaf");
    }

    @Override
    protected Probe getReadinessProbe() {
        return this.discoverKarafProbe("/readiness-check", 10);
    }

    @Override
    protected Probe getLivenessProbe() {
        return this.discoverKarafProbe("/health-check", 180);
    }

    private Probe discoverKarafProbe(String path, int initialDelay) {
        Optional configurationValues = this.getContext().getConfiguration().getPluginConfiguration("maven", "karaf-maven-plugin");
        if (!configurationValues.isPresent()) {
            return null;
        }
        Optional<Object> lookup = configurationValues.map(m -> m.get("startupFeatures"));
        if (!lookup.isPresent()) {
            return null;
        }
        Object startupFeatures = lookup.get();
        if (!(startupFeatures instanceof Map)) {
            throw new IllegalArgumentException(String.format("For element %s was expected a complex object but a simple object was found of type %s and value %s", "startupFeatures", startupFeatures.getClass(), startupFeatures));
        }
        Map startUpFeaturesObject = (Map)startupFeatures;
        Object feature = startUpFeaturesObject.get("feature");
        if (feature != null) {
            if (feature instanceof List) {
                List features = (List)feature;
                for (String featureValue : features) {
                    if (!"jkube-karaf-checks".equals(featureValue)) continue;
                    return ((ProbeBuilder)((ProbeBuilder)((ProbeBuilder)((ProbeBuilder)((ProbeFluent.HttpGetNested)((ProbeFluent.HttpGetNested)new ProbeBuilder().withNewHttpGet().withNewPort((Object)8181)).withPath(path)).endHttpGet()).withSuccessThreshold(Integer.valueOf(this.getSuccessThreshold()))).withFailureThreshold(Integer.valueOf(this.getFailureThreshold()))).withInitialDelaySeconds(Integer.valueOf(initialDelay))).build();
                }
            } else {
                String featureValue = (String)feature;
                if ("jkube-karaf-checks".equals(featureValue)) {
                    return ((ProbeBuilder)((ProbeBuilder)((ProbeBuilder)((ProbeBuilder)((ProbeFluent.HttpGetNested)((ProbeFluent.HttpGetNested)new ProbeBuilder().withNewHttpGet().withNewPort((Object)8181)).withPath(path)).endHttpGet()).withSuccessThreshold(Integer.valueOf(this.getSuccessThreshold()))).withFailureThreshold(Integer.valueOf(this.getFailureThreshold()))).withInitialDelaySeconds(Integer.valueOf(initialDelay))).build();
                }
            }
        }
        return null;
    }

    protected int getFailureThreshold() {
        return Configs.asInteger((String)this.getConfig(Config.FAILURE_THRESHOLD));
    }

    protected int getSuccessThreshold() {
        return Configs.asInteger((String)this.getConfig(Config.SUCCESS_THRESHOLD));
    }

    private static enum Config implements Configs.Config
    {
        FAILURE_THRESHOLD("failureThreshold", "3"),
        SUCCESS_THRESHOLD("successThreshold", "1");

        protected String key;
        protected String defaultValue;

        @Generated
        private Config(String key, String defaultValue) {
            this.key = key;
            this.defaultValue = defaultValue;
        }

        @Generated
        public String getKey() {
            return this.key;
        }

        @Generated
        public String getDefaultValue() {
            return this.defaultValue;
        }
    }
}

