/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.enricher.specific;

import io.fabric8.kubernetes.api.builder.TypedVisitor;
import io.fabric8.kubernetes.api.builder.Visitor;
import io.fabric8.kubernetes.api.model.KubernetesListBuilder;
import io.fabric8.kubernetes.api.model.ServiceBuilder;
import io.fabric8.kubernetes.api.model.ServiceFluent;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jkube.kit.common.Configs;
import org.eclipse.jkube.kit.config.image.ImageConfiguration;
import org.eclipse.jkube.kit.config.image.build.BuildConfiguration;
import org.eclipse.jkube.kit.config.resource.PlatformMode;
import org.eclipse.jkube.kit.enricher.api.BaseEnricher;
import org.eclipse.jkube.kit.enricher.api.EnricherContext;
import org.eclipse.jkube.kit.enricher.api.JKubeEnricherContext;

public class PrometheusEnricher
extends BaseEnricher {
    private static final String ANNOTATION_PROMETHEUS_PORT = "prometheus.io/port";
    private static final String ANNOTATION_PROMETHEUS_SCRAPE = "prometheus.io/scrape";
    private static final String ANNOTATION_PROMETHEUS_PATH = "prometheus.io/path";
    private static final String ENRICHER_NAME = "jkube-prometheus";
    private static final String PROMETHEUS_PORT = "9779";

    public PrometheusEnricher(JKubeEnricherContext buildContext) {
        super((EnricherContext)buildContext, ENRICHER_NAME);
    }

    public void create(PlatformMode platformMode, KubernetesListBuilder builder) {
        builder.accept(new Visitor[]{new TypedVisitor<ServiceBuilder>(){

            public void visit(ServiceBuilder serviceBuilder) {
                String prometheusPort = PrometheusEnricher.this.findPrometheusPort();
                if (StringUtils.isNotBlank((CharSequence)prometheusPort)) {
                    HashMap<String, String> annotations = new HashMap<String, String>();
                    annotations.put(PrometheusEnricher.ANNOTATION_PROMETHEUS_PORT, prometheusPort);
                    annotations.put(PrometheusEnricher.ANNOTATION_PROMETHEUS_SCRAPE, "true");
                    annotations.put(PrometheusEnricher.ANNOTATION_PROMETHEUS_PATH, PrometheusEnricher.this.getConfig(Config.PROMETHEUS_PATH));
                    PrometheusEnricher.this.log.verbose("Adding prometheus.io annotations: %s", new Object[]{annotations.entrySet().stream().map(Object::toString).collect(Collectors.joining(", "))});
                    ((ServiceFluent.MetadataNested)serviceBuilder.editMetadata().addToAnnotations(annotations)).endMetadata();
                }
            }
        }});
    }

    private String findPrometheusPort() {
        String prometheusPort = this.getConfig(Config.PROMETHEUS_PORT);
        if (StringUtils.isBlank((CharSequence)prometheusPort)) {
            for (ImageConfiguration configuration : this.getImages()) {
                List ports;
                BuildConfiguration buildImageConfiguration = configuration.getBuildConfiguration();
                if (buildImageConfiguration == null || (ports = buildImageConfiguration.getPorts()) == null || !ports.contains(PROMETHEUS_PORT)) continue;
                prometheusPort = PROMETHEUS_PORT;
                break;
            }
        }
        return prometheusPort;
    }

    private static enum Config implements Configs.Config
    {
        PROMETHEUS_PORT("prometheusPort", null),
        PROMETHEUS_PATH("prometheusPath", "/metrics");

        protected String key;
        protected String defaultValue;

        @Generated
        private Config(String key, String defaultValue) {
            this.key = key;
            this.defaultValue = defaultValue;
        }

        @Generated
        public String getKey() {
            return this.key;
        }

        @Generated
        public String getDefaultValue() {
            return this.defaultValue;
        }
    }
}

