/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.generator.api;

import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Properties;

public class DefaultImageLookup {
    public static final String DEFAULT_IMAGES_PROPERTIES = "META-INF/jkube/default-images.properties";
    private final Properties defaultImageProps = new Properties();

    public DefaultImageLookup(Class realm) {
        try {
            Enumeration<URL> resourceUrls = realm.getClassLoader().getResources(DEFAULT_IMAGES_PROPERTIES);
            while (resourceUrls.hasMoreElements()) {
                URL resourceUrl = resourceUrls.nextElement();
                this.defaultImageProps.load(resourceUrl.openStream());
            }
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Cannot load default images properties META-INF/jkube/default-images.properties: " + e, e);
        }
    }

    public String getImageName(String key) {
        String val = this.defaultImageProps.getProperty(key);
        if (val == null) {
            throw new IllegalArgumentException("No such key " + key + " contained in " + DEFAULT_IMAGES_PROPERTIES + " for fetching the default image names");
        }
        return val;
    }
}

