/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.generator.api.support;

import java.io.File;
import java.io.IOException;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jkube.generator.api.FromSelector;
import org.eclipse.jkube.generator.api.Generator;
import org.eclipse.jkube.generator.api.GeneratorConfig;
import org.eclipse.jkube.generator.api.GeneratorContext;
import org.eclipse.jkube.kit.build.api.helper.DockerFileUtil;
import org.eclipse.jkube.kit.common.Configs;
import org.eclipse.jkube.kit.common.JavaProject;
import org.eclipse.jkube.kit.common.PrefixedLogger;
import org.eclipse.jkube.kit.common.util.GitUtil;
import org.eclipse.jkube.kit.config.image.ImageConfiguration;
import org.eclipse.jkube.kit.config.image.ImageName;
import org.eclipse.jkube.kit.config.image.build.BuildConfiguration;
import org.eclipse.jkube.kit.config.image.build.JKubeBuildStrategy;
import org.eclipse.jkube.kit.config.image.build.util.BuildLabelAnnotations;
import org.eclipse.jkube.kit.config.resource.RuntimeMode;

public abstract class BaseGenerator
implements Generator {
    private static final String LABEL_SCHEMA_VERSION = "1.0";
    private static final String GIT_REMOTE = "origin";
    private final GeneratorContext context;
    private final String name;
    private final GeneratorConfig config;
    protected final PrefixedLogger log;
    private final FromSelector fromSelector;

    public BaseGenerator(GeneratorContext context, String name) {
        this(context, name, null);
    }

    public BaseGenerator(GeneratorContext context, String name, FromSelector fromSelector) {
        this.context = context;
        this.name = name;
        this.fromSelector = fromSelector;
        this.config = new GeneratorConfig(context.getProject().getProperties(), this.getName(), context.getConfig());
        this.log = new PrefixedLogger(name, context.getLogger());
    }

    protected JavaProject getProject() {
        return this.context.getProject();
    }

    public GeneratorContext getContext() {
        return this.context;
    }

    public GeneratorConfig getGeneratorConfig() {
        return this.config;
    }

    protected String getConfig(Configs.Config key) {
        return this.config.get(key);
    }

    protected String getConfig(Configs.Config key, String defaultVal) {
        return this.config.get(key, defaultVal);
    }

    protected String getConfigWithFallback(Config key, String fallbackPropertyKey, String defaultVal) {
        return this.config.getWithFallback(key, fallbackPropertyKey, defaultVal);
    }

    protected String getFromAsConfigured() {
        return this.getConfigWithFallback(Config.FROM, "jkube.generator.from", null);
    }

    protected void addFrom(BuildConfiguration.BuildConfigurationBuilder builder) {
        String fromMode = this.getConfigWithFallback(Config.FROM_MODE, "jkube.generator.fromMode", "docker");
        String from = this.getFromAsConfigured();
        if ("docker".equalsIgnoreCase(fromMode)) {
            String fromImage = from;
            if (fromImage == null) {
                fromImage = this.fromSelector != null ? this.fromSelector.getFrom() : null;
            }
            builder.from(fromImage);
            this.log.info("Using Docker image %s as base / builder", new Object[]{fromImage});
        } else if ("istag".equalsIgnoreCase(fromMode)) {
            HashMap<String, String> fromExt = new HashMap<String, String>();
            if (from != null) {
                ImageName iName = new ImageName(from);
                String tag = iName.getTag();
                if (StringUtils.isBlank((CharSequence)tag)) {
                    tag = "latest";
                }
                fromExt.put(JKubeBuildStrategy.SourceStrategy.name.key(), iName.getSimpleName() + ":" + tag);
                if (iName.inferUser() != null) {
                    fromExt.put(JKubeBuildStrategy.SourceStrategy.namespace.key(), iName.inferUser());
                }
                fromExt.put(JKubeBuildStrategy.SourceStrategy.kind.key(), "ImageStreamTag");
            } else {
                Map<String, String> map = fromExt = this.fromSelector != null ? this.fromSelector.getImageStreamTagFromExt() : null;
            }
            if (fromExt != null) {
                String namespace = (String)fromExt.get(JKubeBuildStrategy.SourceStrategy.namespace.key());
                if (namespace != null) {
                    this.log.info("Using ImageStreamTag '%s' from namespace '%s' as builder image", new Object[]{fromExt.get(JKubeBuildStrategy.SourceStrategy.name.key()), namespace});
                } else {
                    this.log.info("Using ImageStreamTag '%s' as builder image", new Object[]{fromExt.get(JKubeBuildStrategy.SourceStrategy.name.key())});
                }
                builder.fromExt(fromExt);
            }
        } else {
            throw new IllegalArgumentException(String.format("Invalid 'fromMode' in generator configuration for '%s'", this.getName()));
        }
    }

    protected String getImageName() {
        if (this.getContext().getRuntimeMode() == RuntimeMode.OPENSHIFT) {
            return this.getConfigWithFallback(Config.NAME, "jkube.generator.name", "%a:%l");
        }
        return this.getConfigWithFallback(Config.NAME, "jkube.generator.name", "%g/%a:%l");
    }

    protected String getRegistry() {
        if (this.getContext().getRuntimeMode() == RuntimeMode.OPENSHIFT && this.getContext().getStrategy() == JKubeBuildStrategy.s2i) {
            return null;
        }
        return this.getConfigWithFallback(Config.REGISTRY, "jkube.generator.registry", null);
    }

    protected String getAlias() {
        return this.getConfigWithFallback(Config.ALIAS, "jkube.generator.alias", this.getName());
    }

    protected boolean shouldAddGeneratedImageConfiguration(List<ImageConfiguration> configs) {
        if (this.getProject() != null && this.getProject().getBaseDirectory() != null && this.getProject().getBaseDirectory().exists() && DockerFileUtil.isSimpleDockerFileMode((File)this.getContext().getProject().getBaseDirectory())) {
            return false;
        }
        if (this.containsBuildConfiguration(configs)) {
            return Boolean.parseBoolean(this.getConfigWithFallback(Config.ADD, "jkube.generator.add", "false"));
        }
        return true;
    }

    protected void addLatestTagIfSnapshot(BuildConfiguration.BuildConfigurationBuilder buildBuilder) {
        if (this.getProject().getVersion().endsWith("-SNAPSHOT")) {
            buildBuilder.tags(Collections.singletonList("latest"));
        }
    }

    protected void addTagsFromConfig(BuildConfiguration.BuildConfigurationBuilder buildConfigurationBuilder) {
        String commaSeparatedTags = this.getConfigWithFallback(Config.TAGS, "jkube.generator.tags", null);
        if (StringUtils.isNotBlank((CharSequence)commaSeparatedTags)) {
            List tags = Arrays.stream(commaSeparatedTags.split(",")).map(String::trim).collect(Collectors.toList());
            buildConfigurationBuilder.tags(tags);
        }
    }

    private boolean containsBuildConfiguration(List<ImageConfiguration> configs) {
        for (ImageConfiguration imageConfig : configs) {
            if (imageConfig.getBuildConfiguration() == null) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addSchemaLabels(BuildConfiguration.BuildConfigurationBuilder buildBuilder, PrefixedLogger log) {
        JavaProject project = this.getProject();
        String docURL = project.getDocumentationUrl();
        HashMap<String, String> labels = new HashMap<String, String>();
        labels.put(BuildLabelAnnotations.BUILD_DATE.value(), this.getProject().getBuildDate().format(DateTimeFormatter.ISO_DATE));
        labels.put(BuildLabelAnnotations.NAME.value(), project.getName());
        labels.put(BuildLabelAnnotations.DESCRIPTION.value(), project.getDescription());
        if (docURL != null) {
            labels.put(BuildLabelAnnotations.USAGE.value(), docURL);
        }
        if (project.getSite() != null) {
            labels.put(BuildLabelAnnotations.URL.value(), project.getSite());
        }
        if (project.getOrganizationName() != null && !project.getOrganizationName().isEmpty()) {
            labels.put(BuildLabelAnnotations.VENDOR.value(), project.getOrganizationName());
        }
        labels.put(BuildLabelAnnotations.VERSION.value(), project.getVersion());
        labels.put(BuildLabelAnnotations.SCHEMA_VERSION.value(), LABEL_SCHEMA_VERSION);
        try {
            Repository repository = GitUtil.getGitRepository((File)project.getBaseDirectory());
            if (repository != null) {
                String commitID = GitUtil.getGitCommitId((Repository)repository);
                labels.put(BuildLabelAnnotations.VCS_REF.value(), commitID);
                String gitRemoteUrl = repository.getConfig().getString("remote", GIT_REMOTE, "url");
                if (gitRemoteUrl != null) {
                    labels.put(BuildLabelAnnotations.VCS_URL.value(), gitRemoteUrl);
                } else {
                    log.verbose("Could not detect any git remote", new Object[0]);
                }
            }
        }
        catch (IOException | NullPointerException | GitAPIException e) {
            log.error("Cannot extract Git information: " + e, new Object[]{e});
        }
        finally {
            buildBuilder.labels(labels);
        }
    }

    public String getName() {
        return this.name;
    }

    static enum Config implements Configs.Config
    {
        NAME("name", null),
        ALIAS("alias", null),
        ADD("add", "false"),
        FROM("from", null),
        FROM_MODE("fromMode", null),
        REGISTRY("registry", null),
        TAGS("tags", null);

        protected String key;
        protected String defaultValue;

        private Config(String key, String defaultValue) {
            this.key = key;
            this.defaultValue = defaultValue;
        }

        public String getKey() {
            return this.key;
        }

        public String getDefaultValue() {
            return this.defaultValue;
        }
    }
}

