/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.generator.dockerfile.simple;

import java.io.File;
import java.util.List;
import java.util.Properties;
import org.eclipse.jkube.generator.api.GeneratorContext;
import org.eclipse.jkube.generator.api.support.BaseGenerator;
import org.eclipse.jkube.generator.dockerfile.simple.SimpleDockerfileUtil;
import org.eclipse.jkube.kit.build.api.helper.ImageNameFormatter;
import org.eclipse.jkube.kit.common.util.BuildReferenceDateUtil;
import org.eclipse.jkube.kit.common.util.PropertiesUtil;
import org.eclipse.jkube.kit.config.image.ImageConfiguration;

public class SimpleDockerfileGenerator
extends BaseGenerator {
    public SimpleDockerfileGenerator(GeneratorContext context) {
        super(context, "dockerfile-simple");
    }

    public boolean isApplicable(List<ImageConfiguration> configs) {
        return this.shouldAddGeneratedImageConfiguration(configs) && SimpleDockerfileUtil.isSimpleDockerFileMode(this.getContext().getProject().getBaseDirectory());
    }

    public List<ImageConfiguration> customize(List<ImageConfiguration> configs, boolean prePackagePhase) {
        ImageNameFormatter imageNameFormatter = new ImageNameFormatter(this.getContext().getProject(), BuildReferenceDateUtil.getBuildTimestamp(null, null, (String)this.getContext().getProject().getBuildDirectory().getAbsolutePath(), (String)"docker/build.timestamp"));
        File topDockerfile = SimpleDockerfileUtil.getTopLevelDockerfile(this.getContext().getProject().getBaseDirectory());
        String defaultImageName = imageNameFormatter.format(PropertiesUtil.getValueFromProperties((Properties)this.getContext().getProject().getProperties(), (String[])new String[]{"jkube.image.name", "jkube.generator.name"}));
        if (configs.isEmpty()) {
            configs.add(SimpleDockerfileUtil.createSimpleDockerfileConfig(topDockerfile, defaultImageName));
        } else if (configs.size() == 1 && configs.get(0).getBuildConfiguration() == null) {
            configs.set(0, SimpleDockerfileUtil.addSimpleDockerfileConfig(configs.get(0), topDockerfile));
        }
        return configs;
    }
}

