/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.generator.webapp.handler;

import java.io.IOException;
import java.net.URI;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.stream.Stream;
import org.eclipse.jkube.generator.api.DefaultImageLookup;
import org.eclipse.jkube.generator.api.GeneratorContext;
import org.eclipse.jkube.generator.webapp.AppServerHandler;
import org.eclipse.jkube.kit.common.JavaProject;

public abstract class AbstractAppServerHandler
implements AppServerHandler {
    protected final DefaultImageLookup imageLookup;
    protected final GeneratorContext generatorContext;
    private final String name;

    protected AbstractAppServerHandler(String name, GeneratorContext generatorContext) {
        this.generatorContext = generatorContext;
        this.name = name;
        this.imageLookup = new DefaultImageLookup(this.getClass());
    }

    @Override
    public String getName() {
        return this.name;
    }

    protected JavaProject getProject() {
        return this.generatorContext.getProject();
    }

    private String[] scanFiles(String ... patterns) throws IOException {
        if (this.getProject().getBuildDirectory().exists()) {
            try (Stream<Path> fileStream = Files.walk(this.getProject().getBuildDirectory().toPath(), new FileVisitOption[0]);){
                String[] stringArray = (String[])fileStream.filter(path -> {
                    for (String pattern : patterns) {
                        if (!FileSystems.getDefault().getPathMatcher(pattern).matches((Path)path)) continue;
                        return true;
                    }
                    return false;
                }).map(Path::toUri).map(URI::toString).toArray(String[]::new);
                return stringArray;
            }
        }
        return new String[0];
    }

    protected boolean hasOneOf(String ... patterns) throws IOException {
        return this.scanFiles(patterns).length > 0;
    }
}

