/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.helidon.enricher;

import java.util.Properties;
import org.eclipse.jkube.helidon.HelidonUtils;
import org.eclipse.jkube.kit.common.Configs;
import org.eclipse.jkube.kit.enricher.api.JKubeEnricherContext;
import org.eclipse.jkube.microprofile.enricher.AbstractMicroprofileHealthCheckEnricher;

public class HelidonHealthCheckEnricher
extends AbstractMicroprofileHealthCheckEnricher {
    private static final String DEFAULT_HELIDON_PORT = "8080";
    private final Properties helidonApplicationConfiguration = HelidonUtils.getHelidonConfiguration(this.getContext().getProject());

    public HelidonHealthCheckEnricher(JKubeEnricherContext buildContext) {
        super(buildContext, "jkube-healthcheck-helidon");
        this.log.debug("Helidon Application Config loaded from: %s", new Object[]{this.helidonApplicationConfiguration.get("jkube.internal.application-config-file.path")});
    }

    protected boolean shouldAddProbe() {
        return HelidonUtils.hasHelidonHealthDependency(this.getContext().getProject());
    }

    protected int getPort() {
        return Configs.asInteger((String)HelidonUtils.extractPort(this.helidonApplicationConfiguration, DEFAULT_HELIDON_PORT));
    }
}

