/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.helidon.generator;

import java.util.List;
import java.util.Optional;
import java.util.Properties;
import org.eclipse.jkube.generator.api.GeneratorContext;
import org.eclipse.jkube.generator.javaexec.JavaExecGenerator;
import org.eclipse.jkube.helidon.HelidonUtils;
import org.eclipse.jkube.helidon.generator.HelidonNestedGenerator;
import org.eclipse.jkube.kit.common.Arguments;
import org.eclipse.jkube.kit.common.AssemblyConfiguration;
import org.eclipse.jkube.kit.config.image.ImageConfiguration;

public class HelidonGenerator
extends JavaExecGenerator {
    public static final String HELIDON = "helidon";
    private final HelidonNestedGenerator nestedGenerator;
    private final Properties helidonApplicationConfiguration;

    public HelidonGenerator(GeneratorContext context) {
        super(context, HELIDON);
        this.nestedGenerator = HelidonNestedGenerator.from(context, this.getGeneratorConfig());
        this.helidonApplicationConfiguration = HelidonUtils.getHelidonConfiguration(this.getContext().getProject());
        this.log.debug("Helidon Application Config loaded from: %s", new Object[]{this.helidonApplicationConfiguration.get("jkube.internal.application-config-file.path")});
    }

    public boolean isApplicable(List<ImageConfiguration> configs) {
        return this.shouldAddGeneratedImageConfiguration(configs) && HelidonUtils.hasHelidonDependencies(this.getProject());
    }

    protected AssemblyConfiguration createAssembly() {
        return this.nestedGenerator.createAssemblyConfiguration();
    }

    protected String getBuildWorkdir() {
        return this.nestedGenerator.getBuildWorkdir();
    }

    protected String getFromAsConfigured() {
        return Optional.ofNullable(super.getFromAsConfigured()).orElse(this.nestedGenerator.getFrom());
    }

    protected Arguments getBuildEntryPoint() {
        return this.nestedGenerator.getBuildEntryPoint();
    }

    protected String getDefaultWebPort() {
        return HelidonUtils.extractPort(this.helidonApplicationConfiguration, super.getDefaultWebPort());
    }

    protected String getDefaultJolokiaPort() {
        return this.nestedGenerator.getDefaultJolokiaPort();
    }

    protected String getDefaultPrometheusPort() {
        return this.nestedGenerator.getDefaultPrometheusPort();
    }
}

