/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.helidon.generator;

import java.io.File;
import org.eclipse.jkube.generator.api.FromSelector;
import org.eclipse.jkube.generator.api.GeneratorConfig;
import org.eclipse.jkube.generator.api.GeneratorContext;
import org.eclipse.jkube.helidon.generator.AbstractHelidonNestedGenerator;
import org.eclipse.jkube.kit.common.Arguments;
import org.eclipse.jkube.kit.common.Assembly;
import org.eclipse.jkube.kit.common.AssemblyConfiguration;
import org.eclipse.jkube.kit.common.AssemblyFileSet;
import org.eclipse.jkube.kit.common.JavaProject;
import org.eclipse.jkube.kit.common.util.FileUtil;

public class NativeGenerator
extends AbstractHelidonNestedGenerator {
    private final FromSelector fromSelector;

    public NativeGenerator(GeneratorContext generatorContext, GeneratorConfig generatorConfig) {
        super(generatorContext, generatorConfig);
        this.fromSelector = new FromSelector.Default(generatorContext, "helidon-native");
    }

    @Override
    public String getFrom() {
        return this.fromSelector.getFrom();
    }

    @Override
    public String getDefaultJolokiaPort() {
        return "0";
    }

    @Override
    public String getDefaultPrometheusPort() {
        return "0";
    }

    @Override
    public Arguments getBuildEntryPoint() {
        return Arguments.builder().execArgument("./" + this.getProject().getArtifactId()).build();
    }

    @Override
    public String getBuildWorkdir() {
        return "/";
    }

    @Override
    public String getTargetDir() {
        return "/";
    }

    @Override
    public AssemblyConfiguration createAssemblyConfiguration() {
        JavaProject project = this.getProject();
        AssemblyFileSet.AssemblyFileSetBuilder artifactFileSetBuilder = AssemblyFileSet.builder().outputDirectory(new File(".")).directory(FileUtil.getRelativePath((File)project.getBaseDirectory(), (File)project.getBuildDirectory())).fileMode("0755");
        File nativeBinary = new File(project.getBuildDirectory(), project.getBuildFinalName());
        if (nativeBinary.exists()) {
            artifactFileSetBuilder.include(nativeBinary.getName());
        }
        return AssemblyConfiguration.builder().targetDir(this.getTargetDir()).excludeFinalOutputArtifact(true).layer(Assembly.builder().fileSet(artifactFileSetBuilder.build()).build()).build();
    }
}

