/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.helidon;

import java.util.Properties;
import org.eclipse.jkube.kit.common.JavaProject;
import org.eclipse.jkube.kit.common.util.JKubeProjectUtil;
import org.eclipse.jkube.kit.common.util.PropertiesUtil;

public class HelidonUtils {
    private static final String HELIDON_HTTP_PORT = "server.port";
    private static final String[] HELIDON_APP_CONFIG_FILES_LIST = new String[]{"META-INF/microprofile-config.properties", "application.yaml", "application.yml"};

    private HelidonUtils() {
    }

    public static boolean hasHelidonDependencies(JavaProject javaProject) {
        return JKubeProjectUtil.hasTransitiveDependency((JavaProject)javaProject, (String)"io.helidon.webserver", (String)"helidon-webserver");
    }

    public static boolean hasHelidonGraalNativeImageExtension(JavaProject javaProject) {
        return JKubeProjectUtil.hasDependency((JavaProject)javaProject, (String)"io.helidon.integrations.graal", (String)"helidon-graal-native-image-extension") || JKubeProjectUtil.hasDependency((JavaProject)javaProject, (String)"io.helidon.integrations.graal", (String)"helidon-mp-graal-native-image-extension");
    }

    public static boolean hasHelidonHealthDependency(JavaProject javaProject) {
        return JKubeProjectUtil.hasTransitiveDependency((JavaProject)javaProject, (String)"io.helidon.health", (String)"helidon-health");
    }

    public static Properties getHelidonConfiguration(JavaProject javaProject) {
        return PropertiesUtil.fromApplicationConfig((JavaProject)javaProject, (String[])HELIDON_APP_CONFIG_FILES_LIST);
    }

    public static String extractPort(Properties properties, String defaultValue) {
        return properties.getProperty(HELIDON_HTTP_PORT, defaultValue);
    }
}

