/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.resource.helm;

import com.marcnuri.helm.Helm;
import com.marcnuri.helm.LintCommand;
import com.marcnuri.helm.LintResult;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import io.fabric8.openshift.api.model.Template;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jkube.kit.common.JKubeConfiguration;
import org.eclipse.jkube.kit.common.JKubeException;
import org.eclipse.jkube.kit.common.JKubeFileInterpolator;
import org.eclipse.jkube.kit.common.KitLogger;
import org.eclipse.jkube.kit.common.RegistryConfig;
import org.eclipse.jkube.kit.common.RegistryServerConfiguration;
import org.eclipse.jkube.kit.common.ResourceFileType;
import org.eclipse.jkube.kit.common.archive.ArchiveCompression;
import org.eclipse.jkube.kit.common.archive.JKubeTarArchiver;
import org.eclipse.jkube.kit.common.util.FileUtil;
import org.eclipse.jkube.kit.common.util.KubernetesHelper;
import org.eclipse.jkube.kit.common.util.MapUtil;
import org.eclipse.jkube.kit.common.util.ResourceUtil;
import org.eclipse.jkube.kit.common.util.Serialization;
import org.eclipse.jkube.kit.common.util.TemplateUtil;
import org.eclipse.jkube.kit.common.util.YamlUtil;
import org.eclipse.jkube.kit.config.resource.ResourceServiceConfig;
import org.eclipse.jkube.kit.enricher.api.util.KubernetesResourceFragments;
import org.eclipse.jkube.kit.resource.helm.BadUploadException;
import org.eclipse.jkube.kit.resource.helm.Chart;
import org.eclipse.jkube.kit.resource.helm.HelmConfig;
import org.eclipse.jkube.kit.resource.helm.HelmParameter;
import org.eclipse.jkube.kit.resource.helm.HelmRepository;
import org.eclipse.jkube.kit.resource.helm.HelmServiceUtil;
import org.eclipse.jkube.kit.resource.helm.HelmUploaderManager;

public class HelmService {
    private static final String YAML_EXTENSION = ".yaml";
    public static final String CHART_FILENAME = "Chart.yaml";
    private static final String VALUES_FILENAME = "values.yaml";
    private static final String CHART_FRAGMENT_REGEX = "^chart\\.helm\\.(?<ext>yaml|yml|json)$";
    public static final Pattern CHART_FRAGMENT_PATTERN = Pattern.compile("^chart\\.helm\\.(?<ext>yaml|yml|json)$", 2);
    private static final String VALUES_FRAGMENT_REGEX = "^values\\.helm\\.(?<ext>yaml|yml|json)$";
    public static final Pattern VALUES_FRAGMENT_PATTERN = Pattern.compile("^values\\.helm\\.(?<ext>yaml|yml|json)$", 2);
    private final JKubeConfiguration jKubeConfiguration;
    private final ResourceServiceConfig resourceServiceConfig;
    private final KitLogger logger;

    public HelmService(JKubeConfiguration jKubeConfiguration, ResourceServiceConfig resourceServiceConfig, KitLogger logger) {
        this.jKubeConfiguration = jKubeConfiguration;
        this.resourceServiceConfig = resourceServiceConfig;
        this.logger = logger;
    }

    public void generateHelmCharts(HelmConfig helmConfig) throws IOException {
        for (HelmConfig.HelmType helmType : helmConfig.getTypes()) {
            this.logger.info("Creating Helm Chart \"%s\" for %s", new Object[]{helmConfig.getChart(), helmType.getDescription()});
            this.logger.debug("Source directory: %s", new Object[]{helmConfig.getSourceDir()});
            this.logger.debug("OutputDir: %s", new Object[]{helmConfig.getOutputDir()});
            File sourceDir = HelmService.prepareSourceDir(helmConfig, helmType);
            File outputDir = HelmService.prepareOutputDir(helmConfig, helmType);
            File tarballOutputDir = new File(Objects.requireNonNull(helmConfig.getTarballOutputDir(), "Tarball output directory is required"), helmType.getOutputDir());
            File templatesDir = new File(outputDir, "templates");
            FileUtils.forceMkdir((File)templatesDir);
            this.logger.debug("Processing source files", new Object[0]);
            HelmService.processSourceFiles(sourceDir, templatesDir);
            this.logger.debug("Creating %s", new Object[]{CHART_FILENAME});
            this.createChartYaml(helmConfig, outputDir);
            this.logger.debug("Copying additional files", new Object[0]);
            HelmService.copyAdditionalFiles(helmConfig, outputDir);
            this.logger.debug("Gathering parameters for placeholders", new Object[0]);
            List<HelmParameter> parameters = HelmService.collectParameters(helmConfig);
            this.logger.debug("Generating values.yaml", new Object[0]);
            this.createValuesYaml(parameters, outputDir);
            this.logger.debug("Interpolating YAML Chart templates", new Object[0]);
            HelmService.interpolateChartTemplates(parameters, templatesDir);
            File tarballFile = new File(tarballOutputDir, String.format("%s-%s%s.%s", helmConfig.getChart(), helmConfig.getVersion(), HelmService.resolveHelmClassifier(helmConfig), helmConfig.getChartExtension()));
            this.logger.debug("Creating Helm configuration Tarball: '%s'", new Object[]{tarballFile.getAbsolutePath()});
            Consumer<TarArchiveEntry> prependNameAsDirectory = tae -> tae.setName(String.format("%s/%s", helmConfig.getChart(), tae.getName()));
            List helmTarballContents = FileUtil.listFilesAndDirsRecursivelyInDirectory((File)outputDir).stream().filter(f -> !f.equals(tarballFile)).collect(Collectors.toList());
            JKubeTarArchiver.createTarBall((File)tarballFile, (File)outputDir, helmTarballContents, Collections.emptyMap(), (ArchiveCompression)ArchiveCompression.fromFileName((String)tarballFile.getName()), null, prependNameAsDirectory);
            Optional.ofNullable(helmConfig.getGeneratedChartListeners()).orElse(Collections.emptyList()).forEach(listener -> listener.chartFileGenerated(helmConfig, helmType, tarballFile));
        }
    }

    public void uploadHelmChart(HelmConfig helm) throws BadUploadException, IOException {
        HelmRepository helmRepository = HelmServiceUtil.selectHelmRepository(helm);
        if (!HelmServiceUtil.isRepositoryValid(helmRepository)) {
            String error = "No repository or invalid repository configured for upload";
            this.logger.error(error, new Object[0]);
            throw new IllegalStateException(error);
        }
        List<RegistryServerConfiguration> registryServerConfigurations = Optional.ofNullable(this.jKubeConfiguration).map(JKubeConfiguration::getRegistryConfig).map(RegistryConfig::getSettings).orElse(Collections.emptyList());
        UnaryOperator passwordDecryptor = Optional.ofNullable(this.jKubeConfiguration).map(JKubeConfiguration::getRegistryConfig).map(RegistryConfig::getPasswordDecryptionMethod).orElse(s -> s);
        HelmServiceUtil.setAuthentication(helmRepository, this.logger, registryServerConfigurations, passwordDecryptor);
        this.uploadHelmChart(helm, helmRepository);
    }

    public void lint(HelmConfig helmConfig) {
        for (HelmConfig.HelmType helmType : helmConfig.getTypes()) {
            LintResult lintResult;
            Path helmPackage = HelmService.resolveTarballFile(helmConfig, helmType);
            this.logger.info("Linting %s %s", new Object[]{helmConfig.getChart(), helmConfig.getVersion()});
            this.logger.info("Using packaged file: %s", new Object[]{helmPackage.toFile().getAbsolutePath()});
            LintCommand lintCommand = new Helm(helmPackage).lint();
            if (helmConfig.isLintStrict()) {
                lintCommand.strict();
            }
            if (helmConfig.isLintQuiet()) {
                lintCommand.quiet();
            }
            if ((lintResult = lintCommand.call()).isFailed()) {
                for (String message : lintResult.getMessages()) {
                    this.logger.error("[[W]]%s", new Object[]{message});
                }
                throw new JKubeException("Linting failed");
            }
            for (String message : lintResult.getMessages()) {
                this.logger.info("[[W]]%s", new Object[]{message});
            }
            this.logger.info("Linting successful", new Object[0]);
        }
    }

    private void uploadHelmChart(HelmConfig helmConfig, HelmRepository helmRepository) throws IOException, BadUploadException {
        HelmUploaderManager helmUploaderManager = new HelmUploaderManager();
        for (HelmConfig.HelmType helmType : helmConfig.getTypes()) {
            this.logger.info("Uploading Helm Chart \"%s\" to %s", new Object[]{helmConfig.getChart(), helmRepository.getName()});
            this.logger.debug("OutputDir: %s", new Object[]{helmConfig.getOutputDir()});
            helmUploaderManager.getHelmUploader(helmRepository.getType()).uploadSingle(HelmService.resolveTarballFile(helmConfig, helmType).toFile(), helmRepository);
            this.logger.info("Upload Successful", new Object[0]);
        }
    }

    private static Path resolveTarballFile(HelmConfig helmConfig, HelmConfig.HelmType helmType) {
        return Paths.get(Objects.requireNonNull(helmConfig.getTarballOutputDir(), "Tarball output directory is required"), new String[0]).resolve(helmType.getOutputDir()).resolve(String.format("%s-%s%s.%s", helmConfig.getChart(), helmConfig.getVersion(), HelmService.resolveHelmClassifier(helmConfig), helmConfig.getChartExtension()));
    }

    static File prepareSourceDir(HelmConfig helmConfig, HelmConfig.HelmType type) throws IOException {
        File sourceDir = new File(helmConfig.getSourceDir(), type.getSourceDir());
        if (!sourceDir.isDirectory()) {
            throw new IOException(String.format("Chart source directory %s does not exist so cannot make chart \"%s\". Probably you need run 'mvn kubernetes:resource' before.", sourceDir.getAbsolutePath(), helmConfig.getChart()));
        }
        if (!HelmService.containsYamlFiles(sourceDir)) {
            throw new IOException(String.format("Chart source directory %s does not contain any YAML manifest to make chart \"%s\". Probably you need run 'mvn kubernetes:resource' before.", sourceDir.getAbsolutePath(), helmConfig.getChart()));
        }
        return sourceDir;
    }

    private static File prepareOutputDir(HelmConfig helmConfig, HelmConfig.HelmType type) throws IOException {
        File outputDir = new File(helmConfig.getOutputDir(), type.getOutputDir());
        if (outputDir.exists() && !outputDir.isDirectory()) {
            FileUtils.forceDelete((File)outputDir);
        }
        FileUtils.forceMkdir((File)outputDir);
        return outputDir;
    }

    public static boolean containsYamlFiles(File directory) {
        return !YamlUtil.listYamls((File)directory).isEmpty();
    }

    private static void processSourceFiles(File sourceDir, File templatesDir) throws IOException {
        for (File file : YamlUtil.listYamls((File)sourceDir)) {
            KubernetesResource dto = (KubernetesResource)Serialization.unmarshal((File)file);
            if (dto instanceof Template) {
                HelmService.splitAndSaveTemplate((Template)dto, templatesDir);
                continue;
            }
            String fileName = FileUtil.stripPostfix((String)FileUtil.stripPostfix((String)file.getName(), (String)".yml"), (String)YAML_EXTENSION) + YAML_EXTENSION;
            File targetFile = new File(templatesDir, fileName);
            String text = FileUtils.readFileToString((File)file, (Charset)Charset.defaultCharset());
            text = TemplateUtil.escapeYamlTemplate((String)text);
            FileUtils.write((File)targetFile, (CharSequence)text, (Charset)Charset.defaultCharset());
        }
    }

    private static void splitAndSaveTemplate(Template template, File templatesDir) throws IOException {
        for (HasMetadata object : Optional.ofNullable(template.getObjects()).orElse(Collections.emptyList())) {
            String name = KubernetesResourceFragments.getNameWithSuffix((String)KubernetesHelper.getName((HasMetadata)object), (String)KubernetesHelper.getKind((KubernetesResource)object)) + YAML_EXTENSION;
            File outFile = new File(templatesDir, name);
            ResourceUtil.save((File)outFile, (Object)object);
        }
    }

    private void createChartYaml(HelmConfig helmConfig, File outputDir) throws IOException {
        Chart chartFromHelmConfig = HelmService.chartFromHelmConfig(helmConfig);
        Chart chartFromFragment = this.readFragment(CHART_FRAGMENT_PATTERN, Chart.class);
        Chart mergedChart = (Chart)Serialization.merge((Object)chartFromHelmConfig, (Object)chartFromFragment);
        ResourceUtil.save((File)new File(outputDir, CHART_FILENAME), (Object)mergedChart, (ResourceFileType)ResourceFileType.yaml);
    }

    private static Chart chartFromHelmConfig(HelmConfig helmConfig) {
        return Chart.builder().apiVersion(helmConfig.getApiVersion()).name(helmConfig.getChart()).version(helmConfig.getVersion()).description(helmConfig.getDescription()).home(helmConfig.getHome()).sources(helmConfig.getSources()).maintainers(helmConfig.getMaintainers()).icon(helmConfig.getIcon()).appVersion(helmConfig.getAppVersion()).keywords(helmConfig.getKeywords()).engine(helmConfig.getEngine()).dependencies(helmConfig.getDependencies()).build();
    }

    private <T> T readFragment(Pattern filePattern, Class<T> type) {
        File helmChartFragment = HelmService.resolveHelmFragment(filePattern, this.resourceServiceConfig);
        if (helmChartFragment != null) {
            try {
                return (T)Serialization.unmarshal((String)JKubeFileInterpolator.interpolate((File)helmChartFragment, (Properties)this.jKubeConfiguration.getProperties(), (String)"${*}"), type);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Failure in parsing Helm fragment (" + helmChartFragment.getName() + "): " + e.getMessage(), e);
            }
        }
        return null;
    }

    private static File resolveHelmFragment(Pattern filePattern, ResourceServiceConfig resourceServiceConfig) {
        List fragmentDirs = resourceServiceConfig.getResourceDirs();
        if (fragmentDirs != null) {
            for (File fragmentDir : fragmentDirs) {
                File[] fragments;
                if (!fragmentDir.exists() || !fragmentDir.isDirectory() || (fragments = fragmentDir.listFiles((dir, name) -> filePattern.matcher(name).matches())) == null) continue;
                return Stream.of(fragments).filter(File::exists).findAny().orElse(null);
            }
        }
        return null;
    }

    private static void copyAdditionalFiles(HelmConfig helmConfig, File outputDir) throws IOException {
        for (File additionalFile : Optional.ofNullable(helmConfig.getAdditionalFiles()).orElse(Collections.emptyList())) {
            FileUtils.copyFile((File)additionalFile, (File)new File(outputDir, additionalFile.getName()));
        }
    }

    private static String interpolateTemplateWithHelmParameter(String template, HelmParameter parameter) {
        String name = parameter.getName();
        String from = "$" + name;
        String braceEnclosedFrom = "${" + name + "}";
        String quotedBraceEnclosedFrom = "\"" + braceEnclosedFrom + "\"";
        String answer = template;
        String to = parameter.toExpression();
        answer = answer.replace(quotedBraceEnclosedFrom, to);
        answer = answer.replace(braceEnclosedFrom, to);
        answer = answer.replace(from, to);
        return answer;
    }

    private static void interpolateTemplateParameterExpressionsWithHelmExpressions(File file, List<HelmParameter> helmParameters) throws IOException {
        String originalTemplate;
        String interpolatedTemplate = originalTemplate = FileUtils.readFileToString((File)file, (Charset)Charset.defaultCharset());
        for (HelmParameter helmParameter : helmParameters) {
            interpolatedTemplate = HelmService.interpolateTemplateWithHelmParameter(interpolatedTemplate, helmParameter);
        }
        if (!originalTemplate.equals(interpolatedTemplate)) {
            FileUtils.writeStringToFile((File)file, (String)interpolatedTemplate, (Charset)Charset.defaultCharset());
        }
    }

    private static void interpolateChartTemplates(List<HelmParameter> helmParameters, File templatesDir) throws IOException {
        for (File file : YamlUtil.listYamls((File)templatesDir)) {
            HelmService.interpolateTemplateParameterExpressionsWithHelmExpressions(file, helmParameters);
        }
    }

    private void createValuesYaml(List<HelmParameter> helmParameters, File outputDir) throws IOException {
        Map<String, Object> valuesFromParameters = helmParameters.stream().filter(hp -> hp.getValue() != null).filter(hp -> !hp.isGolangExpression()).collect(Collectors.toMap(HelmParameter::getName, HelmParameter::getValue));
        Map valuesFromFragment = this.readFragment(VALUES_FRAGMENT_PATTERN, Map.class);
        Map mergedValues = (Map)Serialization.merge((Object)MapUtil.getNestedMap(valuesFromParameters), (Object)valuesFromFragment);
        ResourceUtil.save((File)new File(outputDir, VALUES_FILENAME), (Object)mergedValues, (ResourceFileType)ResourceFileType.yaml);
    }

    private static List<HelmParameter> collectParameters(HelmConfig helmConfig) {
        ArrayList<HelmParameter> parameters = new ArrayList<HelmParameter>();
        if (helmConfig.getParameterTemplates() != null) {
            helmConfig.getParameterTemplates().stream().map(Template::getParameters).flatMap(Collection::stream).map(p -> HelmParameter.builder().name(p.getName()).required(Boolean.TRUE.equals(p.getRequired())).value(p.getValue()).build()).forEach(parameters::add);
        }
        if (helmConfig.getParameters() != null && !helmConfig.getParameters().isEmpty()) {
            parameters.addAll(helmConfig.getParameters());
        }
        parameters.stream().filter(p -> p.getName() == null).findAny().ifPresent(p -> {
            throw new IllegalArgumentException("Helm parameters must be declared with a valid name: " + p);
        });
        return parameters;
    }

    private static String resolveHelmClassifier(HelmConfig helmConfig) {
        if (StringUtils.isBlank((CharSequence)helmConfig.getTarFileClassifier())) {
            return "";
        }
        return "-" + helmConfig.getTarFileClassifier();
    }
}

