/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.resource.helm.oci;

import io.fabric8.kubernetes.client.http.BasicBuilder;
import io.fabric8.kubernetes.client.http.HttpClient;
import io.fabric8.kubernetes.client.http.HttpRequest;
import io.fabric8.kubernetes.client.http.HttpResponse;
import io.fabric8.kubernetes.client.http.Interceptor;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.time.Duration;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jkube.kit.common.util.AsyncUtil;
import org.eclipse.jkube.kit.common.util.Base64Util;
import org.eclipse.jkube.kit.common.util.Fabric8HttpUtil;
import org.eclipse.jkube.kit.common.util.Serialization;
import org.eclipse.jkube.kit.resource.helm.HelmRepository;

public class OCIRegistryInterceptor
implements Interceptor {
    private static final String TOKEN_KEY = "token";
    private static final String ACCESS_TOKEN_KEY = "access_token";
    private static final long OCI_REGISTRY_AUTH_REQUEST_TIMEOUT_MINUTES = 1L;
    private static final String WWW_AUTHENTICATE = "WWW-Authenticate";
    public static final String NAME = "OCI_TOKEN";
    private static final String AUTHORIZATION = "Authorization";
    private static final String BEARER = "Bearer ";
    private final HelmRepository repository;
    private final HttpClient httpClient;
    private String accessToken;

    public OCIRegistryInterceptor(HttpClient.Factory httpClientFactory, HelmRepository helmRepository) {
        this(httpClientFactory, helmRepository, null);
    }

    OCIRegistryInterceptor(HttpClient.Factory httpClientFactory, HelmRepository helmRepository, String token) {
        this.repository = helmRepository;
        this.httpClient = httpClientFactory.newBuilder().build();
        this.accessToken = token;
    }

    public void before(BasicBuilder headerBuilder, HttpRequest request, Interceptor.RequestTags tags) {
        if (StringUtils.isNotBlank((CharSequence)this.accessToken)) {
            headerBuilder.setHeader(AUTHORIZATION, BEARER + this.accessToken);
        }
    }

    public CompletableFuture<Boolean> afterFailure(BasicBuilder headerBuilder, HttpResponse<?> response, Interceptor.RequestTags tags) {
        if (response.code() == 401) {
            if (StringUtils.isBlank((CharSequence)response.header(WWW_AUTHENTICATE))) {
                throw new IllegalStateException("Got 401 but no WWW-Authenticate found in response headers ");
            }
            return this.refreshToken(headerBuilder, response);
        }
        return CompletableFuture.completedFuture(false);
    }

    private CompletableFuture<Boolean> refreshToken(BasicBuilder headerBuilder, HttpResponse<?> response) {
        try {
            String updatedAccessToken = this.submitHttpRequestForAuthenticationChallenge(response);
            if (StringUtils.isNotBlank((CharSequence)updatedAccessToken)) {
                this.accessToken = updatedAccessToken;
                headerBuilder.setHeader(AUTHORIZATION, BEARER + this.accessToken);
                return CompletableFuture.completedFuture(true);
            }
            return CompletableFuture.completedFuture(false);
        }
        catch (IOException e) {
            throw new IllegalStateException("Failure while refreshing token from OCI registry: ", e);
        }
    }

    private String submitHttpRequestForAuthenticationChallenge(HttpResponse<?> response) throws IOException {
        Map authChallengeHeader = Fabric8HttpUtil.extractAuthenticationChallengeIntoMap(response).stream().filter(c -> ((String)c.get("scheme")).equals("Bearer")).findFirst().orElse(Collections.emptyMap());
        String authenticationUrl = (String)authChallengeHeader.get("realm");
        String scope = (String)authChallengeHeader.get("scope");
        if (!scope.contains("push")) {
            scope = scope + ",push";
        }
        String service = (String)authChallengeHeader.get("service");
        return this.submitGetRequest(authenticationUrl, scope, service);
    }

    private String submitGetRequest(String url, String scope, String service) throws IOException {
        String authUrlWithQueryParams = String.format("%s?service=%s&scope=%s", url, service, scope);
        HttpRequest httpRequest = this.httpClient.newHttpRequestBuilder().header(AUTHORIZATION, String.format("Basic %s", Base64Util.encodeToString((String)(this.repository.getUsername() + ":" + this.repository.getPassword())))).uri(authUrlWithQueryParams).build();
        HttpResponse response = (HttpResponse)AsyncUtil.get((CompletableFuture)this.httpClient.sendAsync(httpRequest, byte[].class), (Duration)Duration.ofMinutes(1L));
        int responseCode = response.code();
        if (responseCode == 200) {
            return this.parseAccessTokenFromResponse(new String((byte[])response.body()));
        }
        if (responseCode == 405) {
            return this.submitPostRequest(url, scope, service);
        }
        return null;
    }

    private String submitPostRequest(String url, String scope, String service) throws IOException {
        String postDataString = this.createPostFormDataForDockerAuth(scope, service);
        HttpRequest httpRequest = this.httpClient.newHttpRequestBuilder().header("Content-Length", Integer.toString(postDataString.getBytes().length)).method("POST", "application/x-www-form-urlencoded", postDataString).uri(url).build();
        HttpResponse response = (HttpResponse)AsyncUtil.get((CompletableFuture)this.httpClient.sendAsync(httpRequest, byte[].class), (Duration)Duration.ofMinutes(1L));
        if (response.isSuccessful()) {
            return this.parseAccessTokenFromResponse(response.bodyString());
        }
        return null;
    }

    private String parseAccessTokenFromResponse(String responseBody) {
        Map responseBodyObj = (Map)Serialization.unmarshal((String)responseBody, Map.class);
        String tokenFound = null;
        if (responseBodyObj.containsKey(TOKEN_KEY)) {
            tokenFound = (String)responseBodyObj.get(TOKEN_KEY);
        }
        if (responseBodyObj.containsKey(ACCESS_TOKEN_KEY)) {
            tokenFound = (String)responseBodyObj.get(ACCESS_TOKEN_KEY);
        }
        if (StringUtils.isNotBlank((CharSequence)tokenFound)) {
            return tokenFound;
        }
        return null;
    }

    private String createPostFormDataForDockerAuth(String scope, String service) throws UnsupportedEncodingException {
        HashMap<String, String> postFormData = new HashMap<String, String>();
        postFormData.put("grant_type", "password");
        postFormData.put("refresh_token", this.repository.getPassword());
        postFormData.put("service", service);
        postFormData.put("scope", scope);
        postFormData.put("client_id", "EclipseJKube");
        postFormData.put("username", this.repository.getUsername());
        postFormData.put("password", this.repository.getPassword());
        return Fabric8HttpUtil.toFormData(postFormData);
    }
}

