/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.resource.helm.oci;

import io.fabric8.kubernetes.client.http.HttpClient;
import io.fabric8.kubernetes.client.http.Interceptor;
import io.fabric8.kubernetes.client.utils.HttpClientUtils;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import org.eclipse.jkube.kit.common.util.Serialization;
import org.eclipse.jkube.kit.config.image.ImageName;
import org.eclipse.jkube.kit.resource.helm.BadUploadException;
import org.eclipse.jkube.kit.resource.helm.Chart;
import org.eclipse.jkube.kit.resource.helm.HelmRepository;
import org.eclipse.jkube.kit.resource.helm.HelmUploader;
import org.eclipse.jkube.kit.resource.helm.oci.OCIManifestLayer;
import org.eclipse.jkube.kit.resource.helm.oci.OCIRegistryClient;
import org.eclipse.jkube.kit.resource.helm.oci.OCIRegistryInterceptor;

public class OCIRepositoryUploader
implements HelmUploader {
    @Override
    public HelmRepository.HelmRepoType getType() {
        return HelmRepository.HelmRepoType.OCI;
    }

    @Override
    public void uploadSingle(File file, HelmRepository repository) throws IOException, BadUploadException {
        HttpClient.Factory httpClientFactory = HttpClientUtils.getHttpClientFactory();
        try (HttpClient httpClient = httpClientFactory.newBuilder().addOrReplaceInterceptor("OCI_TOKEN", (Interceptor)new OCIRegistryInterceptor(httpClientFactory, repository)).build();){
            Chart chart = OCIRepositoryUploader.readGeneratedChartYamlFile(file);
            OCIRepositoryUploader.validateChartName(chart);
            byte[] chartYamlBytes = Serialization.asJson((Object)chart).getBytes(StandardCharsets.UTF_8);
            OCIRegistryClient oci = new OCIRegistryClient(repository, httpClient);
            OCIManifestLayer chartConfig = oci.uploadBlobIfNotUploadedYet(chart, new ByteArrayInputStream(chartYamlBytes));
            OCIManifestLayer chartTarball = oci.uploadBlobIfNotUploadedYet(chart, new BufferedInputStream(Files.newInputStream(file.toPath(), new OpenOption[0])));
            oci.uploadOCIManifest(chart, chartConfig, chartTarball);
        }
    }

    private static Chart readGeneratedChartYamlFile(File chartArchive) throws IOException {
        File chartMetadataFile = new File(chartArchive.getParentFile(), "Chart.yaml");
        if (chartMetadataFile.exists()) {
            return (Chart)Serialization.unmarshal((File)chartMetadataFile, Chart.class);
        }
        throw new IllegalStateException("Could not find Chart.yaml file in " + chartArchive.getParentFile());
    }

    private static void validateChartName(Chart chart) {
        try {
            new ImageName(chart.getName());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IllegalArgumentException("Chart name " + chart.getName() + " is invalid for uploading to OCI registry", illegalArgumentException);
        }
    }
}

