/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.resource.helm;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.openshift.api.model.Template;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jkube.kit.common.Maintainer;
import org.eclipse.jkube.kit.resource.helm.GeneratedChartListener;
import org.eclipse.jkube.kit.resource.helm.HelmDependency;
import org.eclipse.jkube.kit.resource.helm.HelmParameter;
import org.eclipse.jkube.kit.resource.helm.HelmRepository;

public class HelmConfig {
    private String apiVersion;
    private String chart;
    private String chartExtension;
    private String version;
    private String description;
    private String home;
    private List<String> sources;
    private List<Maintainer> maintainers;
    private String icon;
    private String appVersion;
    private List<String> keywords;
    private String engine;
    private List<File> additionalFiles;
    private List<Template> parameterTemplates;
    private List<HelmParameter> parameters;
    private List<HelmType> types;
    private String sourceDir;
    private String outputDir;
    private String tarballOutputDir;
    private String tarFileClassifier;
    private List<GeneratedChartListener> generatedChartListeners;
    private HelmRepository stableRepository;
    private HelmRepository snapshotRepository;
    private String security;
    private boolean lintStrict;
    private boolean lintQuiet;
    private boolean debug;
    private boolean dependencyVerify;
    private boolean dependencySkipRefresh;
    private String releaseName;
    private boolean installDependencyUpdate;
    private boolean installWaitReady;
    private boolean disableOpenAPIValidation;
    @JsonProperty(value="dependencies")
    private List<HelmDependency> dependencies;

    public void setType(String types) {
        this.setTypes(HelmType.parseString(types));
    }

    private static List<GeneratedChartListener> $default$generatedChartListeners() {
        return new ArrayList<GeneratedChartListener>();
    }

    public static HelmConfigBuilder builder() {
        return new HelmConfigBuilder();
    }

    public HelmConfigBuilder toBuilder() {
        return new HelmConfigBuilder().apiVersion(this.apiVersion).chart(this.chart).chartExtension(this.chartExtension).version(this.version).description(this.description).home(this.home).sources(this.sources).maintainers(this.maintainers).icon(this.icon).appVersion(this.appVersion).keywords(this.keywords).engine(this.engine).additionalFiles(this.additionalFiles).parameterTemplates(this.parameterTemplates).parameters(this.parameters).types(this.types).sourceDir(this.sourceDir).outputDir(this.outputDir).tarballOutputDir(this.tarballOutputDir).tarFileClassifier(this.tarFileClassifier).generatedChartListeners(this.generatedChartListeners).stableRepository(this.stableRepository).snapshotRepository(this.snapshotRepository).security(this.security).lintStrict(this.lintStrict).lintQuiet(this.lintQuiet).debug(this.debug).dependencyVerify(this.dependencyVerify).dependencySkipRefresh(this.dependencySkipRefresh).releaseName(this.releaseName).installDependencyUpdate(this.installDependencyUpdate).installWaitReady(this.installWaitReady).disableOpenAPIValidation(this.disableOpenAPIValidation).dependencies(this.dependencies);
    }

    public HelmConfig(String apiVersion, String chart, String chartExtension, String version, String description, String home, List<String> sources, List<Maintainer> maintainers, String icon, String appVersion, List<String> keywords, String engine, List<File> additionalFiles, List<Template> parameterTemplates, List<HelmParameter> parameters, List<HelmType> types, String sourceDir, String outputDir, String tarballOutputDir, String tarFileClassifier, List<GeneratedChartListener> generatedChartListeners, HelmRepository stableRepository, HelmRepository snapshotRepository, String security, boolean lintStrict, boolean lintQuiet, boolean debug, boolean dependencyVerify, boolean dependencySkipRefresh, String releaseName, boolean installDependencyUpdate, boolean installWaitReady, boolean disableOpenAPIValidation, List<HelmDependency> dependencies) {
        this.apiVersion = apiVersion;
        this.chart = chart;
        this.chartExtension = chartExtension;
        this.version = version;
        this.description = description;
        this.home = home;
        this.sources = sources;
        this.maintainers = maintainers;
        this.icon = icon;
        this.appVersion = appVersion;
        this.keywords = keywords;
        this.engine = engine;
        this.additionalFiles = additionalFiles;
        this.parameterTemplates = parameterTemplates;
        this.parameters = parameters;
        this.types = types;
        this.sourceDir = sourceDir;
        this.outputDir = outputDir;
        this.tarballOutputDir = tarballOutputDir;
        this.tarFileClassifier = tarFileClassifier;
        this.generatedChartListeners = generatedChartListeners;
        this.stableRepository = stableRepository;
        this.snapshotRepository = snapshotRepository;
        this.security = security;
        this.lintStrict = lintStrict;
        this.lintQuiet = lintQuiet;
        this.debug = debug;
        this.dependencyVerify = dependencyVerify;
        this.dependencySkipRefresh = dependencySkipRefresh;
        this.releaseName = releaseName;
        this.installDependencyUpdate = installDependencyUpdate;
        this.installWaitReady = installWaitReady;
        this.disableOpenAPIValidation = disableOpenAPIValidation;
        this.dependencies = dependencies;
    }

    public HelmConfig() {
        this.generatedChartListeners = HelmConfig.$default$generatedChartListeners();
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public String getChart() {
        return this.chart;
    }

    public String getChartExtension() {
        return this.chartExtension;
    }

    public String getVersion() {
        return this.version;
    }

    public String getDescription() {
        return this.description;
    }

    public String getHome() {
        return this.home;
    }

    public List<String> getSources() {
        return this.sources;
    }

    public List<Maintainer> getMaintainers() {
        return this.maintainers;
    }

    public String getIcon() {
        return this.icon;
    }

    public String getAppVersion() {
        return this.appVersion;
    }

    public List<String> getKeywords() {
        return this.keywords;
    }

    public String getEngine() {
        return this.engine;
    }

    public List<File> getAdditionalFiles() {
        return this.additionalFiles;
    }

    public List<Template> getParameterTemplates() {
        return this.parameterTemplates;
    }

    public List<HelmParameter> getParameters() {
        return this.parameters;
    }

    public List<HelmType> getTypes() {
        return this.types;
    }

    public String getSourceDir() {
        return this.sourceDir;
    }

    public String getOutputDir() {
        return this.outputDir;
    }

    public String getTarballOutputDir() {
        return this.tarballOutputDir;
    }

    public String getTarFileClassifier() {
        return this.tarFileClassifier;
    }

    public List<GeneratedChartListener> getGeneratedChartListeners() {
        return this.generatedChartListeners;
    }

    public HelmRepository getStableRepository() {
        return this.stableRepository;
    }

    public HelmRepository getSnapshotRepository() {
        return this.snapshotRepository;
    }

    public String getSecurity() {
        return this.security;
    }

    public boolean isLintStrict() {
        return this.lintStrict;
    }

    public boolean isLintQuiet() {
        return this.lintQuiet;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public boolean isDependencyVerify() {
        return this.dependencyVerify;
    }

    public boolean isDependencySkipRefresh() {
        return this.dependencySkipRefresh;
    }

    public String getReleaseName() {
        return this.releaseName;
    }

    public boolean isInstallDependencyUpdate() {
        return this.installDependencyUpdate;
    }

    public boolean isInstallWaitReady() {
        return this.installWaitReady;
    }

    public boolean isDisableOpenAPIValidation() {
        return this.disableOpenAPIValidation;
    }

    public List<HelmDependency> getDependencies() {
        return this.dependencies;
    }

    public void setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
    }

    public void setChart(String chart) {
        this.chart = chart;
    }

    public void setChartExtension(String chartExtension) {
        this.chartExtension = chartExtension;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setHome(String home) {
        this.home = home;
    }

    public void setSources(List<String> sources) {
        this.sources = sources;
    }

    public void setMaintainers(List<Maintainer> maintainers) {
        this.maintainers = maintainers;
    }

    public void setIcon(String icon) {
        this.icon = icon;
    }

    public void setAppVersion(String appVersion) {
        this.appVersion = appVersion;
    }

    public void setKeywords(List<String> keywords) {
        this.keywords = keywords;
    }

    public void setEngine(String engine) {
        this.engine = engine;
    }

    public void setAdditionalFiles(List<File> additionalFiles) {
        this.additionalFiles = additionalFiles;
    }

    public void setParameterTemplates(List<Template> parameterTemplates) {
        this.parameterTemplates = parameterTemplates;
    }

    public void setParameters(List<HelmParameter> parameters) {
        this.parameters = parameters;
    }

    public void setTypes(List<HelmType> types) {
        this.types = types;
    }

    public void setSourceDir(String sourceDir) {
        this.sourceDir = sourceDir;
    }

    public void setOutputDir(String outputDir) {
        this.outputDir = outputDir;
    }

    public void setTarballOutputDir(String tarballOutputDir) {
        this.tarballOutputDir = tarballOutputDir;
    }

    public void setTarFileClassifier(String tarFileClassifier) {
        this.tarFileClassifier = tarFileClassifier;
    }

    public void setGeneratedChartListeners(List<GeneratedChartListener> generatedChartListeners) {
        this.generatedChartListeners = generatedChartListeners;
    }

    public void setStableRepository(HelmRepository stableRepository) {
        this.stableRepository = stableRepository;
    }

    public void setSnapshotRepository(HelmRepository snapshotRepository) {
        this.snapshotRepository = snapshotRepository;
    }

    public void setSecurity(String security) {
        this.security = security;
    }

    public void setLintStrict(boolean lintStrict) {
        this.lintStrict = lintStrict;
    }

    public void setLintQuiet(boolean lintQuiet) {
        this.lintQuiet = lintQuiet;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public void setDependencyVerify(boolean dependencyVerify) {
        this.dependencyVerify = dependencyVerify;
    }

    public void setDependencySkipRefresh(boolean dependencySkipRefresh) {
        this.dependencySkipRefresh = dependencySkipRefresh;
    }

    public void setReleaseName(String releaseName) {
        this.releaseName = releaseName;
    }

    public void setInstallDependencyUpdate(boolean installDependencyUpdate) {
        this.installDependencyUpdate = installDependencyUpdate;
    }

    public void setInstallWaitReady(boolean installWaitReady) {
        this.installWaitReady = installWaitReady;
    }

    public void setDisableOpenAPIValidation(boolean disableOpenAPIValidation) {
        this.disableOpenAPIValidation = disableOpenAPIValidation;
    }

    @JsonProperty(value="dependencies")
    public void setDependencies(List<HelmDependency> dependencies) {
        this.dependencies = dependencies;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HelmConfig)) {
            return false;
        }
        HelmConfig other = (HelmConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isLintStrict() != other.isLintStrict()) {
            return false;
        }
        if (this.isLintQuiet() != other.isLintQuiet()) {
            return false;
        }
        if (this.isDebug() != other.isDebug()) {
            return false;
        }
        if (this.isDependencyVerify() != other.isDependencyVerify()) {
            return false;
        }
        if (this.isDependencySkipRefresh() != other.isDependencySkipRefresh()) {
            return false;
        }
        if (this.isInstallDependencyUpdate() != other.isInstallDependencyUpdate()) {
            return false;
        }
        if (this.isInstallWaitReady() != other.isInstallWaitReady()) {
            return false;
        }
        if (this.isDisableOpenAPIValidation() != other.isDisableOpenAPIValidation()) {
            return false;
        }
        String this$apiVersion = this.getApiVersion();
        String other$apiVersion = other.getApiVersion();
        if (this$apiVersion == null ? other$apiVersion != null : !this$apiVersion.equals(other$apiVersion)) {
            return false;
        }
        String this$chart = this.getChart();
        String other$chart = other.getChart();
        if (this$chart == null ? other$chart != null : !this$chart.equals(other$chart)) {
            return false;
        }
        String this$chartExtension = this.getChartExtension();
        String other$chartExtension = other.getChartExtension();
        if (this$chartExtension == null ? other$chartExtension != null : !this$chartExtension.equals(other$chartExtension)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$home = this.getHome();
        String other$home = other.getHome();
        if (this$home == null ? other$home != null : !this$home.equals(other$home)) {
            return false;
        }
        List<String> this$sources = this.getSources();
        List<String> other$sources = other.getSources();
        if (this$sources == null ? other$sources != null : !((Object)this$sources).equals(other$sources)) {
            return false;
        }
        List<Maintainer> this$maintainers = this.getMaintainers();
        List<Maintainer> other$maintainers = other.getMaintainers();
        if (this$maintainers == null ? other$maintainers != null : !((Object)this$maintainers).equals(other$maintainers)) {
            return false;
        }
        String this$icon = this.getIcon();
        String other$icon = other.getIcon();
        if (this$icon == null ? other$icon != null : !this$icon.equals(other$icon)) {
            return false;
        }
        String this$appVersion = this.getAppVersion();
        String other$appVersion = other.getAppVersion();
        if (this$appVersion == null ? other$appVersion != null : !this$appVersion.equals(other$appVersion)) {
            return false;
        }
        List<String> this$keywords = this.getKeywords();
        List<String> other$keywords = other.getKeywords();
        if (this$keywords == null ? other$keywords != null : !((Object)this$keywords).equals(other$keywords)) {
            return false;
        }
        String this$engine = this.getEngine();
        String other$engine = other.getEngine();
        if (this$engine == null ? other$engine != null : !this$engine.equals(other$engine)) {
            return false;
        }
        List<File> this$additionalFiles = this.getAdditionalFiles();
        List<File> other$additionalFiles = other.getAdditionalFiles();
        if (this$additionalFiles == null ? other$additionalFiles != null : !((Object)this$additionalFiles).equals(other$additionalFiles)) {
            return false;
        }
        List<Template> this$parameterTemplates = this.getParameterTemplates();
        List<Template> other$parameterTemplates = other.getParameterTemplates();
        if (this$parameterTemplates == null ? other$parameterTemplates != null : !((Object)this$parameterTemplates).equals(other$parameterTemplates)) {
            return false;
        }
        List<HelmParameter> this$parameters = this.getParameters();
        List<HelmParameter> other$parameters = other.getParameters();
        if (this$parameters == null ? other$parameters != null : !((Object)this$parameters).equals(other$parameters)) {
            return false;
        }
        List<HelmType> this$types = this.getTypes();
        List<HelmType> other$types = other.getTypes();
        if (this$types == null ? other$types != null : !((Object)this$types).equals(other$types)) {
            return false;
        }
        String this$sourceDir = this.getSourceDir();
        String other$sourceDir = other.getSourceDir();
        if (this$sourceDir == null ? other$sourceDir != null : !this$sourceDir.equals(other$sourceDir)) {
            return false;
        }
        String this$outputDir = this.getOutputDir();
        String other$outputDir = other.getOutputDir();
        if (this$outputDir == null ? other$outputDir != null : !this$outputDir.equals(other$outputDir)) {
            return false;
        }
        String this$tarballOutputDir = this.getTarballOutputDir();
        String other$tarballOutputDir = other.getTarballOutputDir();
        if (this$tarballOutputDir == null ? other$tarballOutputDir != null : !this$tarballOutputDir.equals(other$tarballOutputDir)) {
            return false;
        }
        String this$tarFileClassifier = this.getTarFileClassifier();
        String other$tarFileClassifier = other.getTarFileClassifier();
        if (this$tarFileClassifier == null ? other$tarFileClassifier != null : !this$tarFileClassifier.equals(other$tarFileClassifier)) {
            return false;
        }
        List<GeneratedChartListener> this$generatedChartListeners = this.getGeneratedChartListeners();
        List<GeneratedChartListener> other$generatedChartListeners = other.getGeneratedChartListeners();
        if (this$generatedChartListeners == null ? other$generatedChartListeners != null : !((Object)this$generatedChartListeners).equals(other$generatedChartListeners)) {
            return false;
        }
        HelmRepository this$stableRepository = this.getStableRepository();
        HelmRepository other$stableRepository = other.getStableRepository();
        if (this$stableRepository == null ? other$stableRepository != null : !((Object)this$stableRepository).equals(other$stableRepository)) {
            return false;
        }
        HelmRepository this$snapshotRepository = this.getSnapshotRepository();
        HelmRepository other$snapshotRepository = other.getSnapshotRepository();
        if (this$snapshotRepository == null ? other$snapshotRepository != null : !((Object)this$snapshotRepository).equals(other$snapshotRepository)) {
            return false;
        }
        String this$security = this.getSecurity();
        String other$security = other.getSecurity();
        if (this$security == null ? other$security != null : !this$security.equals(other$security)) {
            return false;
        }
        String this$releaseName = this.getReleaseName();
        String other$releaseName = other.getReleaseName();
        if (this$releaseName == null ? other$releaseName != null : !this$releaseName.equals(other$releaseName)) {
            return false;
        }
        List<HelmDependency> this$dependencies = this.getDependencies();
        List<HelmDependency> other$dependencies = other.getDependencies();
        return !(this$dependencies == null ? other$dependencies != null : !((Object)this$dependencies).equals(other$dependencies));
    }

    protected boolean canEqual(Object other) {
        return other instanceof HelmConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isLintStrict() ? 79 : 97);
        result = result * 59 + (this.isLintQuiet() ? 79 : 97);
        result = result * 59 + (this.isDebug() ? 79 : 97);
        result = result * 59 + (this.isDependencyVerify() ? 79 : 97);
        result = result * 59 + (this.isDependencySkipRefresh() ? 79 : 97);
        result = result * 59 + (this.isInstallDependencyUpdate() ? 79 : 97);
        result = result * 59 + (this.isInstallWaitReady() ? 79 : 97);
        result = result * 59 + (this.isDisableOpenAPIValidation() ? 79 : 97);
        String $apiVersion = this.getApiVersion();
        result = result * 59 + ($apiVersion == null ? 43 : $apiVersion.hashCode());
        String $chart = this.getChart();
        result = result * 59 + ($chart == null ? 43 : $chart.hashCode());
        String $chartExtension = this.getChartExtension();
        result = result * 59 + ($chartExtension == null ? 43 : $chartExtension.hashCode());
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $home = this.getHome();
        result = result * 59 + ($home == null ? 43 : $home.hashCode());
        List<String> $sources = this.getSources();
        result = result * 59 + ($sources == null ? 43 : ((Object)$sources).hashCode());
        List<Maintainer> $maintainers = this.getMaintainers();
        result = result * 59 + ($maintainers == null ? 43 : ((Object)$maintainers).hashCode());
        String $icon = this.getIcon();
        result = result * 59 + ($icon == null ? 43 : $icon.hashCode());
        String $appVersion = this.getAppVersion();
        result = result * 59 + ($appVersion == null ? 43 : $appVersion.hashCode());
        List<String> $keywords = this.getKeywords();
        result = result * 59 + ($keywords == null ? 43 : ((Object)$keywords).hashCode());
        String $engine = this.getEngine();
        result = result * 59 + ($engine == null ? 43 : $engine.hashCode());
        List<File> $additionalFiles = this.getAdditionalFiles();
        result = result * 59 + ($additionalFiles == null ? 43 : ((Object)$additionalFiles).hashCode());
        List<Template> $parameterTemplates = this.getParameterTemplates();
        result = result * 59 + ($parameterTemplates == null ? 43 : ((Object)$parameterTemplates).hashCode());
        List<HelmParameter> $parameters = this.getParameters();
        result = result * 59 + ($parameters == null ? 43 : ((Object)$parameters).hashCode());
        List<HelmType> $types = this.getTypes();
        result = result * 59 + ($types == null ? 43 : ((Object)$types).hashCode());
        String $sourceDir = this.getSourceDir();
        result = result * 59 + ($sourceDir == null ? 43 : $sourceDir.hashCode());
        String $outputDir = this.getOutputDir();
        result = result * 59 + ($outputDir == null ? 43 : $outputDir.hashCode());
        String $tarballOutputDir = this.getTarballOutputDir();
        result = result * 59 + ($tarballOutputDir == null ? 43 : $tarballOutputDir.hashCode());
        String $tarFileClassifier = this.getTarFileClassifier();
        result = result * 59 + ($tarFileClassifier == null ? 43 : $tarFileClassifier.hashCode());
        List<GeneratedChartListener> $generatedChartListeners = this.getGeneratedChartListeners();
        result = result * 59 + ($generatedChartListeners == null ? 43 : ((Object)$generatedChartListeners).hashCode());
        HelmRepository $stableRepository = this.getStableRepository();
        result = result * 59 + ($stableRepository == null ? 43 : ((Object)$stableRepository).hashCode());
        HelmRepository $snapshotRepository = this.getSnapshotRepository();
        result = result * 59 + ($snapshotRepository == null ? 43 : ((Object)$snapshotRepository).hashCode());
        String $security = this.getSecurity();
        result = result * 59 + ($security == null ? 43 : $security.hashCode());
        String $releaseName = this.getReleaseName();
        result = result * 59 + ($releaseName == null ? 43 : $releaseName.hashCode());
        List<HelmDependency> $dependencies = this.getDependencies();
        result = result * 59 + ($dependencies == null ? 43 : ((Object)$dependencies).hashCode());
        return result;
    }

    public static class HelmConfigBuilder {
        private String apiVersion;
        private String chart;
        private String chartExtension;
        private String version;
        private String description;
        private String home;
        private List<String> sources;
        private List<Maintainer> maintainers;
        private String icon;
        private String appVersion;
        private List<String> keywords;
        private String engine;
        private List<File> additionalFiles;
        private List<Template> parameterTemplates;
        private List<HelmParameter> parameters;
        private List<HelmType> types;
        private String sourceDir;
        private String outputDir;
        private String tarballOutputDir;
        private String tarFileClassifier;
        private boolean generatedChartListeners$set;
        private List<GeneratedChartListener> generatedChartListeners$value;
        private HelmRepository stableRepository;
        private HelmRepository snapshotRepository;
        private String security;
        private boolean lintStrict;
        private boolean lintQuiet;
        private boolean debug;
        private boolean dependencyVerify;
        private boolean dependencySkipRefresh;
        private String releaseName;
        private boolean installDependencyUpdate;
        private boolean installWaitReady;
        private boolean disableOpenAPIValidation;
        private List<HelmDependency> dependencies;

        HelmConfigBuilder() {
        }

        public HelmConfigBuilder apiVersion(String apiVersion) {
            this.apiVersion = apiVersion;
            return this;
        }

        public HelmConfigBuilder chart(String chart) {
            this.chart = chart;
            return this;
        }

        public HelmConfigBuilder chartExtension(String chartExtension) {
            this.chartExtension = chartExtension;
            return this;
        }

        public HelmConfigBuilder version(String version) {
            this.version = version;
            return this;
        }

        public HelmConfigBuilder description(String description) {
            this.description = description;
            return this;
        }

        public HelmConfigBuilder home(String home) {
            this.home = home;
            return this;
        }

        public HelmConfigBuilder sources(List<String> sources) {
            this.sources = sources;
            return this;
        }

        public HelmConfigBuilder maintainers(List<Maintainer> maintainers) {
            this.maintainers = maintainers;
            return this;
        }

        public HelmConfigBuilder icon(String icon) {
            this.icon = icon;
            return this;
        }

        public HelmConfigBuilder appVersion(String appVersion) {
            this.appVersion = appVersion;
            return this;
        }

        public HelmConfigBuilder keywords(List<String> keywords) {
            this.keywords = keywords;
            return this;
        }

        public HelmConfigBuilder engine(String engine) {
            this.engine = engine;
            return this;
        }

        public HelmConfigBuilder additionalFiles(List<File> additionalFiles) {
            this.additionalFiles = additionalFiles;
            return this;
        }

        public HelmConfigBuilder parameterTemplates(List<Template> parameterTemplates) {
            this.parameterTemplates = parameterTemplates;
            return this;
        }

        public HelmConfigBuilder parameters(List<HelmParameter> parameters) {
            this.parameters = parameters;
            return this;
        }

        public HelmConfigBuilder types(List<HelmType> types) {
            this.types = types;
            return this;
        }

        public HelmConfigBuilder sourceDir(String sourceDir) {
            this.sourceDir = sourceDir;
            return this;
        }

        public HelmConfigBuilder outputDir(String outputDir) {
            this.outputDir = outputDir;
            return this;
        }

        public HelmConfigBuilder tarballOutputDir(String tarballOutputDir) {
            this.tarballOutputDir = tarballOutputDir;
            return this;
        }

        public HelmConfigBuilder tarFileClassifier(String tarFileClassifier) {
            this.tarFileClassifier = tarFileClassifier;
            return this;
        }

        public HelmConfigBuilder generatedChartListeners(List<GeneratedChartListener> generatedChartListeners) {
            this.generatedChartListeners$value = generatedChartListeners;
            this.generatedChartListeners$set = true;
            return this;
        }

        public HelmConfigBuilder stableRepository(HelmRepository stableRepository) {
            this.stableRepository = stableRepository;
            return this;
        }

        public HelmConfigBuilder snapshotRepository(HelmRepository snapshotRepository) {
            this.snapshotRepository = snapshotRepository;
            return this;
        }

        public HelmConfigBuilder security(String security) {
            this.security = security;
            return this;
        }

        public HelmConfigBuilder lintStrict(boolean lintStrict) {
            this.lintStrict = lintStrict;
            return this;
        }

        public HelmConfigBuilder lintQuiet(boolean lintQuiet) {
            this.lintQuiet = lintQuiet;
            return this;
        }

        public HelmConfigBuilder debug(boolean debug) {
            this.debug = debug;
            return this;
        }

        public HelmConfigBuilder dependencyVerify(boolean dependencyVerify) {
            this.dependencyVerify = dependencyVerify;
            return this;
        }

        public HelmConfigBuilder dependencySkipRefresh(boolean dependencySkipRefresh) {
            this.dependencySkipRefresh = dependencySkipRefresh;
            return this;
        }

        public HelmConfigBuilder releaseName(String releaseName) {
            this.releaseName = releaseName;
            return this;
        }

        public HelmConfigBuilder installDependencyUpdate(boolean installDependencyUpdate) {
            this.installDependencyUpdate = installDependencyUpdate;
            return this;
        }

        public HelmConfigBuilder installWaitReady(boolean installWaitReady) {
            this.installWaitReady = installWaitReady;
            return this;
        }

        public HelmConfigBuilder disableOpenAPIValidation(boolean disableOpenAPIValidation) {
            this.disableOpenAPIValidation = disableOpenAPIValidation;
            return this;
        }

        @JsonProperty(value="dependencies")
        public HelmConfigBuilder dependencies(List<HelmDependency> dependencies) {
            this.dependencies = dependencies;
            return this;
        }

        public HelmConfig build() {
            List generatedChartListeners$value = this.generatedChartListeners$value;
            if (!this.generatedChartListeners$set) {
                generatedChartListeners$value = HelmConfig.$default$generatedChartListeners();
            }
            return new HelmConfig(this.apiVersion, this.chart, this.chartExtension, this.version, this.description, this.home, this.sources, this.maintainers, this.icon, this.appVersion, this.keywords, this.engine, this.additionalFiles, this.parameterTemplates, this.parameters, this.types, this.sourceDir, this.outputDir, this.tarballOutputDir, this.tarFileClassifier, generatedChartListeners$value, this.stableRepository, this.snapshotRepository, this.security, this.lintStrict, this.lintQuiet, this.debug, this.dependencyVerify, this.dependencySkipRefresh, this.releaseName, this.installDependencyUpdate, this.installWaitReady, this.disableOpenAPIValidation, this.dependencies);
        }

        public String toString() {
            return "HelmConfig.HelmConfigBuilder(apiVersion=" + this.apiVersion + ", chart=" + this.chart + ", chartExtension=" + this.chartExtension + ", version=" + this.version + ", description=" + this.description + ", home=" + this.home + ", sources=" + this.sources + ", maintainers=" + this.maintainers + ", icon=" + this.icon + ", appVersion=" + this.appVersion + ", keywords=" + this.keywords + ", engine=" + this.engine + ", additionalFiles=" + this.additionalFiles + ", parameterTemplates=" + this.parameterTemplates + ", parameters=" + this.parameters + ", types=" + this.types + ", sourceDir=" + this.sourceDir + ", outputDir=" + this.outputDir + ", tarballOutputDir=" + this.tarballOutputDir + ", tarFileClassifier=" + this.tarFileClassifier + ", generatedChartListeners$value=" + this.generatedChartListeners$value + ", stableRepository=" + this.stableRepository + ", snapshotRepository=" + this.snapshotRepository + ", security=" + this.security + ", lintStrict=" + this.lintStrict + ", lintQuiet=" + this.lintQuiet + ", debug=" + this.debug + ", dependencyVerify=" + this.dependencyVerify + ", dependencySkipRefresh=" + this.dependencySkipRefresh + ", releaseName=" + this.releaseName + ", installDependencyUpdate=" + this.installDependencyUpdate + ", installWaitReady=" + this.installWaitReady + ", disableOpenAPIValidation=" + this.disableOpenAPIValidation + ", dependencies=" + this.dependencies + ")";
        }
    }

    public static enum HelmType {
        KUBERNETES("helm", "kubernetes", "kubernetes", "Kubernetes"),
        OPENSHIFT("helmshift", "openshift", "openshift", "OpenShift");

        private final String classifier;
        private final String sourceDir;
        private final String outputDir;
        private final String description;

        private HelmType(String classifier, String sourceDir, String outputDir, String description) {
            this.classifier = classifier;
            this.sourceDir = sourceDir;
            this.outputDir = outputDir;
            this.description = description;
        }

        public static List<HelmType> parseString(String types) {
            return Optional.ofNullable(types).map(t -> t.split(",")).map(Stream::of).map(s -> s.filter(StringUtils::isNotBlank).map(String::toUpperCase).map(HelmType::valueOf).collect(Collectors.toList())).orElse(Collections.emptyList());
        }

        public String getClassifier() {
            return this.classifier;
        }

        public String getSourceDir() {
            return this.sourceDir;
        }

        public String getOutputDir() {
            return this.outputDir;
        }

        public String getDescription() {
            return this.description;
        }
    }
}

