/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.resource.helm;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KubernetesList;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import io.fabric8.openshift.api.model.Template;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jkube.kit.common.JavaProject;
import org.eclipse.jkube.kit.common.KitLogger;
import org.eclipse.jkube.kit.common.Maintainer;
import org.eclipse.jkube.kit.common.RegistryServerConfiguration;
import org.eclipse.jkube.kit.common.util.JKubeProjectUtil;
import org.eclipse.jkube.kit.common.util.KubernetesHelper;
import org.eclipse.jkube.kit.common.util.Serialization;
import org.eclipse.jkube.kit.common.util.YamlUtil;
import org.eclipse.jkube.kit.config.resource.GroupArtifactVersion;
import org.eclipse.jkube.kit.config.resource.JKubeAnnotations;
import org.eclipse.jkube.kit.resource.helm.HelmConfig;
import org.eclipse.jkube.kit.resource.helm.HelmRepository;

public class HelmServiceUtil {
    private static final String PROPERTY_API_VERSION = "jkube.helm.apiVersion";
    private static final String DEFAULT_API_VERSION = "v1";
    private static final String PROPERTY_ICON = "jkube.helm.icon";
    private static final String PROPERTY_APP_VERSION = "jkube.helm.appVersion";
    private static final String PROPERTY_TYPE = "jkube.helm.type";
    private static final String PROPERTY_CHART = "jkube.helm.chart";
    private static final String PROPERTY_CHART_EXTENSION = "jkube.helm.chartExtension";
    private static final String DEFAULT_CHART_EXTENSION = "tar.gz";
    private static final String PROPERTY_VERSION = "jkube.helm.version";
    private static final String PROPERTY_DESCRIPTION = "jkube.helm.description";
    private static final String PROPERTY_SOURCE_DIR = "jkube.helm.sourceDir";
    private static final String PROPERTY_OUTPUT_DIR = "jkube.helm.outputDir";
    private static final String PROPERTY_TARBALL_OUTPUT_DIR = "jkube.helm.tarballOutputDir";
    private static final String PROPERTY_TARBALL_CLASSIFIER = "jkube.helm.tarFileClassifier";
    private static final String PROPERTY_HOME = "jkube.helm.home";
    protected static final String PROPERTY_UPLOAD_REPO_NAME = "jkube.helm.%s.name";
    protected static final String PROPERTY_UPLOAD_REPO_URL = "jkube.helm.%s.url";
    protected static final String PROPERTY_UPLOAD_REPO_USERNAME = "jkube.helm.%s.username";
    protected static final String PROPERTY_UPLOAD_REPO_PASSWORD = "jkube.helm.%s.password";
    protected static final String PROPERTY_UPLOAD_REPO_TYPE = "jkube.helm.%s.type";
    protected static final String STABLE_REPOSITORY = "stableRepository";
    protected static final String SNAPSHOT_REPOSITORY = "snapshotRepository";
    protected static final String PROPERTY_SECURITY = "jkube.helm.security";
    protected static final String DEFAULT_SECURITY = "~/.m2/settings-security.xml";
    protected static final String PROPERTY_HELM_LINT_STRICT = "jkube.helm.lint.strict";
    protected static final String PROPERTY_HELM_LINT_QUIET = "jkube.helm.lint.quiet";
    protected static final String PROPERTY_HELM_DEBUG = "jkube.helm.debug";
    protected static final String PROPERTY_HELM_DEPENDENCY_VERIFY = "jkube.helm.dependencyVerify";
    protected static final String PROPERTY_HELM_DEPENDENCY_SKIP_REFRESH = "jkube.helm.dependencySkipRefresh";
    protected static final String PROPERTY_HELM_RELEASE_NAME = "jkube.helm.release.name";
    protected static final String PROPERTY_HELM_INSTALL_DEPENDENCY_UPDATE = "jkube.helm.install.dependencyUpdate";
    protected static final String PROPERTY_HELM_INSTALL_WAIT_READY = "jkube.helm.install.waitReady";
    protected static final String PROPERTY_HELM_DISABLE_OPENAPI_VALIDATION = "jkube.helm.disableOpenAPIValidation";

    private HelmServiceUtil() {
    }

    public static HelmConfig.HelmConfigBuilder initHelmConfig(HelmConfig.HelmType defaultHelmType, JavaProject project, File template, HelmConfig original) throws IOException {
        HelmConfig helmConfig = original == null ? new HelmConfig() : original;
        helmConfig.setApiVersion(HelmServiceUtil.resolveFromPropertyOrDefault(PROPERTY_API_VERSION, project, helmConfig::getApiVersion, () -> DEFAULT_API_VERSION));
        helmConfig.setChart(HelmServiceUtil.resolveFromPropertyOrDefault(PROPERTY_CHART, project, helmConfig::getChart, () -> ((JavaProject)project).getArtifactId()));
        helmConfig.setChartExtension(HelmServiceUtil.resolveFromPropertyOrDefault(PROPERTY_CHART_EXTENSION, project, helmConfig::getChartExtension, () -> DEFAULT_CHART_EXTENSION));
        helmConfig.setVersion(HelmServiceUtil.resolveFromPropertyOrDefault(PROPERTY_VERSION, project, helmConfig::getVersion, () -> ((JavaProject)project).getVersion()));
        helmConfig.setDescription(HelmServiceUtil.resolveFromPropertyOrDefault(PROPERTY_DESCRIPTION, project, helmConfig::getDescription, () -> ((JavaProject)project).getDescription()));
        helmConfig.setHome(HelmServiceUtil.resolveFromPropertyOrDefault(PROPERTY_HOME, project, helmConfig::getHome, () -> ((JavaProject)project).getUrl()));
        if (helmConfig.getSources() == null) {
            helmConfig.setSources(project.getScmUrl() != null ? Collections.singletonList(project.getScmUrl()) : Collections.emptyList());
        }
        if (helmConfig.getMaintainers() == null && project.getMaintainers() != null) {
            helmConfig.setMaintainers(project.getMaintainers().stream().filter(m -> StringUtils.isNotBlank((CharSequence)m.getName()) || StringUtils.isNotBlank((CharSequence)m.getEmail())).map(m -> new Maintainer(m.getName(), m.getEmail())).collect(Collectors.toList()));
        }
        helmConfig.setAdditionalFiles(HelmServiceUtil.getAdditionalFiles(helmConfig, project));
        if (helmConfig.getParameterTemplates() == null) {
            helmConfig.setParameterTemplates(HelmServiceUtil.findTemplates(template));
        }
        helmConfig.setTypes(HelmServiceUtil.resolveHelmTypes(defaultHelmType, project));
        helmConfig.setSourceDir(HelmServiceUtil.resolveFromPropertyOrDefault(PROPERTY_SOURCE_DIR, project, helmConfig::getSourceDir, () -> FilenameUtils.separatorsToSystem((String)String.format("%s/META-INF/jkube/", project.getOutputDirectory()))));
        helmConfig.setOutputDir(HelmServiceUtil.resolveFromPropertyOrDefault(PROPERTY_OUTPUT_DIR, project, helmConfig::getOutputDir, () -> FilenameUtils.separatorsToSystem((String)String.format("%s/jkube/helm/%s", project.getBuildDirectory(), helmConfig.getChart()))));
        helmConfig.setIcon(HelmServiceUtil.resolveFromPropertyOrDefault(PROPERTY_ICON, project, helmConfig::getIcon, () -> HelmServiceUtil.findIconURL(new File(helmConfig.getSourceDir()), helmConfig.getTypes())));
        helmConfig.setAppVersion(HelmServiceUtil.resolveFromPropertyOrDefault(PROPERTY_APP_VERSION, project, helmConfig::getAppVersion, () -> ((JavaProject)project).getVersion()));
        helmConfig.setTarFileClassifier(HelmServiceUtil.resolveFromPropertyOrDefault(PROPERTY_TARBALL_CLASSIFIER, project, helmConfig::getTarFileClassifier, () -> ""));
        helmConfig.setTarballOutputDir(HelmServiceUtil.resolveFromPropertyOrDefault(PROPERTY_TARBALL_OUTPUT_DIR, project, helmConfig::getTarballOutputDir, helmConfig::getOutputDir));
        helmConfig.setLintStrict(HelmServiceUtil.resolveBooleanFromPropertyOrDefault(PROPERTY_HELM_LINT_STRICT, project, helmConfig::isLintStrict));
        helmConfig.setLintQuiet(HelmServiceUtil.resolveBooleanFromPropertyOrDefault(PROPERTY_HELM_LINT_QUIET, project, helmConfig::isLintQuiet));
        helmConfig.setDebug(HelmServiceUtil.resolveBooleanFromPropertyOrDefault(PROPERTY_HELM_DEBUG, project, helmConfig::isDebug));
        helmConfig.setDependencyVerify(HelmServiceUtil.resolveBooleanFromPropertyOrDefault(PROPERTY_HELM_DEPENDENCY_VERIFY, project, helmConfig::isDependencyVerify));
        helmConfig.setDependencySkipRefresh(HelmServiceUtil.resolveBooleanFromPropertyOrDefault(PROPERTY_HELM_DEPENDENCY_SKIP_REFRESH, project, helmConfig::isDependencySkipRefresh));
        helmConfig.setReleaseName(HelmServiceUtil.resolveFromPropertyOrDefault(PROPERTY_HELM_RELEASE_NAME, project, helmConfig::getReleaseName, () -> JKubeProjectUtil.createDefaultResourceName((String)new GroupArtifactVersion(project.getGroupId(), project.getArtifactId(), project.getVersion()).getSanitizedArtifactId(), (String[])new String[0])));
        helmConfig.setInstallDependencyUpdate(original == null || original.isInstallDependencyUpdate());
        helmConfig.setInstallDependencyUpdate(HelmServiceUtil.resolveBooleanFromPropertyOrDefault(PROPERTY_HELM_INSTALL_DEPENDENCY_UPDATE, project, helmConfig::isInstallDependencyUpdate));
        helmConfig.setInstallWaitReady(HelmServiceUtil.resolveBooleanFromPropertyOrDefault(PROPERTY_HELM_INSTALL_WAIT_READY, project, helmConfig::isInstallWaitReady));
        helmConfig.setDisableOpenAPIValidation(HelmServiceUtil.resolveBooleanFromPropertyOrDefault(PROPERTY_HELM_DISABLE_OPENAPI_VALIDATION, project, helmConfig::isDisableOpenAPIValidation));
        return helmConfig.toBuilder();
    }

    public static void initHelmPushConfig(HelmConfig helmConfig, JavaProject project) {
        helmConfig.setStableRepository(HelmServiceUtil.initHelmRepository(helmConfig.getStableRepository(), project, STABLE_REPOSITORY));
        helmConfig.setSnapshotRepository(HelmServiceUtil.initHelmRepository(helmConfig.getSnapshotRepository(), project, SNAPSHOT_REPOSITORY));
        helmConfig.setSecurity(HelmServiceUtil.resolveFromPropertyOrDefault(PROPERTY_SECURITY, project, helmConfig::getSecurity, () -> DEFAULT_SECURITY));
    }

    static HelmRepository initHelmRepository(HelmRepository helmRepository, JavaProject project, String repositoryType) {
        HelmRepository resolvedHelmRepository = helmRepository;
        if (helmRepository == null) {
            resolvedHelmRepository = new HelmRepository();
        }
        resolvedHelmRepository.setType(HelmServiceUtil.resolveFromPropertyOrDefault(String.format(PROPERTY_UPLOAD_REPO_TYPE, repositoryType), project, resolvedHelmRepository::getTypeAsString, null));
        resolvedHelmRepository.setName(HelmServiceUtil.resolveFromPropertyOrDefault(String.format(PROPERTY_UPLOAD_REPO_NAME, repositoryType), project, resolvedHelmRepository::getName, null));
        resolvedHelmRepository.setUrl(HelmServiceUtil.resolveFromPropertyOrDefault(String.format(PROPERTY_UPLOAD_REPO_URL, repositoryType), project, resolvedHelmRepository::getUrl, null));
        resolvedHelmRepository.setUsername(HelmServiceUtil.resolveFromPropertyOrDefault(String.format(PROPERTY_UPLOAD_REPO_USERNAME, repositoryType), project, resolvedHelmRepository::getUsername, null));
        resolvedHelmRepository.setPassword(HelmServiceUtil.resolveFromPropertyOrDefault(String.format(PROPERTY_UPLOAD_REPO_PASSWORD, repositoryType), project, resolvedHelmRepository::getPassword, null));
        return resolvedHelmRepository;
    }

    static List<HelmConfig.HelmType> resolveHelmTypes(HelmConfig.HelmType defaultHelmType, JavaProject project) {
        List helmTypes = Optional.ofNullable(JKubeProjectUtil.getProperty((String)PROPERTY_TYPE, (JavaProject)project)).filter(StringUtils::isNotBlank).map(types -> StringUtils.split((String)types, (String)",")).map(Stream::of).map(s -> s.map(prop -> HelmConfig.HelmType.valueOf(prop.trim().toUpperCase())).collect(Collectors.toList())).orElse(null);
        if (helmTypes == null || helmTypes.isEmpty()) {
            return Collections.singletonList(defaultHelmType);
        }
        return helmTypes;
    }

    static String resolveFromPropertyOrDefault(String property, JavaProject project, Supplier<String> getter, Supplier<String> defaultValue) {
        return Optional.ofNullable(JKubeProjectUtil.getProperty((String)property, (JavaProject)project)).filter(StringUtils::isNotBlank).orElse(Optional.ofNullable(getter.get()).filter(StringUtils::isNotBlank).orElseGet(defaultValue == null ? () -> null : defaultValue));
    }

    static boolean resolveBooleanFromPropertyOrDefault(String property, JavaProject project, BooleanSupplier getter) {
        return Optional.ofNullable(JKubeProjectUtil.getProperty((String)property, (JavaProject)project)).filter(StringUtils::isNotBlank).map(Boolean::parseBoolean).orElse(getter.getAsBoolean());
    }

    static List<File> getAdditionalFiles(HelmConfig helm, JavaProject project) {
        ArrayList<File> additionalFiles = new ArrayList<File>();
        if (helm.getAdditionalFiles() != null) {
            additionalFiles.addAll(helm.getAdditionalFiles());
        }
        HelmServiceUtil.firstProjectFile("README", project).ifPresent(additionalFiles::add);
        HelmServiceUtil.firstProjectFile("LICENSE", project).ifPresent(additionalFiles::add);
        HelmServiceUtil.firstProjectFile("values.schema.json", project).ifPresent(additionalFiles::add);
        return additionalFiles;
    }

    static Optional<File> firstProjectFile(String fileName, JavaProject project) {
        FilenameFilter filter = (dir, name) -> {
            String lower = name.toLowerCase(Locale.ENGLISH);
            return lower.equalsIgnoreCase(fileName) || lower.startsWith(fileName.toLowerCase() + ".");
        };
        return Optional.ofNullable(project.getBaseDirectory().listFiles(filter)).filter(files -> ((File[])files).length > 0).map(files -> files[0]);
    }

    static String findIconURL(File directory, Collection<HelmConfig.HelmType> types) {
        String answer = null;
        for (HelmConfig.HelmType type : types) {
            for (File yaml : YamlUtil.listYamls((File)new File(directory, type.getSourceDir()))) {
                KubernetesResource dto;
                try {
                    dto = (KubernetesResource)Serialization.unmarshal((File)yaml);
                }
                catch (IOException e) {
                    throw new IllegalStateException("Failed to load kubernetes YAML " + yaml + ". " + e, e);
                }
                if (dto instanceof HasMetadata) {
                    answer = HelmServiceUtil.getJKubeIconUrlFromAnnotations(KubernetesHelper.getOrCreateAnnotations((HasMetadata)((HasMetadata)dto)));
                    continue;
                }
                if (!StringUtils.isBlank(answer) || !(dto instanceof KubernetesList)) continue;
                answer = HelmServiceUtil.extractIconUrlAnnotationFromKubernetesList((KubernetesList)dto);
            }
        }
        return answer;
    }

    private static String extractIconUrlAnnotationFromKubernetesList(KubernetesList list) {
        if (list.getItems() != null) {
            for (HasMetadata item : list.getItems()) {
                String url = HelmServiceUtil.getJKubeIconUrlFromAnnotations(KubernetesHelper.getOrCreateAnnotations((HasMetadata)item));
                if (!StringUtils.isNotBlank((CharSequence)url)) continue;
                return url;
            }
        }
        return null;
    }

    static List<Template> findTemplates(File templateDir) throws IOException {
        ArrayList<Template> ret = new ArrayList<Template>();
        File[] sourceFiles = templateDir != null && templateDir.isDirectory() ? templateDir.listFiles((dir, filename) -> filename.toLowerCase(Locale.ROOT).endsWith("-template.yml") || filename.toLowerCase(Locale.ROOT).endsWith("-template.yaml")) : (templateDir != null ? new File[]{templateDir} : new File[]{});
        for (File sourceFile : Objects.requireNonNull(sourceFiles, "No template files found in the provided directory")) {
            KubernetesResource dto = (KubernetesResource)Serialization.unmarshal((File)sourceFile);
            if (dto instanceof Template) {
                ret.add((Template)dto);
                continue;
            }
            if (!(dto instanceof KubernetesList)) continue;
            Optional.ofNullable(((KubernetesList)dto).getItems()).map(Collection::stream).map(items -> items.filter(Template.class::isInstance).map(Template.class::cast).collect(Collectors.toList())).ifPresent(ret::addAll);
        }
        return ret;
    }

    static HelmRepository selectHelmRepository(HelmConfig helmConfig) {
        if (helmConfig.getVersion() != null && helmConfig.getVersion().endsWith("-SNAPSHOT")) {
            return helmConfig.getSnapshotRepository();
        }
        return helmConfig.getStableRepository();
    }

    static boolean isRepositoryValid(HelmRepository repository) {
        return repository != null && repository.getType() != null && StringUtils.isNotBlank((CharSequence)repository.getName()) && StringUtils.isNotBlank((CharSequence)repository.getUrl());
    }

    static void setAuthentication(HelmRepository repository, KitLogger logger, List<RegistryServerConfiguration> registryServerConfigurations, UnaryOperator<String> passwordDecrypter) {
        String id = repository.getName();
        String REPO = "Repo ";
        if (repository.getUsername() != null) {
            if (repository.getPassword() == null) {
                throw new IllegalArgumentException("Repo " + id + " has a username but no password defined.");
            }
            logger.debug("Repo " + id + " has credentials defined, skip searching in server list.", new Object[0]);
        } else {
            RegistryServerConfiguration server = registryServerConfigurations.stream().filter(r -> r.getId().equals(id)).findAny().orElse(null);
            if (server == null) {
                throw new IllegalArgumentException("No credentials found for " + id + " in configuration or settings.xml server list.");
            }
            logger.debug("Use credentials from server list for " + id + ".", new Object[0]);
            if (server.getUsername() == null || server.getPassword() == null) {
                throw new IllegalArgumentException("Repo " + id + " was found in server list but has no username/password.");
            }
            repository.setUsername(server.getUsername());
            repository.setPassword((String)passwordDecrypter.apply(server.getPassword()));
        }
    }

    private static String getJKubeIconUrlFromAnnotations(Map<String, String> annotations) {
        if (annotations.containsKey(JKubeAnnotations.ICON_URL.value(true))) {
            return annotations.get(JKubeAnnotations.ICON_URL.value(true));
        }
        if (annotations.containsKey(JKubeAnnotations.ICON_URL.value())) {
            return annotations.get(JKubeAnnotations.ICON_URL.value());
        }
        return null;
    }
}

