/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.resource.helm;

import io.fabric8.kubernetes.client.RequestConfigBuilder;
import io.fabric8.kubernetes.client.http.HttpClient;
import io.fabric8.kubernetes.client.http.HttpRequest;
import io.fabric8.kubernetes.client.http.HttpResponse;
import io.fabric8.kubernetes.client.utils.HttpClientUtils;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jkube.kit.common.util.AsyncUtil;
import org.eclipse.jkube.kit.common.util.Base64Util;
import org.eclipse.jkube.kit.resource.helm.BadUploadException;
import org.eclipse.jkube.kit.resource.helm.HelmRepository;
import org.eclipse.jkube.kit.resource.helm.HelmUploader;

public abstract class StandardRepositoryUploader
implements HelmUploader {
    private final String method;
    private final HelmRepository.HelmRepoType type;
    private static final long HELM_UPLOAD_TIMEOUT_MINUTES = 30L;

    protected StandardRepositoryUploader(String method, HelmRepository.HelmRepoType type) {
        this.method = method;
        this.type = type;
    }

    public abstract String url(File var1, HelmRepository var2);

    @Override
    public HelmRepository.HelmRepoType getType() {
        return this.type;
    }

    @Override
    public void uploadSingle(File file, HelmRepository repository) throws IOException, BadUploadException {
        String uploadUrl = this.url(file, repository);
        try (HttpClient httpClient = HttpClientUtils.getHttpClientFactory().newBuilder().tag((Object)((RequestConfigBuilder)new RequestConfigBuilder().withRequestRetryBackoffLimit(Integer.valueOf(0))).build()).build();){
            HttpRequest httpRequest = httpClient.newHttpRequestBuilder().method(this.method, "application/gzip", Files.newInputStream(file.toPath(), new OpenOption[0]), file.length()).header("Authorization", String.format("Basic %s", Base64Util.encodeToString((String)(repository.getUsername() + ":" + repository.getPassword())))).uri(uploadUrl).build();
            HttpResponse response = (HttpResponse)AsyncUtil.get((CompletableFuture)httpClient.sendAsync(httpRequest, byte[].class), (Duration)Duration.ofMinutes(30L));
            this.handleHttpResponse((HttpResponse<byte[]>)response);
        }
    }

    private void handleHttpResponse(HttpResponse<byte[]> response) throws BadUploadException {
        if (!response.isSuccessful()) {
            String responseStr = response.body() != null ? new String((byte[])response.body()) : (StringUtils.isNotBlank((CharSequence)response.message()) ? response.message() : "No details provided");
            throw new BadUploadException(responseStr);
        }
    }

    protected String formatRepositoryURL(File file, HelmRepository repository) {
        return String.format("%s%s", StringUtils.appendIfMissing((String)repository.getUrl(), (CharSequence)"/", (CharSequence[])new CharSequence[0]), file.getName());
    }
}

