/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.resource.helm.oci;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.input.BoundedInputStream;

public class OCIManifestLayer {
    private String mediaType;
    private String digest;
    private long size;

    public static OCIManifestLayer from(BoundedInputStream blobStream) throws IOException {
        blobStream.mark(Integer.MAX_VALUE);
        String digest = "sha256:" + DigestUtils.sha256Hex((InputStream)blobStream);
        long size = blobStream.getCount();
        blobStream.reset();
        return OCIManifestLayer.builder().digest(digest).size(size).build();
    }

    public static OCIManifestLayerBuilder builder() {
        return new OCIManifestLayerBuilder();
    }

    public OCIManifestLayerBuilder toBuilder() {
        return new OCIManifestLayerBuilder().mediaType(this.mediaType).digest(this.digest).size(this.size);
    }

    public OCIManifestLayer(String mediaType, String digest, long size) {
        this.mediaType = mediaType;
        this.digest = digest;
        this.size = size;
    }

    public OCIManifestLayer() {
    }

    public String getMediaType() {
        return this.mediaType;
    }

    public String getDigest() {
        return this.digest;
    }

    public long getSize() {
        return this.size;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OCIManifestLayer)) {
            return false;
        }
        OCIManifestLayer other = (OCIManifestLayer)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getSize() != other.getSize()) {
            return false;
        }
        String this$mediaType = this.getMediaType();
        String other$mediaType = other.getMediaType();
        if (this$mediaType == null ? other$mediaType != null : !this$mediaType.equals(other$mediaType)) {
            return false;
        }
        String this$digest = this.getDigest();
        String other$digest = other.getDigest();
        return !(this$digest == null ? other$digest != null : !this$digest.equals(other$digest));
    }

    protected boolean canEqual(Object other) {
        return other instanceof OCIManifestLayer;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $size = this.getSize();
        result = result * 59 + (int)($size >>> 32 ^ $size);
        String $mediaType = this.getMediaType();
        result = result * 59 + ($mediaType == null ? 43 : $mediaType.hashCode());
        String $digest = this.getDigest();
        result = result * 59 + ($digest == null ? 43 : $digest.hashCode());
        return result;
    }

    public static class OCIManifestLayerBuilder {
        private String mediaType;
        private String digest;
        private long size;

        OCIManifestLayerBuilder() {
        }

        public OCIManifestLayerBuilder mediaType(String mediaType) {
            this.mediaType = mediaType;
            return this;
        }

        public OCIManifestLayerBuilder digest(String digest) {
            this.digest = digest;
            return this;
        }

        public OCIManifestLayerBuilder size(long size) {
            this.size = size;
            return this;
        }

        public OCIManifestLayer build() {
            return new OCIManifestLayer(this.mediaType, this.digest, this.size);
        }

        public String toString() {
            return "OCIManifestLayer.OCIManifestLayerBuilder(mediaType=" + this.mediaType + ", digest=" + this.digest + ", size=" + this.size + ")";
        }
    }
}

