/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.resource.helm;

import java.util.stream.Stream;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;

public class HelmParameter {
    private static final String GOLANG_EXPRESSION_REGEX = "\\{\\{.+}}";
    private boolean required;
    private String name;
    private Object value;

    boolean isString() {
        return this.value instanceof String;
    }

    boolean isGolangExpression() {
        return this.isString() && Stream.of(this.value.toString().split("\r?\n")).filter(StringUtils::isNotBlank).allMatch(s -> s.trim().matches(GOLANG_EXPRESSION_REGEX));
    }

    String toExpression() {
        if (this.isGolangExpression()) {
            return StringUtils.trimToEmpty((String)this.getValue().toString());
        }
        String requiredExpression = this.isRequired() ? "required \"A valid .Values." + this.getName() + " entry required!\" " : "";
        return "{{ " + requiredExpression + ".Values." + this.getName() + " }}";
    }

    @Generated
    public static HelmParameterBuilder builder() {
        return new HelmParameterBuilder();
    }

    @Generated
    public HelmParameterBuilder toBuilder() {
        return new HelmParameterBuilder().required(this.required).name(this.name).value(this.value);
    }

    @Generated
    public HelmParameter(boolean required, String name, Object value) {
        this.required = required;
        this.name = name;
        this.value = value;
    }

    @Generated
    public HelmParameter() {
    }

    @Generated
    public boolean isRequired() {
        return this.required;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public Object getValue() {
        return this.value;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HelmParameter)) {
            return false;
        }
        HelmParameter other = (HelmParameter)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isRequired() != other.isRequired()) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        Object this$value = this.getValue();
        Object other$value = other.getValue();
        return !(this$value == null ? other$value != null : !this$value.equals(other$value));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof HelmParameter;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isRequired() ? 79 : 97);
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        Object $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "HelmParameter(required=" + this.isRequired() + ", name=" + this.getName() + ", value=" + this.getValue() + ")";
    }

    @Generated
    public static class HelmParameterBuilder {
        @Generated
        private boolean required;
        @Generated
        private String name;
        @Generated
        private Object value;

        @Generated
        HelmParameterBuilder() {
        }

        @Generated
        public HelmParameterBuilder required(boolean required) {
            this.required = required;
            return this;
        }

        @Generated
        public HelmParameterBuilder name(String name) {
            this.name = name;
            return this;
        }

        @Generated
        public HelmParameterBuilder value(Object value) {
            this.value = value;
            return this;
        }

        @Generated
        public HelmParameter build() {
            return new HelmParameter(this.required, this.name, this.value);
        }

        @Generated
        public String toString() {
            return "HelmParameter.HelmParameterBuilder(required=" + this.required + ", name=" + this.name + ", value=" + this.value + ")";
        }
    }
}

