/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.resource.helm;

import java.util.Optional;
import lombok.Generated;

public class HelmRepository {
    private String name;
    private String url;
    private String username;
    private String password;
    private HelmRepoType type;

    public String getTypeAsString() {
        return Optional.ofNullable(this.type).map(Enum::toString).orElse(null);
    }

    public void setType(String type) {
        this.type = HelmRepoType.parseString(type);
    }

    public String toString() {
        return "[" + this.name + " / " + this.url + "]";
    }

    @Generated
    public static HelmRepositoryBuilder builder() {
        return new HelmRepositoryBuilder();
    }

    @Generated
    public HelmRepositoryBuilder toBuilder() {
        return new HelmRepositoryBuilder().name(this.name).url(this.url).username(this.username).password(this.password).type(this.type);
    }

    @Generated
    public HelmRepository(String name, String url, String username, String password, HelmRepoType type) {
        this.name = name;
        this.url = url;
        this.username = username;
        this.password = password;
        this.type = type;
    }

    @Generated
    public HelmRepository() {
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getUrl() {
        return this.url;
    }

    @Generated
    public String getUsername() {
        return this.username;
    }

    @Generated
    public String getPassword() {
        return this.password;
    }

    @Generated
    public HelmRepoType getType() {
        return this.type;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setUrl(String url) {
        this.url = url;
    }

    @Generated
    public void setUsername(String username) {
        this.username = username;
    }

    @Generated
    public void setPassword(String password) {
        this.password = password;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HelmRepository)) {
            return false;
        }
        HelmRepository other = (HelmRepository)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
            return false;
        }
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
            return false;
        }
        HelmRepoType this$type = this.getType();
        HelmRepoType other$type = other.getType();
        return !(this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof HelmRepository;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        String $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        HelmRepoType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        return result;
    }

    @Generated
    public static class HelmRepositoryBuilder {
        @Generated
        private String name;
        @Generated
        private String url;
        @Generated
        private String username;
        @Generated
        private String password;
        @Generated
        private HelmRepoType type;

        @Generated
        HelmRepositoryBuilder() {
        }

        @Generated
        public HelmRepositoryBuilder name(String name) {
            this.name = name;
            return this;
        }

        @Generated
        public HelmRepositoryBuilder url(String url) {
            this.url = url;
            return this;
        }

        @Generated
        public HelmRepositoryBuilder username(String username) {
            this.username = username;
            return this;
        }

        @Generated
        public HelmRepositoryBuilder password(String password) {
            this.password = password;
            return this;
        }

        @Generated
        public HelmRepositoryBuilder type(HelmRepoType type) {
            this.type = type;
            return this;
        }

        @Generated
        public HelmRepository build() {
            return new HelmRepository(this.name, this.url, this.username, this.password, this.type);
        }

        @Generated
        public String toString() {
            return "HelmRepository.HelmRepositoryBuilder(name=" + this.name + ", url=" + this.url + ", username=" + this.username + ", password=" + this.password + ", type=" + (Object)((Object)this.type) + ")";
        }
    }

    public static enum HelmRepoType {
        CHARTMUSEUM,
        ARTIFACTORY,
        NEXUS,
        OCI;


        public static HelmRepoType parseString(String repoType) {
            return Optional.ofNullable(repoType).map(String::toUpperCase).map(HelmRepoType::valueOf).orElse(null);
        }
    }
}

