/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.resource.helm.oci;

import java.io.IOException;
import java.io.InputStream;
import lombok.Generated;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.input.BoundedInputStream;

public class OCIManifestLayer {
    private String mediaType;
    private String digest;
    private long size;

    public static OCIManifestLayer from(BoundedInputStream blobStream) throws IOException {
        blobStream.mark(Integer.MAX_VALUE);
        String digest = "sha256:" + DigestUtils.sha256Hex((InputStream)blobStream);
        long size = blobStream.getCount();
        blobStream.reset();
        return OCIManifestLayer.builder().digest(digest).size(size).build();
    }

    @Generated
    public static OCIManifestLayerBuilder builder() {
        return new OCIManifestLayerBuilder();
    }

    @Generated
    public OCIManifestLayerBuilder toBuilder() {
        return new OCIManifestLayerBuilder().mediaType(this.mediaType).digest(this.digest).size(this.size);
    }

    @Generated
    public OCIManifestLayer(String mediaType, String digest, long size) {
        this.mediaType = mediaType;
        this.digest = digest;
        this.size = size;
    }

    @Generated
    public OCIManifestLayer() {
    }

    @Generated
    public String getMediaType() {
        return this.mediaType;
    }

    @Generated
    public String getDigest() {
        return this.digest;
    }

    @Generated
    public long getSize() {
        return this.size;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OCIManifestLayer)) {
            return false;
        }
        OCIManifestLayer other = (OCIManifestLayer)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getSize() != other.getSize()) {
            return false;
        }
        String this$mediaType = this.getMediaType();
        String other$mediaType = other.getMediaType();
        if (this$mediaType == null ? other$mediaType != null : !this$mediaType.equals(other$mediaType)) {
            return false;
        }
        String this$digest = this.getDigest();
        String other$digest = other.getDigest();
        return !(this$digest == null ? other$digest != null : !this$digest.equals(other$digest));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof OCIManifestLayer;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $size = this.getSize();
        result = result * 59 + (int)($size >>> 32 ^ $size);
        String $mediaType = this.getMediaType();
        result = result * 59 + ($mediaType == null ? 43 : $mediaType.hashCode());
        String $digest = this.getDigest();
        result = result * 59 + ($digest == null ? 43 : $digest.hashCode());
        return result;
    }

    @Generated
    public static class OCIManifestLayerBuilder {
        @Generated
        private String mediaType;
        @Generated
        private String digest;
        @Generated
        private long size;

        @Generated
        OCIManifestLayerBuilder() {
        }

        @Generated
        public OCIManifestLayerBuilder mediaType(String mediaType) {
            this.mediaType = mediaType;
            return this;
        }

        @Generated
        public OCIManifestLayerBuilder digest(String digest) {
            this.digest = digest;
            return this;
        }

        @Generated
        public OCIManifestLayerBuilder size(long size) {
            this.size = size;
            return this;
        }

        @Generated
        public OCIManifestLayer build() {
            return new OCIManifestLayer(this.mediaType, this.digest, this.size);
        }

        @Generated
        public String toString() {
            return "OCIManifestLayer.OCIManifestLayerBuilder(mediaType=" + this.mediaType + ", digest=" + this.digest + ", size=" + this.size + ")";
        }
    }
}

