/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.resource.helm.oci;

import io.fabric8.kubernetes.client.http.HttpClient;
import io.fabric8.kubernetes.client.http.HttpRequest;
import io.fabric8.kubernetes.client.http.HttpResponse;
import io.fabric8.kubernetes.client.utils.URLUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.apache.commons.io.input.BoundedInputStream;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jkube.kit.common.util.AsyncUtil;
import org.eclipse.jkube.kit.common.util.Serialization;
import org.eclipse.jkube.kit.resource.helm.BadUploadException;
import org.eclipse.jkube.kit.resource.helm.Chart;
import org.eclipse.jkube.kit.resource.helm.HelmRepository;
import org.eclipse.jkube.kit.resource.helm.oci.OCIManifest;
import org.eclipse.jkube.kit.resource.helm.oci.OCIManifestLayer;
import org.eclipse.jkube.kit.resource.helm.oci.OCIRegistryEndpoint;

public class OCIRegistryClient {
    private static final String DOCKER_CONTENT_DIGEST = "Docker-Content-Digest";
    private static final String USER_AGENT = "EclipseJKube";
    private static final String OCI_IMAGE_MANIFEST_MEDIA_TYPE = "application/vnd.oci.image.manifest.v1+json";
    private static final String HELM_CONFIG_MEDIA_TYPE = "application/vnd.cncf.helm.config.v1+json";
    private static final String HELM_CHART_CONTENT_MEDIA_TYPE = "application/vnd.cncf.helm.chart.content.v1.tar+gzip";
    private static final String LOCATION_HEADER = "Location";
    private static final long OCI_UPLOAD_HTTP_REQUEST_TIMEOUT = 30L;
    private final OCIRegistryEndpoint ociRegistryEndpoint;
    private final HttpClient httpClient;

    public OCIRegistryClient(HelmRepository repository, HttpClient httpClient) {
        this.ociRegistryEndpoint = new OCIRegistryEndpoint(repository);
        this.httpClient = httpClient;
    }

    public void uploadOCIManifest(Chart chart, OCIManifestLayer chartConfig, OCIManifestLayer chartTarball) throws IOException, BadUploadException {
        byte[] manifestPayload = OCIRegistryClient.createChartManifestPayload(chartConfig, chartTarball).getBytes(StandardCharsets.UTF_8);
        try (ByteArrayInputStream requestBodyInputStream = new ByteArrayInputStream(manifestPayload);){
            HttpRequest httpRequest = this.newRequest().uri(this.ociRegistryEndpoint.getManifestUrl(chart)).method("PUT", OCI_IMAGE_MANIFEST_MEDIA_TYPE, (InputStream)requestBodyInputStream, (long)manifestPayload.length).build();
            HttpResponse response = (HttpResponse)AsyncUtil.get((CompletableFuture)this.httpClient.sendAsync(httpRequest, byte[].class), (Duration)Duration.ofMinutes(30L));
            if (!response.isSuccessful()) {
                OCIRegistryClient.handleFailure((HttpResponse<byte[]>)response);
            }
            OCIRegistryClient.extractDockerContentDigestFromResponseHeaders((HttpResponse<byte[]>)response);
        }
    }

    public OCIManifestLayer uploadBlobIfNotUploadedYet(Chart chart, InputStream inputStream) throws IOException, BadUploadException {
        try (BoundedInputStream blobStream = new BoundedInputStream(inputStream);){
            OCIManifestLayer ociBlob = OCIManifestLayer.from(blobStream);
            if (this.isLayerUploadedAlready(chart, ociBlob)) {
                OCIManifestLayer oCIManifestLayer = ociBlob;
                return oCIManifestLayer;
            }
            String uploadUrl = this.initiateUploadProcess(chart);
            OCIManifestLayer oCIManifestLayer = this.uploadBlob(uploadUrl, blobStream);
            return oCIManifestLayer;
        }
    }

    private boolean isLayerUploadedAlready(Chart chart, OCIManifestLayer blob) {
        HttpRequest httpRequest = this.newRequest().uri(this.ociRegistryEndpoint.getBlobUrl(chart, blob)).build();
        HttpResponse response = (HttpResponse)AsyncUtil.get((CompletableFuture)this.httpClient.sendAsync(httpRequest, byte[].class), (Duration)Duration.ofMinutes(30L));
        return response.code() == 200;
    }

    private String initiateUploadProcess(Chart chart) {
        HttpRequest httpRequest = this.newRequest().uri(this.ociRegistryEndpoint.getBlobUploadInitUrl(chart)).post("application/json", "").build();
        HttpResponse response = (HttpResponse)AsyncUtil.get((CompletableFuture)this.httpClient.sendAsync(httpRequest, byte[].class), (Duration)Duration.ofMinutes(30L));
        int responseCode = response.code();
        if (responseCode != 202) {
            throw new IllegalStateException("Failure in initiating upload request: " + response.message());
        }
        String locationHeader = this.parseLocationHeaderFromResponse((HttpResponse<byte[]>)response);
        if (StringUtils.isBlank((CharSequence)locationHeader)) {
            throw new IllegalStateException(String.format("No %s header found in upload initiation response", LOCATION_HEADER));
        }
        return locationHeader;
    }

    private OCIManifestLayer uploadBlob(String uploadUrl, BoundedInputStream blobStream) throws IOException, BadUploadException {
        OCIManifestLayer ociBlob = OCIManifestLayer.from(blobStream);
        HttpRequest httpRequest = this.newRequest().url(new URLUtils.URLBuilder(uploadUrl).addQueryParameter("digest", ociBlob.getDigest()).build()).method("PUT", "application/octet-stream", (InputStream)blobStream, ociBlob.getSize()).build();
        HttpResponse response = (HttpResponse)AsyncUtil.get((CompletableFuture)this.httpClient.sendAsync(httpRequest, byte[].class), (Duration)Duration.ofMinutes(30L));
        if (!response.isSuccessful()) {
            OCIRegistryClient.handleFailure((HttpResponse<byte[]>)response);
        }
        String dockerContentDigest = OCIRegistryClient.extractDockerContentDigestFromResponseHeaders((HttpResponse<byte[]>)response);
        if (!ociBlob.getDigest().equals(dockerContentDigest)) {
            throw new BadUploadException(String.format("Digest mismatch. Expected %s, got %s", ociBlob.getDigest(), dockerContentDigest));
        }
        return ociBlob;
    }

    private HttpRequest.Builder newRequest() {
        return this.httpClient.newHttpRequestBuilder().header("Host", this.ociRegistryEndpoint.getOCIRegistryHost()).header("User-Agent", USER_AGENT);
    }

    private String parseLocationHeaderFromResponse(HttpResponse<byte[]> response) {
        String locationHeader = response.header(LOCATION_HEADER);
        if (locationHeader != null && locationHeader.startsWith("/")) {
            locationHeader = this.ociRegistryEndpoint.getBaseUrl() + locationHeader;
        }
        return locationHeader;
    }

    private static void handleFailure(HttpResponse<byte[]> response) throws BadUploadException {
        String responseStr = Optional.ofNullable(response.body()).map(String::new).orElse(Optional.ofNullable(response.message()).orElse("No details provided"));
        throw new BadUploadException(response.code() + ": " + responseStr);
    }

    private static String extractDockerContentDigestFromResponseHeaders(HttpResponse<byte[]> response) throws BadUploadException {
        String dockerContentDigest = response.header(DOCKER_CONTENT_DIGEST);
        if (StringUtils.isNotBlank((CharSequence)dockerContentDigest)) {
            return dockerContentDigest;
        }
        throw new BadUploadException("No Docker-Content-Digest header found in upload response");
    }

    private static String createChartManifestPayload(OCIManifestLayer chartConfig, OCIManifestLayer chartTarball) {
        return Serialization.asJson((Object)OCIManifest.builder().schemaVersion(2).config(chartConfig.toBuilder().mediaType(HELM_CONFIG_MEDIA_TYPE).build()).layer(chartTarball.toBuilder().mediaType(HELM_CHART_CONTENT_MEDIA_TYPE).build()).build());
    }
}

