/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.micronaut;

import java.net.URL;
import java.net.URLClassLoader;
import java.util.Properties;
import java.util.function.Supplier;
import org.eclipse.jkube.kit.common.util.PropertiesUtil;
import org.eclipse.jkube.kit.common.util.YamlUtil;

public class MicronautUtils {
    private MicronautUtils() {
    }

    public static String extractPort(Properties properties, String defaultValue) {
        return properties.getProperty("micronaut.server.port", defaultValue);
    }

    public static boolean isHealthEnabled(Properties properties) {
        return properties.getProperty("endpoints.health.enabled", "false").equalsIgnoreCase("true");
    }

    public static Properties getMicronautConfiguration(URLClassLoader urlClassLoader) {
        Supplier[] sources;
        for (Supplier source : sources = new Supplier[]{() -> PropertiesUtil.getPropertiesFromResource((URL)urlClassLoader.findResource("application.properties")), () -> YamlUtil.getPropertiesFromYamlResource((URL)urlClassLoader.findResource("application.yml")), () -> YamlUtil.getPropertiesFromYamlResource((URL)urlClassLoader.findResource("application.json"))}) {
            Properties props = (Properties)source.get();
            if (props.isEmpty()) continue;
            return props;
        }
        return new Properties();
    }
}

