/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.micronaut;

import java.util.Properties;
import org.eclipse.jkube.kit.common.JavaProject;
import org.eclipse.jkube.kit.common.util.JKubeProjectUtil;
import org.eclipse.jkube.kit.common.util.PropertiesUtil;

public class MicronautUtils {
    private static final String[] MICRONAUT_APP_CONFIG_FILES_LIST = new String[]{"application.properties", "application.yml", "application.yaml", "application.json"};

    private MicronautUtils() {
    }

    public static String extractPort(Properties properties, String defaultValue) {
        return properties.getProperty("micronaut.server.port", defaultValue);
    }

    public static boolean isHealthEnabled(Properties properties) {
        return properties.getProperty("endpoints.health.enabled", "false").equalsIgnoreCase("true");
    }

    public static Properties getMicronautConfiguration(JavaProject javaProject) {
        return PropertiesUtil.fromApplicationConfig((JavaProject)javaProject, (String[])MICRONAUT_APP_CONFIG_FILES_LIST);
    }

    public static boolean hasMicronautPlugin(JavaProject javaProject) {
        return JKubeProjectUtil.hasPlugin((JavaProject)javaProject, (String)"io.micronaut.build", (String)"micronaut-maven-plugin") || JKubeProjectUtil.hasPlugin((JavaProject)javaProject, (String)"io.micronaut.maven", (String)"micronaut-maven-plugin") || JKubeProjectUtil.hasPlugin((JavaProject)javaProject, (String)"io.micronaut.application", (String)"io.micronaut.application.gradle.plugin");
    }

    public static boolean hasNativeImagePackaging(JavaProject javaProject) {
        if (javaProject != null) {
            if (javaProject.getProperties() != null && javaProject.getProperties().getProperty("packaging") != null && javaProject.getProperties().getProperty("packaging").equals("native-image")) {
                return true;
            }
            return javaProject.getGradlePlugins() != null && javaProject.getGradlePlugins().contains("org.graalvm.buildtools.gradle.NativeImagePlugin");
        }
        return false;
    }
}

