/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.micronaut.generator;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import org.eclipse.jkube.generator.api.GeneratorContext;
import org.eclipse.jkube.generator.javaexec.JavaExecGenerator;
import org.eclipse.jkube.kit.common.Arguments;
import org.eclipse.jkube.kit.common.AssemblyConfiguration;
import org.eclipse.jkube.kit.config.image.ImageConfiguration;
import org.eclipse.jkube.micronaut.MicronautUtils;
import org.eclipse.jkube.micronaut.generator.MicronautNestedGenerator;

public class MicronautGenerator
extends JavaExecGenerator {
    private final MicronautNestedGenerator nestedGenerator;
    private final Properties micronautApplicationConfiguration;

    public MicronautGenerator(GeneratorContext context) {
        super(context, "micronaut");
        this.nestedGenerator = MicronautNestedGenerator.from(context, this.getGeneratorConfig());
        this.micronautApplicationConfiguration = MicronautUtils.getMicronautConfiguration(this.getContext().getProject());
        this.log.debug("Micronaut Application Config loaded from: %s", new Object[]{this.micronautApplicationConfiguration.get("jkube.internal.application-config-file.path")});
    }

    public boolean isApplicable(List<ImageConfiguration> configs) {
        return this.shouldAddGeneratedImageConfiguration(configs) && MicronautUtils.hasMicronautPlugin(this.getProject());
    }

    protected Map<String, String> getEnv(boolean prePackagePhase) {
        return this.nestedGenerator.getEnv(ppp -> super.getEnv(ppp.booleanValue()), prePackagePhase);
    }

    protected String getDefaultJolokiaPort() {
        return this.nestedGenerator.getDefaultJolokiaPort();
    }

    protected String getDefaultPrometheusPort() {
        return this.nestedGenerator.getDefaultPrometheusPort();
    }

    protected String getBuildWorkdir() {
        return this.nestedGenerator.getBuildWorkdir();
    }

    protected String getFromAsConfigured() {
        return Optional.ofNullable(super.getFromAsConfigured()).orElse(this.nestedGenerator.getFrom());
    }

    protected Arguments getBuildEntryPoint() {
        return this.nestedGenerator.getBuildEntryPoint();
    }

    protected AssemblyConfiguration createAssembly() {
        return Optional.ofNullable(this.nestedGenerator.createAssemblyConfiguration(this.addAdditionalFiles())).orElse(super.createAssembly());
    }

    protected String getDefaultWebPort() {
        return MicronautUtils.extractPort(this.micronautApplicationConfiguration, super.getDefaultWebPort());
    }
}

