/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.micronaut.enricher;

import io.fabric8.kubernetes.api.model.Probe;
import io.fabric8.kubernetes.api.model.ProbeBuilder;
import io.fabric8.kubernetes.api.model.ProbeFluent;
import java.util.Collections;
import org.eclipse.jkube.kit.common.Configs;
import org.eclipse.jkube.kit.common.JavaProject;
import org.eclipse.jkube.kit.common.util.JKubeProjectUtil;
import org.eclipse.jkube.kit.config.image.ImageConfiguration;
import org.eclipse.jkube.kit.config.image.build.BuildConfiguration;
import org.eclipse.jkube.kit.enricher.api.EnricherContext;
import org.eclipse.jkube.kit.enricher.api.JKubeEnricherContext;
import org.eclipse.jkube.kit.enricher.specific.AbstractHealthCheckEnricher;
import org.eclipse.jkube.micronaut.MicronautUtils;

public class MicronautHealthCheckEnricher
extends AbstractHealthCheckEnricher {
    public MicronautHealthCheckEnricher(JKubeEnricherContext buildContext) {
        super((EnricherContext)buildContext, "jkube-healthcheck-micronaut");
    }

    protected Probe getReadinessProbe() {
        return this.buildProbe(this.toInteger(Config.READINESS_PROBE_INITIAL_DELAY_SECONDS), this.toInteger(Config.READINESS_PROBE_PERIOD_SECONDS));
    }

    protected Probe getLivenessProbe() {
        return this.buildProbe(this.toInteger(Config.LIVENESS_PROBE_INITIAL_DELAY_SECONDS), this.toInteger(Config.LIVENESS_PROBE_PERIOD_SECONDS));
    }

    private boolean isApplicable() {
        if (!this.getContext().hasPlugin("io.micronaut.build", "micronaut-maven-plugin")) {
            return false;
        }
        return MicronautUtils.isHealthEnabled(MicronautUtils.getMicronautConfiguration(JKubeProjectUtil.getClassLoader((JavaProject)this.getContext().getProject())));
    }

    private Probe buildProbe(Integer initialDelaySeconds, Integer periodSeconds) {
        if (!this.isApplicable()) {
            return null;
        }
        String firstImagePort = this.getImages().stream().findFirst().map(ImageConfiguration::getBuild).map(BuildConfiguration::getPorts).orElse(Collections.emptyList()).stream().findFirst().orElse(null);
        return ((ProbeBuilder)((ProbeFluent.HttpGetNested)((ProbeFluent.HttpGetNested)((ProbeFluent.HttpGetNested)((ProbeBuilder)((ProbeBuilder)((ProbeBuilder)((ProbeBuilder)((ProbeBuilder)new ProbeBuilder().withInitialDelaySeconds(initialDelaySeconds)).withPeriodSeconds(periodSeconds)).withFailureThreshold(this.toInteger(Config.FAILURE_THRESHOLD))).withSuccessThreshold(this.toInteger(Config.SUCCESS_THRESHOLD))).withTimeoutSeconds(this.toInteger(Config.TIMEOUT_SECONDS))).withNewHttpGet().withScheme(this.getConfig(Config.SCHEME))).withNewPort(Configs.asInteger((String)this.getConfig(Config.PORT, firstImagePort)))).withPath(this.getConfig(Config.PATH))).endHttpGet()).build();
    }

    private Integer toInteger(Config config) {
        return Configs.asInteger((String)this.getConfig(config));
    }

    private static enum Config implements Configs.Config
    {
        READINESS_PROBE_INITIAL_DELAY_SECONDS("readinessProbeInitialDelaySeconds", null),
        READINESS_PROBE_PERIOD_SECONDS("readinessProbePeriodSeconds", null),
        LIVENESS_PROBE_INITIAL_DELAY_SECONDS("livenessProbeInitialDelaySeconds", null),
        LIVENESS_PROBE_PERIOD_SECONDS("livenessProbePeriodSeconds", null),
        FAILURE_THRESHOLD("failureThreshold", "3"),
        SUCCESS_THRESHOLD("successThreshold", "1"),
        TIMEOUT_SECONDS("timeoutSeconds", null),
        SCHEME("scheme", "HTTP"),
        PORT("port", null),
        PATH("path", "/health");

        protected String key;
        protected String defaultValue;

        private Config(String key, String defaultValue) {
            this.key = key;
            this.defaultValue = defaultValue;
        }

        public String getKey() {
            return this.key;
        }

        public String getDefaultValue() {
            return this.defaultValue;
        }
    }
}

