/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.openliberty.enricher;

import io.fabric8.kubernetes.api.model.Probe;
import io.fabric8.kubernetes.api.model.ProbeBuilder;
import io.fabric8.kubernetes.api.model.ProbeFluent;
import org.eclipse.jkube.kit.common.Configs;
import org.eclipse.jkube.kit.common.JavaProject;
import org.eclipse.jkube.kit.common.util.MicroprofileHealthUtil;
import org.eclipse.jkube.kit.enricher.api.EnricherContext;
import org.eclipse.jkube.kit.enricher.api.JKubeEnricherContext;
import org.eclipse.jkube.kit.enricher.specific.AbstractHealthCheckEnricher;
import org.eclipse.jkube.openliberty.OpenLibertyUtils;

public class OpenLibertyHealthCheckEnricher
extends AbstractHealthCheckEnricher {
    public OpenLibertyHealthCheckEnricher(JKubeEnricherContext buildContext) {
        super((EnricherContext)buildContext, "jkube-healthcheck-openliberty");
    }

    protected Probe getReadinessProbe() {
        return this.discoverOpenLibertyHealthCheck(this.getConfig(Config.READINESS_PATH), this.getConfigAsInt(Config.READINESS_INITIAL_DELAY), this.getConfigAsInt(Config.READINESS_FAILURE_THRESHOLD), this.getConfigAsInt(Config.READINESS_SUCCESS_THRESHOLD), this.getConfigAsInt(Config.READINESS_PERIOD_SECONDS));
    }

    protected Probe getLivenessProbe() {
        return this.discoverOpenLibertyHealthCheck(this.getConfig(Config.LIVENESS_PATH), this.getConfigAsInt(Config.LIVENESS_INITIAL_DELAY), this.getConfigAsInt(Config.LIVENESS_FAILURE_THRESHOLD), this.getConfigAsInt(Config.LIVENESS_SUCCESS_THRESHOLD), this.getConfigAsInt(Config.LIVENESS_PERIOD_SECONDS));
    }

    protected Probe getStartupProbe() {
        if (MicroprofileHealthUtil.isStartupEndpointSupported((JavaProject)this.getContext().getProject())) {
            return this.discoverOpenLibertyHealthCheck(this.getConfig(Config.STARTUP_PATH), this.getConfigAsInt(Config.STARTUP_INITIAL_DELAY), this.getConfigAsInt(Config.STARTUP_FAILURE_THRESHOLD), this.getConfigAsInt(Config.STARTUP_SUCCESS_THRESHOLD), this.getConfigAsInt(Config.STARTUP_PERIOD_SECONDS));
        }
        return null;
    }

    private Probe discoverOpenLibertyHealthCheck(String path, int initialDelay, int failureThreshold, int successThreshold, int periodSeconds) {
        if (MicroprofileHealthUtil.hasMicroProfileDependency((JavaProject)this.getContext().getProject()) && OpenLibertyUtils.isMicroProfileHealthEnabled(this.getContext().getProject())) {
            return ((ProbeBuilder)((ProbeBuilder)((ProbeBuilder)((ProbeBuilder)((ProbeBuilder)((ProbeFluent.HttpGetNested)((ProbeFluent.HttpGetNested)((ProbeFluent.HttpGetNested)new ProbeBuilder().withNewHttpGet().withNewPort((Object)Configs.asInteger((String)this.getConfig(Config.PORT)))).withPath(path)).withScheme(this.getConfig(Config.SCHEME))).endHttpGet()).withFailureThreshold(Integer.valueOf(failureThreshold))).withSuccessThreshold(Integer.valueOf(successThreshold))).withInitialDelaySeconds(Integer.valueOf(initialDelay))).withPeriodSeconds(Integer.valueOf(periodSeconds))).build();
        }
        return null;
    }

    private int getConfigAsInt(Configs.Config key) {
        return Integer.parseInt(this.getConfig(key));
    }

    private static enum Config implements Configs.Config
    {
        SCHEME("scheme", "HTTP"),
        PORT("port", "9080"),
        LIVENESS_FAILURE_THRESHOLD("livenessFailureThreshold", "3"),
        LIVENESS_SUCCESS_THRESHOLD("livenessSuccessThreshold", "1"),
        LIVENESS_INITIAL_DELAY("livenessInitialDelay", "0"),
        LIVENESS_PERIOD_SECONDS("livenessPeriodSeconds", "10"),
        LIVENESS_PATH("livenessPath", "/health/live"),
        READINESS_FAILURE_THRESHOLD("readinessFailureThreshold", "3"),
        READINESS_SUCCESS_THRESHOLD("readinessSuccessThreshold", "1"),
        READINESS_INITIAL_DELAY("readinessInitialDelay", "0"),
        READINESS_PERIOD_SECONDS("readinessPeriodSeconds", "10"),
        READINESS_PATH("readinessPath", "/health/ready"),
        STARTUP_FAILURE_THRESHOLD("startupFailureThreshold", "3"),
        STARTUP_SUCCESS_THRESHOLD("startupSuccessThreshold", "1"),
        STARTUP_INITIAL_DELAY("startupInitialDelay", "0"),
        STARTUP_PERIOD_SECONDS("startupPeriodSeconds", "10"),
        STARTUP_PATH("startupPath", "/health/started");

        protected String key;
        protected String defaultValue;

        private Config(String key, String defaultValue) {
            this.key = key;
            this.defaultValue = defaultValue;
        }

        public String getKey() {
            return this.key;
        }

        public String getDefaultValue() {
            return this.defaultValue;
        }
    }
}

