/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.quarkus.generator;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.eclipse.jkube.generator.api.GeneratorContext;
import org.eclipse.jkube.generator.api.support.BaseGenerator;
import org.eclipse.jkube.kit.common.Assembly;
import org.eclipse.jkube.kit.common.AssemblyConfiguration;
import org.eclipse.jkube.kit.common.AssemblyFileSet;
import org.eclipse.jkube.kit.common.Configs;
import org.eclipse.jkube.kit.common.JavaProject;
import org.eclipse.jkube.kit.common.util.FileUtil;
import org.eclipse.jkube.kit.common.util.JKubeProjectUtil;
import org.eclipse.jkube.kit.config.image.ImageConfiguration;
import org.eclipse.jkube.kit.config.image.build.Arguments;
import org.eclipse.jkube.kit.config.image.build.BuildConfiguration;

public class QuarkusGenerator
extends BaseGenerator {
    public QuarkusGenerator(GeneratorContext context) {
        super(context, "quarkus");
    }

    public boolean isApplicable(List<ImageConfiguration> configs) {
        return this.shouldAddGeneratedImageConfiguration(configs) && JKubeProjectUtil.hasPlugin((JavaProject)this.getProject(), (String)"io.quarkus", (String)"quarkus-maven-plugin");
    }

    public List<ImageConfiguration> customize(List<ImageConfiguration> existingConfigs, boolean prePackagePhase) {
        ImageConfiguration.ImageConfigurationBuilder imageBuilder = ImageConfiguration.builder().name(this.getImageName()).registry(this.getRegistry()).alias(this.getAlias()).build(this.createBuildConfig(prePackagePhase));
        existingConfigs.add(imageBuilder.build());
        return existingConfigs;
    }

    private BuildConfiguration createBuildConfig(boolean prePackagePhase) {
        BuildConfiguration.BuildConfigurationBuilder buildBuilder = BuildConfiguration.builder();
        buildBuilder.port(this.getConfig(Config.WEB_PORT));
        this.addSchemaLabels(buildBuilder, this.log);
        boolean isNative = Boolean.parseBoolean(this.getConfig(Config.NATIVE_IMAGE));
        Optional<String> fromConfigured = Optional.ofNullable(this.getFromAsConfigured());
        if (isNative) {
            buildBuilder.from(fromConfigured.orElse("registry.access.redhat.com/ubi8/ubi-minimal:8.1")).entryPoint(Arguments.builder().execArgument("./" + this.findSingleFileThatEndsWith("-runner")).execArgument("-Dquarkus.http.host=0.0.0.0").build()).workdir("/");
            if (!prePackagePhase) {
                buildBuilder.assembly(this.createAssemblyConfiguration("/", this.getNativeFileToInclude()));
            }
        } else {
            buildBuilder.from(fromConfigured.orElse("openjdk:11")).entryPoint(Arguments.builder().execArgument("java").execArgument("-Dquarkus.http.host=0.0.0.0").execArgument("-jar").execArgument(this.findSingleFileThatEndsWith("-runner.jar")).build()).workdir("/opt");
            if (!prePackagePhase) {
                buildBuilder.assembly(this.createAssemblyConfiguration("/opt", this.getJvmFilesToInclude()));
            }
        }
        this.addLatestTagIfSnapshot(buildBuilder);
        return buildBuilder.build();
    }

    private AssemblyConfiguration createAssemblyConfiguration(String targetDir, AssemblyFileSet jKubeAssemblyFileSet) {
        jKubeAssemblyFileSet.setOutputDirectory(".");
        return AssemblyConfiguration.builder().targetDir(targetDir).inline(Assembly.builder().fileSet(jKubeAssemblyFileSet).build()).build();
    }

    private AssemblyFileSet getJvmFilesToInclude() {
        AssemblyFileSet.AssemblyFileSetBuilder fileSetBuilder = this.getFileSetWithFileFromBuildThatEndsWith("-runner.jar");
        fileSetBuilder.include("lib");
        File defaultJarFile = JKubeProjectUtil.getFinalOutputArtifact((JavaProject)this.getContext().getProject());
        if (defaultJarFile != null) {
            fileSetBuilder.exclude(defaultJarFile.getName());
        }
        fileSetBuilder.fileMode("0640");
        return fileSetBuilder.build();
    }

    private AssemblyFileSet getNativeFileToInclude() {
        return this.getFileSetWithFileFromBuildThatEndsWith("-runner").fileMode("0755").build();
    }

    private AssemblyFileSet.AssemblyFileSetBuilder getFileSetWithFileFromBuildThatEndsWith(String suffix) {
        ArrayList<String> relativePaths = new ArrayList<String>();
        String fileToInclude = this.findSingleFileThatEndsWith(suffix);
        if (fileToInclude != null && !fileToInclude.isEmpty()) {
            relativePaths.add(fileToInclude);
        }
        return AssemblyFileSet.builder().directory(FileUtil.getRelativePath((File)this.getProject().getBaseDirectory(), (File)this.getProject().getBuildDirectory())).includes(relativePaths).fileMode("0777");
    }

    private String findSingleFileThatEndsWith(String suffix) {
        File buildDir = this.getProject().getBuildDirectory();
        String[] file = buildDir.list((dir, name) -> name.endsWith(suffix));
        if (file == null || file.length != 1) {
            throw new IllegalStateException("Can't find single file with suffix '" + suffix + "' in " + buildDir + " (zero or more than one files found ending with '" + suffix + "')");
        }
        return file[0];
    }

    public static enum Config implements Configs.Config
    {
        WEB_PORT("webPort", "8080"),
        NATIVE_IMAGE("nativeImage", "false");

        protected String key;
        protected String defaultValue;

        private Config(String key, String defaultValue) {
            this.key = key;
            this.defaultValue = defaultValue;
        }

        public String getKey() {
            return this.key;
        }

        public String getDefaultValue() {
            return this.defaultValue;
        }
    }
}

