/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.quarkus.generator;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jkube.generator.api.GeneratorContext;
import org.eclipse.jkube.generator.javaexec.JavaExecGenerator;
import org.eclipse.jkube.kit.common.Assembly;
import org.eclipse.jkube.kit.common.AssemblyConfiguration;
import org.eclipse.jkube.kit.common.AssemblyFileSet;
import org.eclipse.jkube.kit.common.Configs;
import org.eclipse.jkube.kit.common.JavaProject;
import org.eclipse.jkube.kit.common.util.FileUtil;
import org.eclipse.jkube.kit.common.util.JKubeProjectUtil;
import org.eclipse.jkube.kit.config.image.ImageConfiguration;
import org.eclipse.jkube.kit.config.image.build.Arguments;
import org.eclipse.jkube.kit.config.resource.RuntimeMode;

public class QuarkusGenerator
extends JavaExecGenerator {
    public QuarkusGenerator(GeneratorContext context) {
        super(context, "quarkus");
    }

    public boolean isApplicable(List<ImageConfiguration> configs) {
        return this.shouldAddGeneratedImageConfiguration(configs) && JKubeProjectUtil.hasPlugin((JavaProject)this.getProject(), (String)"io.quarkus", (String)"quarkus-maven-plugin");
    }

    protected List<String> extractPorts() {
        if (this.isNativeImage()) {
            return new ArrayList<String>(Collections.singletonList(this.getConfig((Configs.Config)JavaExecGenerator.Config.WEB_PORT)));
        }
        return super.extractPorts();
    }

    protected String getFromAsConfigured() {
        if (this.isNativeImage()) {
            return Optional.ofNullable(super.getFromAsConfigured()).orElse(this.getNativeFrom());
        }
        return super.getFromAsConfigured();
    }

    protected AssemblyConfiguration createAssembly() {
        if (this.isNativeImage()) {
            return this.createAssemblyConfiguration("/", this.getNativeFileToInclude());
        }
        return this.createAssemblyConfiguration(this.getConfig((Configs.Config)JavaExecGenerator.Config.TARGET_DIR), this.getJvmFilesToInclude());
    }

    protected String getBuildWorkdir() {
        if (this.isNativeImage()) {
            return "/";
        }
        return this.getConfig((Configs.Config)JavaExecGenerator.Config.TARGET_DIR);
    }

    protected Arguments getBuildEntryPoint() {
        if (this.isNativeImage()) {
            Arguments.ArgumentsBuilder ab = Arguments.builder();
            ab.execArgument("./" + this.findSingleFileThatEndsWith("-runner"));
            this.getExtraJavaOptions().forEach(arg_0 -> ((Arguments.ArgumentsBuilder)ab).execArgument(arg_0));
            return ab.build();
        }
        return null;
    }

    protected boolean isFatJar() {
        return false;
    }

    protected Map<String, String> getEnv(boolean prePackagePhase) {
        HashMap<String, String> env = new HashMap<String, String>();
        env.put("JAVA_OPTIONS", StringUtils.join(QuarkusGenerator.getJavaOptions(), (String)" "));
        return env;
    }

    private static List<String> getJavaOptions() {
        return Collections.singletonList("-Dquarkus.http.host=0.0.0.0");
    }

    private boolean isNativeImage() {
        return Boolean.parseBoolean(this.getConfig(Config.NATIVE_IMAGE));
    }

    private String getNativeFrom() {
        if (this.getContext().getRuntimeMode() != RuntimeMode.OPENSHIFT) {
            return "registry.access.redhat.com/ubi8/ubi-minimal:8.1";
        }
        return "quay.io/quarkus/ubi-quarkus-native-binary-s2i:1.0";
    }

    private AssemblyConfiguration createAssemblyConfiguration(String targetDir, AssemblyFileSet jKubeAssemblyFileSet) {
        jKubeAssemblyFileSet.setOutputDirectory(".");
        return AssemblyConfiguration.builder().targetDir(targetDir).excludeFinalOutputArtifact(true).inline(Assembly.builder().fileSet(jKubeAssemblyFileSet).build()).build();
    }

    private AssemblyFileSet getJvmFilesToInclude() {
        AssemblyFileSet.AssemblyFileSetBuilder fileSetBuilder = this.getFileSetWithFileFromBuildThatEndsWith("-runner.jar");
        fileSetBuilder.include("lib");
        File defaultJarFile = JKubeProjectUtil.getFinalOutputArtifact((JavaProject)this.getContext().getProject());
        if (defaultJarFile != null) {
            fileSetBuilder.exclude(defaultJarFile.getName());
        }
        fileSetBuilder.fileMode("0640");
        return fileSetBuilder.build();
    }

    private AssemblyFileSet getNativeFileToInclude() {
        return this.getFileSetWithFileFromBuildThatEndsWith("-runner").fileMode("0755").build();
    }

    private AssemblyFileSet.AssemblyFileSetBuilder getFileSetWithFileFromBuildThatEndsWith(String suffix) {
        ArrayList<String> relativePaths = new ArrayList<String>();
        String fileToInclude = this.findSingleFileThatEndsWith(suffix);
        if (fileToInclude != null && !fileToInclude.isEmpty()) {
            relativePaths.add(fileToInclude);
        }
        return AssemblyFileSet.builder().directory(FileUtil.getRelativePath((File)this.getProject().getBaseDirectory(), (File)this.getProject().getBuildDirectory())).includes(relativePaths).fileMode("0777");
    }

    private String findSingleFileThatEndsWith(String suffix) {
        File buildDir = this.getProject().getBuildDirectory();
        String[] file = buildDir.list((dir, name) -> name.endsWith(suffix));
        if (file == null || file.length != 1) {
            throw new IllegalStateException("Can't find single file with suffix '" + suffix + "' in " + buildDir + " (zero or more than one files found ending with '" + suffix + "')");
        }
        return file[0];
    }

    public static enum Config implements Configs.Config
    {
        NATIVE_IMAGE("nativeImage", "false");

        protected String key;
        protected String defaultValue;

        private Config(String key, String defaultValue) {
            this.key = key;
            this.defaultValue = defaultValue;
        }

        public String getKey() {
            return this.key;
        }

        public String getDefaultValue() {
            return this.defaultValue;
        }
    }
}

